/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.DefaultJavaProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.maven.embedder.MavenConsole;
import org.jetbrains.idea.maven.execution.MavenExecutor;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;

public class MavenExternalExecutor
extends MavenExecutor {
    private OSProcessHandler myProcessHandler;
    @NonNls
    private static final String PHASE_INFO_REGEXP = "\\[INFO\\] \\[.*:.*\\]";
    @NonNls
    private static final int INFO_PREFIX_SIZE = "[INFO] ".length();

    public MavenExternalExecutor(MavenRunnerParameters parameters, MavenGeneralSettings coreSettings, MavenRunnerSettings runnerSettings, MavenConsole console) {
        super(parameters, coreSettings, runnerSettings, RunnerBundle.message("external.executor.caption", new Object[0]), console);
    }

    @Override
    public boolean execute(final ProgressIndicator indicator) {
        this.displayProgress();
        try {
            this.myProcessHandler = new DefaultJavaProcessHandler(MavenExternalParameters.createJavaParameters(this.myParameters, this.myCoreSettings, this.myRunnerSettings)){

                public void notifyTextAvailable(String text, Key outputType) {
                    if (!MavenExternalExecutor.this.myConsole.isSuppressed(text)) {
                        super.notifyTextAvailable(text, outputType);
                    }
                    MavenExternalExecutor.this.updateProgress(indicator, text);
                }
            };
            this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        }
        catch (ExecutionException e) {
            this.myConsole.systemMessage(4, RunnerBundle.message("external.startup.failed", e.getMessage()), null);
            return false;
        }
        this.start();
        this.readProcessOutput();
        this.stop();
        return this.printExitSummary();
    }

    @Override
    void stop() {
        if (this.myProcessHandler != null) {
            this.myProcessHandler.destroyProcess();
            this.myProcessHandler.waitFor();
            this.setExitCode(this.myProcessHandler.getProcess().exitValue());
        }
        super.stop();
    }

    private void readProcessOutput() {
        this.myProcessHandler.startNotify();
        this.myProcessHandler.waitFor();
    }

    private void updateProgress(ProgressIndicator indicator, String text) {
        if (indicator != null) {
            if (indicator.isCanceled() && !this.isCancelled()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MavenExternalExecutor.this.cancel();
                    }
                });
            }
            if (text.matches(PHASE_INFO_REGEXP)) {
                indicator.setText2(text.substring(INFO_PREFIX_SIZE));
            }
        }
    }
}

