/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleReference
extends PsiReferenceBase<PsiElement>
implements PsiPolyVariantReference,
BundleNameEvaluator {
    private String myBundleName = this.getValue();

    public ResourceBundleReference(PsiElement element) {
        this(element, false);
    }

    public ResourceBundleReference(PsiElement element, boolean soft) {
        super(element, soft);
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PropertiesReferenceManager referenceManager = PropertiesReferenceManager.getInstance(this.myElement.getProject());
        List<PropertiesFile> propertiesFiles = referenceManager.findPropertiesFiles(this.myElement.getResolveScope(), this.myBundleName, this);
        ResolveResult[] result = new ResolveResult[propertiesFiles.size()];
        for (int i = 0; i < propertiesFiles.size(); ++i) {
            PropertiesFile file = propertiesFiles.get(i);
            result[i] = new PsiElementResolveResult((PsiElement)file);
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/ResourceBundleReference.multiResolve must not return null");
        }
        return result;
    }

    public String getCanonicalText() {
        return this.myBundleName;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        int index;
        if (newElementName.endsWith(".properties")) {
            newElementName = newElementName.substring(0, newElementName.lastIndexOf(".properties"));
        }
        if ((index = this.myBundleName.lastIndexOf(46)) != -1) {
            newElementName = this.myBundleName.substring(0, index) + "." + newElementName;
        }
        return super.handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/ResourceBundleReference.bindToElement must not be null");
        }
        if (!(element instanceof PropertiesFile)) {
            throw new IncorrectOperationException();
        }
        String name = PropertiesUtil.getFullName((PropertiesFile)element);
        return super.handleElementRename(name);
    }

    public boolean isReferenceTo(PsiElement element) {
        String name;
        return element instanceof PropertiesFile && (name = PropertiesUtil.getFullName((PropertiesFile)element)) != null && name.equals(this.myBundleName);
    }

    @NotNull
    public Object[] getVariants() {
        PropertiesReferenceManager referenceManager = PropertiesReferenceManager.getInstance(this.getElement().getProject());
        Object[] objectArray = referenceManager.getPropertyFileBaseNames(this.myElement.getResolveScope(), this);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/ResourceBundleReference.getVariants must not return null");
        }
        return objectArray;
    }

    @Override
    public String evaluateBundleName(PsiFile psiFile) {
        return BundleNameEvaluator.DEFAULT.evaluateBundleName(psiFile);
    }
}

