/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PropertyFileIndex;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PropertiesFilesManager
extends AbstractProjectComponent {
    public static PropertiesFilesManager getInstance(Project project) {
        return (PropertiesFilesManager)((Object)project.getComponent(PropertiesFilesManager.class));
    }

    public PropertiesFilesManager(Project project) {
        super(project);
    }

    public void projectOpened() {
        final PropertyChangeListener myListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("native2ascii".equals(evt.getPropertyName()) || "propertiesFilesEncoding".equals(evt.getPropertyName())) {
                    DumbService.getInstance((Project)PropertiesFilesManager.this.myProject).smartInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    if (PropertiesFilesManager.this.myProject.isDisposed()) {
                                        return;
                                    }
                                    Collection<VirtualFile> filesToRefresh = PropertiesFilesManager.this.getAllPropertiesFiles();
                                    VirtualFile[] virtualFiles = VfsUtil.toVirtualFileArray(filesToRefresh);
                                    FileDocumentManager.getInstance().saveAllDocuments();
                                    for (VirtualFile virtualFile : virtualFiles) {
                                        virtualFile.setCharset(null);
                                    }
                                    FileDocumentManager.getInstance().reloadFiles(virtualFiles);
                                }
                            });
                        }
                    });
                }
            }
        };
        EncodingManager.getInstance().addPropertyChangeListener(myListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                EncodingManager.getInstance().removePropertyChangeListener(myListener);
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("PropertiesFileManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesFilesManager.getComponentName must not return null");
        }
        return "PropertiesFileManager";
    }

    public Collection<VirtualFile> getAllPropertiesFiles() {
        return FileBasedIndex.getInstance().getContainingFiles(PropertyFileIndex.NAME, (Object)PropertiesFileType.FILE_TYPE.getName(), GlobalSearchScope.allScope((Project)this.myProject));
    }

    public boolean processAllPropertiesFiles(final Processor<VirtualFile> processor) {
        return FileBasedIndex.getInstance().processValues(PropertyFileIndex.NAME, (Object)PropertiesFileType.FILE_TYPE.getName(), null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Void>(){

            public boolean process(VirtualFile file, Void value) {
                return processor.process((Object)file);
            }
        }, GlobalSearchScope.allScope((Project)this.myProject));
    }
}

