/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.ui.BaseControl;
import com.intellij.util.xml.ui.BooleanColumnInfo;
import com.intellij.util.xml.ui.BooleanControl;
import com.intellij.util.xml.ui.CaptionComponent;
import com.intellij.util.xml.ui.ComboControl;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.DomCollectionControl;
import com.intellij.util.xml.ui.DomCollectionWrapper;
import com.intellij.util.xml.ui.DomFixedWrapper;
import com.intellij.util.xml.ui.DomStringWrapper;
import com.intellij.util.xml.ui.DomUIControl;
import com.intellij.util.xml.ui.DomWrapper;
import com.intellij.util.xml.ui.GenericValueColumnInfo;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import com.intellij.util.xml.ui.StringColumnInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomUIFactory {
    public static Method GET_VALUE_METHOD = ReflectionUtil.getMethod(GenericDomValue.class, (String)"getValue", (Class[])new Class[0]);
    public static Method SET_VALUE_METHOD = DomUIFactory.findMethod(GenericDomValue.class, "setValue");
    public static Method GET_STRING_METHOD = ReflectionUtil.getMethod(GenericDomValue.class, (String)"getStringValue", (Class[])new Class[0]);
    public static Method SET_STRING_METHOD = DomUIFactory.findMethod(GenericDomValue.class, "setStringValue");

    @NotNull
    public static DomUIControl<GenericDomValue> createControl(GenericDomValue element) {
        DomUIControl<GenericDomValue> domUIControl = DomUIFactory.createControl(element, false);
        if (domUIControl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/DomUIFactory.createControl must not return null");
        }
        return domUIControl;
    }

    @NotNull
    public static DomUIControl<GenericDomValue> createControl(GenericDomValue element, boolean commitOnEveryChange) {
        BaseControl baseControl = DomUIFactory.createGenericValueControl(DomUtil.getGenericValueParameter(element.getDomElementType()), element, commitOnEveryChange);
        if (baseControl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/DomUIFactory.createControl must not return null");
        }
        return baseControl;
    }

    public static DomUIControl createSmallDescriptionControl(DomElement parent, boolean commitOnEveryChange) {
        return DomUIFactory.createLargeDescriptionControl(parent, commitOnEveryChange);
    }

    public static DomUIControl createLargeDescriptionControl(DomElement parent, boolean commitOnEveryChange) {
        return DomUIFactory.getDomUIFactory().createTextControl(new DomCollectionWrapper<String>(parent, parent.getGenericInfo().getCollectionChildDescription("description")), commitOnEveryChange);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static BaseControl createGenericValueControl(Type type, GenericDomValue<?> element, boolean commitOnEveryChange) {
        BaseControl baseControl;
        DomStringWrapper stringWrapper = new DomStringWrapper(element);
        Class rawType = ReflectionUtil.getRawType((Type)type);
        if (type instanceof Class && Enum.class.isAssignableFrom(rawType)) {
            baseControl = new ComboControl((DomWrapper<String>)stringWrapper, rawType);
            if (baseControl == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/DomUIFactory.createGenericValueControl must not return null");
            return baseControl;
        }
        if (DomElement.class.isAssignableFrom(rawType)) {
            ComboControl control = new ComboControl(element);
            Required annotation = element.getAnnotation(Required.class);
            if (annotation == null || !annotation.value() || !annotation.nonEmpty()) {
                control.setNullable(true);
            }
            if ((baseControl = control) == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/DomUIFactory.createGenericValueControl must not return null");
            return baseControl;
        }
        DomFixedWrapper<Boolean> wrapper = new DomFixedWrapper<Boolean>(element);
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            baseControl = new BooleanControl((DomWrapper<Boolean>)wrapper);
            if (baseControl == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/DomUIFactory.createGenericValueControl must not return null");
            return baseControl;
        }
        if (type.equals(String.class)) {
            baseControl = DomUIFactory.getDomUIFactory().createTextControl(wrapper, commitOnEveryChange);
            if (baseControl == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/DomUIFactory.createGenericValueControl must not return null");
            return baseControl;
        }
        BaseControl customControl = DomUIFactory.getDomUIFactory().createCustomControl(type, stringWrapper, commitOnEveryChange);
        if (customControl != null) {
            baseControl = customControl;
            if (baseControl == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/DomUIFactory.createGenericValueControl must not return null");
            return baseControl;
        }
        baseControl = DomUIFactory.getDomUIFactory().createTextControl(stringWrapper, commitOnEveryChange);
        if (baseControl != null) return baseControl;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/DomUIFactory.createGenericValueControl must not return null");
    }

    @Nullable
    public static Method findMethod(Class clazz, @NonNls String methodName) {
        for (Method method : clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public static TableCellEditor createCellEditor(GenericDomValue genericDomValue) {
        return DomUIFactory.getDomUIFactory().createCellEditor(genericDomValue, DomUtil.extractParameterClassFromGenericType(genericDomValue.getDomElementType()));
    }

    protected abstract TableCellEditor createCellEditor(DomElement var1, Class var2);

    public abstract UserActivityWatcher createEditorAwareUserActivityWatcher();

    public abstract void setupErrorOutdatingUserActivityWatcher(CommittablePanel var1, DomElement ... var2);

    public abstract BaseControl createTextControl(DomWrapper<String> var1, boolean var2);

    public abstract void registerCustomControl(Class var1, Function<DomWrapper<String>, BaseControl> var2);

    public abstract void registerCustomCellEditor(Class var1, Function<DomElement, TableCellEditor> var2);

    @Nullable
    public abstract BaseControl createCustomControl(Type var1, DomWrapper<String> var2, boolean var3);

    public static BaseControl createTextControl(GenericDomValue value, boolean commitOnEveryChange) {
        return DomUIFactory.getDomUIFactory().createTextControl(new DomStringWrapper(value), commitOnEveryChange);
    }

    public static BaseControl createTextControl(DomWrapper<String> wrapper) {
        return DomUIFactory.getDomUIFactory().createTextControl(wrapper, false);
    }

    public static DomUIFactory getDomUIFactory() {
        return ServiceManager.getService(DomUIFactory.class);
    }

    public DomUIControl createCollectionControl(DomElement element, DomCollectionChildDescription description) {
        ColumnInfo columnInfo = this.createColumnInfo(description, element);
        Class aClass = DomUtil.extractParameterClassFromGenericType(description.getType());
        return new DomCollectionControl(element, description, aClass == null, columnInfo);
    }

    public ColumnInfo createColumnInfo(DomCollectionChildDescription description, DomElement element) {
        String presentableName = description.getCommonPresentableName(element);
        Class aClass = DomUtil.extractParameterClassFromGenericType(description.getType());
        if (aClass != null) {
            if (Boolean.class.equals((Object)aClass) || Boolean.TYPE.equals(aClass)) {
                return new BooleanColumnInfo(presentableName);
            }
            return new GenericValueColumnInfo(presentableName, aClass, this.createCellEditor(element, aClass));
        }
        return new StringColumnInfo(presentableName);
    }

    public abstract CaptionComponent addErrorPanel(CaptionComponent var1, DomElement ... var2);

    public abstract BackgroundEditorHighlighter createDomHighlighter(Project var1, PerspectiveFileEditor var2, DomElement var3);
}

