/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.continuation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Continuation {
    private GeneralRunner myGeneralRunner;

    public Continuation(Project project, boolean cancellable) {
        this.myGeneralRunner = new GeneralRunner(project, cancellable);
    }

    public void run(TaskDescriptor ... tasks) {
        if (tasks.length == 0) {
            return;
        }
        this.myGeneralRunner.next(tasks);
        this.pingRunnerInCorrectThread();
    }

    public void run(List<TaskDescriptor> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        this.myGeneralRunner.next(tasks);
        this.pingRunnerInCorrectThread();
    }

    private void pingRunnerInCorrectThread() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Continuation.this.myGeneralRunner.ping();
                }
            });
        } else {
            this.myGeneralRunner.ping();
        }
    }

    private static class GeneralRunner
    implements ContinuationContext {
        private final Project myProject;
        private final boolean myCancellable;
        private final List<TaskDescriptor> myQueue;
        private boolean myTriggerSuspend;

        private GeneralRunner(Project project, boolean cancellable) {
            this.myProject = project;
            this.myCancellable = cancellable;
            this.myQueue = Collections.synchronizedList(new LinkedList());
        }

        @Override
        public void cancelEverything() {
            this.myQueue.clear();
        }

        @Override
        public void suspend() {
            this.myTriggerSuspend = true;
        }

        @Override
        public void next(TaskDescriptor ... next) {
            this.myQueue.addAll(0, Arrays.asList(next));
        }

        @Override
        public void next(List<TaskDescriptor> next) {
            this.myQueue.addAll(0, next);
        }

        @Override
        public void ping() {
            TaskDescriptor current;
            ApplicationManager.getApplication().assertIsDispatchThread();
            while (true) {
                if (this.myQueue.isEmpty()) {
                    return;
                }
                if (this.myTriggerSuspend) {
                    this.myTriggerSuspend = false;
                    return;
                }
                current = this.myQueue.remove(0);
                if (!Where.AWT.equals((Object)current.getWhere())) break;
                current.run(this);
            }
            ProgressManager.getInstance().run(new TaskWrapper(this.myProject, current.getName(), this.myCancellable, current, this));
        }
    }

    private static class TaskWrapper
    extends Task.Backgroundable {
        private final TaskDescriptor myTaskDescriptor;
        private final GeneralRunner myGeneralRunner;

        private TaskWrapper(@Nullable Project project, @NotNull String title, boolean canBeCancelled, TaskDescriptor taskDescriptor, GeneralRunner generalRunner) {
            if (title == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/continuation/Continuation$TaskWrapper.<init> must not be null");
            }
            super(project, title, canBeCancelled, BackgroundFromStartOption.getInstance());
            this.myTaskDescriptor = taskDescriptor;
            this.myGeneralRunner = generalRunner;
        }

        @Override
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/continuation/Continuation$TaskWrapper.run must not be null");
            }
            this.myTaskDescriptor.run(this.myGeneralRunner);
        }

        @Override
        public void onSuccess() {
            this.myGeneralRunner.ping();
        }
    }
}

