/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public class PsiNavigateUtil {
    public static void navigate(@Nullable PsiElement psiElement) {
        if (psiElement != null && psiElement.isValid()) {
            PsiElement navigationElement = psiElement.getNavigationElement();
            int offset = navigationElement instanceof PsiFile ? -1 : navigationElement.getTextOffset();
            VirtualFile virtualFile = navigationElement.getContainingFile().getVirtualFile();
            if (virtualFile != null && virtualFile.isValid()) {
                new OpenFileDescriptor(navigationElement.getProject(), virtualFile, offset).navigate(true);
            }
        }
    }
}

