/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.awt.Color;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleNode
extends PresentableNodeDescriptor
implements ComparableObject {
    protected static final SimpleNode[] NO_CHILDREN = new SimpleNode[0];

    protected SimpleNode(Project project) {
        this(project, null);
    }

    protected SimpleNode(Project project, NodeDescriptor parentDescriptor) {
        super(project, parentDescriptor);
        this.myName = "";
    }

    protected SimpleNode(SimpleNode parent) {
        this(parent == null ? null : parent.myProject, parent);
    }

    @Override
    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        return this.getChildAt(index);
    }

    protected SimpleNode() {
        super(null, null);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int getWeight() {
        return 10;
    }

    protected SimpleTextAttributes getErrorAttributes() {
        return new SimpleTextAttributes(8, this.getColor(), Color.red);
    }

    protected SimpleTextAttributes getPlainAttributes() {
        return new SimpleTextAttributes(0, this.getColor());
    }

    private FileStatus getFileStatus() {
        return FileStatus.NOT_CHANGED;
    }

    @Nullable
    protected Object updateElement() {
        return this.getElement();
    }

    @Override
    protected void update(PresentationData presentation) {
        Object newElement = this.updateElement();
        boolean changed = false;
        if (this.getElement() != newElement) {
            presentation.setChanged(true);
        }
        if (newElement == null) {
            return;
        }
        Color oldColor = this.myColor;
        String oldName = this.myName;
        Icon oldOpenIcon = this.myOpenIcon;
        Icon oldClosedIcon = this.myClosedIcon;
        ArrayList<PresentableNodeDescriptor.ColoredFragment> oldFragments = new ArrayList<PresentableNodeDescriptor.ColoredFragment>(presentation.getColoredText());
        this.myColor = Color.black;
        this.updateFileStatus();
        this.doUpdate();
        this.myName = this.getName();
        presentation.setPresentableText(this.myName);
        presentation.setChanged(changed || !Comparing.equal((Object[])new Object[]{this.myOpenIcon, this.myClosedIcon, this.myName, oldFragments, this.myColor}, (Object[])new Object[]{oldOpenIcon, oldClosedIcon, oldName, oldFragments, oldColor}));
        presentation.setForcedTextForeground(this.myColor);
        presentation.setOpenIcon(this.myOpenIcon);
        presentation.setClosedIcon(this.myClosedIcon);
    }

    protected void updateFileStatus() {
        assert (this.getFileStatus() != null) : this.getClass().getName() + ' ' + this.toString();
        Color fileStatusColor = this.getFileStatus().getColor();
        if (fileStatusColor != null) {
            this.myColor = fileStatusColor;
        }
    }

    public final void setNodeText(String text, String tooltip, boolean hasError) {
        this.clearColoredText();
        SimpleTextAttributes attributes = hasError ? this.getErrorAttributes() : this.getPlainAttributes();
        this.getTemplatePresentation().addText(new PresentableNodeDescriptor.ColoredFragment(text, tooltip, attributes));
    }

    public final void setPlainText(String aText) {
        this.clearColoredText();
        this.addPlainText(aText);
    }

    public final void addPlainText(String aText) {
        this.getTemplatePresentation().addText(new PresentableNodeDescriptor.ColoredFragment(aText, this.getPlainAttributes()));
    }

    public final void addErrorText(String aText, String errorTooltipText) {
        this.getTemplatePresentation().addText(new PresentableNodeDescriptor.ColoredFragment(aText, errorTooltipText, this.getErrorAttributes()));
    }

    public final void clearColoredText() {
        this.getTemplatePresentation().clearText();
    }

    public final void addColoredFragment(String aText, SimpleTextAttributes aAttributes) {
        this.addColoredFragment(aText, null, aAttributes);
    }

    public final void addColoredFragment(String aText, String toolTip, SimpleTextAttributes aAttributes) {
        this.getTemplatePresentation().addText(new PresentableNodeDescriptor.ColoredFragment(aText, toolTip, aAttributes));
    }

    public final void addColoredFragment(PresentableNodeDescriptor.ColoredFragment fragment) {
        this.getTemplatePresentation().addText(new PresentableNodeDescriptor.ColoredFragment(fragment.getText(), fragment.getAttributes()));
    }

    protected void doUpdate() {
    }

    @Override
    public Object getElement() {
        return this;
    }

    public final SimpleNode getParent() {
        return (SimpleNode)this.getParentDescriptor();
    }

    public int getIndex(SimpleNode child) {
        SimpleNode[] kids = this.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            SimpleNode each = kids[i];
            if (!each.equals(child)) continue;
            return i;
        }
        return -1;
    }

    public abstract SimpleNode[] getChildren();

    public void accept(SimpleNodeVisitor visitor) {
        visitor.accept(this);
    }

    public void handleSelection(SimpleTree tree) {
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    public boolean isAutoExpandNode() {
        return false;
    }

    public boolean shouldHaveSeparator() {
        return false;
    }

    public void setUniformIcon(Icon aIcon) {
        this.setIcons(aIcon, aIcon);
    }

    public final void setIcons(Icon aClosed, Icon aOpen) {
        this.myOpenIcon = aOpen;
        this.myClosedIcon = aClosed;
    }

    public final PresentableNodeDescriptor.ColoredFragment[] getColoredText() {
        List<PresentableNodeDescriptor.ColoredFragment> list = this.getTemplatePresentation().getColoredText();
        return list.toArray(new PresentableNodeDescriptor.ColoredFragment[list.size()]);
    }

    public Object[] getEqualityObjects() {
        return NONE;
    }

    public int getChildCount() {
        return this.getChildren().length;
    }

    public SimpleNode getChildAt(int i) {
        return this.getChildren()[i];
    }

    public final boolean equals(Object o) {
        return ComparableObjectCheck.equals((ComparableObject)this, (Object)o);
    }

    public final int hashCode() {
        return ComparableObjectCheck.hashCode((ComparableObject)this, (int)super.hashCode());
    }
}

