/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiReference;
import com.intellij.testFramework.PsiTestCase;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class ResolveTestCase
extends PsiTestCase {
    @NonNls
    protected static final String MARKER = "<ref>";

    protected PsiReference configureByFile(@NonNls String filePath) throws Exception {
        return this.configureByFile(filePath, null);
    }

    protected PsiReference configureByFile(@NonNls String filePath, @Nullable VirtualFile parentDir) throws Exception {
        String fullPath = this.getTestDataPath() + filePath;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fullPath.replace(File.separatorChar, '/'));
        ResolveTestCase.assertNotNull((String)("file " + filePath + " not found"), (Object)vFile);
        String fileText = StringUtil.convertLineSeparators((String)VfsUtil.loadText(vFile));
        String fileName = vFile.getName();
        return this.configureByFileText(fileText, fileName, parentDir);
    }

    protected PsiReference configureByFileText(String fileText, String fileName) throws Exception {
        return this.configureByFileText(fileText, fileName, null);
    }

    protected PsiReference configureByFileText(String fileText, String fileName, @Nullable VirtualFile parentDir) throws Exception {
        int offset = fileText.indexOf(MARKER);
        ResolveTestCase.assertTrue((offset >= 0 ? 1 : 0) != 0);
        fileText = fileText.substring(0, offset) + fileText.substring(offset + MARKER.length());
        this.myFile = parentDir == null ? this.createFile(this.myModule, fileName, fileText) : this.createFile(this.myModule, parentDir, fileName, fileText);
        PsiReference ref = this.myFile.findReferenceAt(offset);
        ResolveTestCase.assertNotNull((Object)ref);
        return ref;
    }

    @Override
    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath() + "/psi/resolve/";
    }
}

