/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.InstanceofQuery;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class AnnotatedElementsSearch
extends ExtensibleQueryFactory<PsiModifierListOwner, Parameters> {
    public static final AnnotatedElementsSearch INSTANCE = new AnnotatedElementsSearch();

    private static Query<PsiModifierListOwner> createDelegateQuery(PsiClass annotationClass, SearchScope scope, Class<? extends PsiModifierListOwner> ... types) {
        return INSTANCE.createQuery(new Parameters(annotationClass, scope, types));
    }

    public static <T extends PsiModifierListOwner> Query<T> searchElements(@NotNull PsiClass annotationClass, @NotNull SearchScope scope, Class<? extends T> ... types) {
        if (annotationClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/AnnotatedElementsSearch.searchElements must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/AnnotatedElementsSearch.searchElements must not be null");
        }
        return new InstanceofQuery(AnnotatedElementsSearch.createDelegateQuery(annotationClass, scope, types), (Class[])types);
    }

    public static Query<PsiClass> searchPsiClasses(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/AnnotatedElementsSearch.searchPsiClasses must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/AnnotatedElementsSearch.searchPsiClasses must not be null");
        }
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiClass.class);
    }

    public static Query<PsiMethod> searchPsiMethods(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/AnnotatedElementsSearch.searchPsiMethods must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/AnnotatedElementsSearch.searchPsiMethods must not be null");
        }
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiMethod.class);
    }

    public static Query<PsiMember> searchPsiMetmbers(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/AnnotatedElementsSearch.searchPsiMetmbers must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/AnnotatedElementsSearch.searchPsiMetmbers must not be null");
        }
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiMember.class);
    }

    public static Query<PsiField> searchPsiFields(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/AnnotatedElementsSearch.searchPsiFields must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/AnnotatedElementsSearch.searchPsiFields must not be null");
        }
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiField.class);
    }

    public static Query<PsiParameter> searchPsiParameters(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/searches/AnnotatedElementsSearch.searchPsiParameters must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/searches/AnnotatedElementsSearch.searchPsiParameters must not be null");
        }
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiParameter.class);
    }

    public static class Parameters {
        private final PsiClass myAnnotationClass;
        private final SearchScope myScope;
        private Class<? extends PsiModifierListOwner>[] myTypes;

        public Parameters(PsiClass annotationClass, SearchScope scope, Class<? extends PsiModifierListOwner> ... types) {
            this.myAnnotationClass = annotationClass;
            this.myScope = scope;
            this.myTypes = types;
        }

        public PsiClass getAnnotationClass() {
            return this.myAnnotationClass;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public Class<? extends PsiModifierListOwner>[] getTypes() {
            return this.myTypes;
        }
    }
}

