/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectAwareFileFilter;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GlobalSearchScope
extends SearchScope
implements ProjectAwareFileFilter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.search.GlobalSearchScope");
    @Nullable
    private final Project myProject;
    public static final GlobalSearchScope EMPTY_SCOPE = new EmptyScope();

    protected GlobalSearchScope(Project project) {
        this.myProject = project;
    }

    protected GlobalSearchScope() {
        this(null);
    }

    public abstract boolean contains(VirtualFile var1);

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public abstract int compare(VirtualFile var1, VirtualFile var2);

    public abstract boolean isSearchInModuleContent(@NotNull Module var1);

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.isSearchInModuleContent must not be null");
        }
        return this.isSearchInModuleContent(aModule);
    }

    @Override
    public boolean accept(VirtualFile file) {
        return this.contains(file);
    }

    public abstract boolean isSearchInLibraries();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        GlobalSearchScope globalSearchScope;
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.intersectWith must not be null");
        }
        if (scope == this) {
            globalSearchScope = this;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.intersectWith must not return null");
            return globalSearchScope;
        }
        globalSearchScope = new IntersectionScope(this, scope, null);
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.intersectWith must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        SearchScope searchScope;
        if (scope2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.intersectWith must not be null");
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localScope2 = (LocalSearchScope)scope2;
            searchScope = this.intersectWith(localScope2);
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.intersectWith must not return null");
            return searchScope;
        }
        searchScope = this.intersectWith((GlobalSearchScope)scope2);
        if (searchScope != null) return searchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.intersectWith must not return null");
    }

    public SearchScope intersectWith(LocalSearchScope localScope2) {
        PsiElement[] elements2 = localScope2.getScope();
        ArrayList<PsiElement> result = new ArrayList<PsiElement>(elements2.length);
        for (PsiElement element2 : elements2) {
            if (!PsiSearchScopeUtil.isInScope(this, element2)) continue;
            result.add(element2);
        }
        return new LocalSearchScope(result.toArray(new PsiElement[result.size()]), null, localScope2.isIgnoreInjectedPsi());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SearchScope union(@NotNull SearchScope scope) {
        SearchScope searchScope;
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.union must not be null");
        }
        if (scope instanceof GlobalSearchScope) {
            searchScope = this.uniteWith((GlobalSearchScope)scope);
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.union must not return null");
            return searchScope;
        }
        searchScope = this.union((LocalSearchScope)scope);
        if (searchScope != null) return searchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.union must not return null");
    }

    @NotNull
    public SearchScope union(final LocalSearchScope scope) {
        GlobalSearchScope globalSearchScope = new GlobalSearchScope(scope.getScope()[0].getProject()){

            @Override
            public boolean contains(VirtualFile file) {
                return GlobalSearchScope.this.contains(file) || scope.isInScope(file);
            }

            @Override
            public int compare(VirtualFile file1, VirtualFile file2) {
                return GlobalSearchScope.this.contains(file1) && GlobalSearchScope.this.contains(file2) ? GlobalSearchScope.this.compare(file1, file2) : 0;
            }

            @Override
            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$1.isSearchInModuleContent must not be null");
                }
                return GlobalSearchScope.this.isSearchInModuleContent(aModule);
            }

            @Override
            public boolean isSearchInLibraries() {
                return GlobalSearchScope.this.isSearchInLibraries();
            }
        };
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.union must not return null");
        }
        return globalSearchScope;
    }

    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.uniteWith must not be null");
        }
        if (scope == this) {
            return scope;
        }
        return new UnionScope(this, scope, null);
    }

    public static GlobalSearchScope allScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.allScope must not be null");
        }
        return ProjectScope.getAllScope(project);
    }

    public static GlobalSearchScope projectScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.projectScope must not be null");
        }
        return ProjectScope.getProjectScope(project);
    }

    public static GlobalSearchScope projectProductionScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.projectProductionScope must not be null");
        }
        return new IntersectionScope(GlobalSearchScope.projectScope(project), new ProductionScopeFilter(project), PsiBundle.message("psi.search.scope.production.files", new Object[0]));
    }

    public static GlobalSearchScope projectTestScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.projectTestScope must not be null");
        }
        return new IntersectionScope(GlobalSearchScope.projectScope(project), new TestScopeFilter(project), PsiBundle.message("psi.search.scope.test.files", new Object[0]));
    }

    public static GlobalSearchScope filterScope(@NotNull Project project, @NotNull NamedScope set) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.filterScope must not be null");
        }
        if (set == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.filterScope must not be null");
        }
        return new FilterScopeAdapter(project, set);
    }

    public static GlobalSearchScope notScope(final @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.notScope must not be null");
        }
        return new GlobalSearchScope(){

            @Override
            public boolean contains(VirtualFile file) {
                return !scope.contains(file);
            }

            @Override
            public int compare(VirtualFile file1, VirtualFile file2) {
                return scope.compare(file1, file2);
            }

            @Override
            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$2.isSearchInModuleContent must not be null");
                }
                return scope.isSearchInLibraries();
            }

            @Override
            public boolean isSearchInLibraries() {
                return scope.isSearchInLibraries();
            }
        };
    }

    public static GlobalSearchScope moduleScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleScope must not be null");
        }
        return module.getModuleScope();
    }

    public static GlobalSearchScope moduleWithLibrariesScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithLibrariesScope must not be null");
        }
        return module.getModuleWithLibrariesScope();
    }

    public static GlobalSearchScope moduleWithDependenciesScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithDependenciesScope must not be null");
        }
        return module.getModuleWithDependenciesScope();
    }

    public static GlobalSearchScope moduleRuntimeScope(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleRuntimeScope must not be null");
        }
        return module.getModuleRuntimeScope(includeTests);
    }

    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithDependenciesAndLibrariesScope must not be null");
        }
        return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, true);
    }

    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithDependenciesAndLibrariesScope must not be null");
        }
        return module.getModuleWithDependenciesAndLibrariesScope(includeTests);
    }

    public static GlobalSearchScope moduleWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithDependentsScope must not be null");
        }
        return module.getModuleWithDependentsScope();
    }

    public static GlobalSearchScope moduleTestsWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleTestsWithDependentsScope must not be null");
        }
        return module.getModuleWithDependentsScope();
    }

    public static GlobalSearchScope directoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.directoryScope must not be null");
        }
        return new DirectoryScope(directory, withSubdirectories);
    }

    public static GlobalSearchScope fileScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.fileScope must not be null");
        }
        return new FileScope(psiFile.getProject(), psiFile.getVirtualFile());
    }

    public static GlobalSearchScope fileScope(Project project, VirtualFile virtualFile) {
        return new FileScope(project, virtualFile);
    }

    @NotNull
    public static GlobalSearchScope getScopeRestrictedByFileTypes(@NotNull GlobalSearchScope scope, FileType ... fileTypes) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.getScopeRestrictedByFileTypes must not be null");
        }
        LOG.assertTrue(fileTypes.length > 0);
        FileTypeRestrictionScope fileTypeRestrictionScope = new FileTypeRestrictionScope(scope, fileTypes);
        if (fileTypeRestrictionScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.getScopeRestrictedByFileTypes must not return null");
        }
        return fileTypeRestrictionScope;
    }

    private static class EmptyScope
    extends GlobalSearchScope {
        private EmptyScope() {
        }

        @Override
        public boolean contains(VirtualFile file) {
            return false;
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$EmptyScope.isSearchInModuleContent must not be null");
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$EmptyScope.intersectWith must not be null");
            }
            EmptyScope emptyScope = this;
            if (emptyScope == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope$EmptyScope.intersectWith must not return null");
            }
            return emptyScope;
        }

        @Override
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$EmptyScope.uniteWith must not be null");
            }
            return scope;
        }
    }

    private static class FileTypeRestrictionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope;
        private final FileType[] myFileTypes;

        private FileTypeRestrictionScope(@NotNull GlobalSearchScope scope, @NotNull FileType[] fileTypes) {
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.<init> must not be null");
            }
            if (fileTypes == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.<init> must not be null");
            }
            super(scope.getProject());
            this.myFileTypes = fileTypes;
            this.myScope = scope;
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return this.myScope.compare(file1, file2);
        }

        @Override
        public boolean contains(VirtualFile file) {
            if (!this.myScope.contains(file)) {
                return false;
            }
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFile(file);
            for (FileType otherFileType : this.myFileTypes) {
                if (!fileType.equals(otherFileType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope.isSearchInLibraries();
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope.isSearchInModuleContent(aModule);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            GlobalSearchScope globalSearchScope;
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.intersectWith must not be null");
            }
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myScope == this.myScope) {
                    ArrayList<FileType> intersection = new ArrayList<FileType>(Arrays.asList(restrict.myFileTypes));
                    intersection.retainAll(Arrays.asList(this.myFileTypes));
                    globalSearchScope = new FileTypeRestrictionScope(this.myScope, intersection.toArray(new FileType[intersection.size()]));
                    if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.intersectWith must not return null");
                    return globalSearchScope;
                }
            }
            if ((globalSearchScope = super.intersectWith(scope)) != null) return globalSearchScope;
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.intersectWith must not return null");
        }

        @Override
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.uniteWith must not be null");
            }
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myScope == this.myScope) {
                    return new FileTypeRestrictionScope(this.myScope, (FileType[])ArrayUtil.mergeArrays((Object[])this.myFileTypes, (Object[])restrict.myFileTypes, FileType.class));
                }
            }
            return super.uniteWith(scope);
        }
    }

    private static class FilterScopeAdapter
    extends GlobalSearchScope {
        private final NamedScope mySet;
        private final PsiManager myManager;

        private FilterScopeAdapter(@NotNull Project project, @NotNull NamedScope set) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FilterScopeAdapter.<init> must not be null");
            }
            if (set == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FilterScopeAdapter.<init> must not be null");
            }
            super(project);
            this.mySet = set;
            this.myManager = PsiManager.getInstance(project);
        }

        @Override
        public boolean contains(VirtualFile file) {
            PsiFile psiFile = this.myManager.findFile(file);
            if (psiFile == null) {
                return false;
            }
            NamedScopeManager holder = NamedScopeManager.getInstance(this.getProject());
            PackageSet packageSet = this.mySet.getValue();
            return packageSet != null && packageSet.contains(psiFile, holder);
        }

        @Override
        public String getDisplayName() {
            return this.mySet.getName();
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FilterScopeAdapter.isSearchInModuleContent must not be null");
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }
    }

    private static class FileScope
    extends GlobalSearchScope {
        private final VirtualFile myVirtualFile;
        private final Module myModule;

        private FileScope(Project project, VirtualFile virtualFile) {
            super(project);
            this.myVirtualFile = virtualFile;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
            this.myModule = this.myVirtualFile != null ? fileIndex.getModuleForFile(this.myVirtualFile) : null;
        }

        @Override
        public boolean contains(VirtualFile file) {
            return Comparing.equal((Object)this.myVirtualFile, (Object)file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileScope.isSearchInModuleContent must not be null");
            }
            return aModule == this.myModule;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myModule == null;
        }
    }

    private static class DirectoryScope
    extends GlobalSearchScope {
        private final VirtualFile myDirectory;
        private final boolean myWithSubdirectories;

        private DirectoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
            if (directory == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$DirectoryScope.<init> must not be null");
            }
            super(directory.getProject());
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = directory.getVirtualFile();
        }

        @Override
        public boolean contains(VirtualFile file) {
            if (this.myWithSubdirectories) {
                return VfsUtil.isAncestor(this.myDirectory, file, false);
            }
            return this.myDirectory.equals(file.getParent());
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$DirectoryScope.isSearchInModuleContent must not be null");
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        public String toString() {
            return "directory scope: " + this.myDirectory + "; withSubdirs:" + this.myWithSubdirectories;
        }
    }

    private static class TestScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private TestScopeFilter(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$TestScopeFilter.<init> must not be null");
            }
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        @Override
        public boolean contains(VirtualFile file) {
            return this.myFileIndex.isInTestSourceContent(file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$TestScopeFilter.isSearchInModuleContent must not be null");
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$TestScopeFilter.isSearchInModuleContent must not be null");
            }
            return testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }
    }

    private static class ProductionScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private ProductionScopeFilter(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$ProductionScopeFilter.<init> must not be null");
            }
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        @Override
        public boolean contains(VirtualFile file) {
            return this.myFileIndex.isInSourceContent(file) && !this.myFileIndex.isInTestSourceContent(file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$ProductionScopeFilter.isSearchInModuleContent must not be null");
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$ProductionScopeFilter.isSearchInModuleContent must not be null");
            }
            return !testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }
    }

    private static class UnionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;
        private final String myDisplayName;

        private UnionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2, String displayName) {
            if (scope1 == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$UnionScope.<init> must not be null");
            }
            if (scope2 == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$UnionScope.<init> must not be null");
            }
            super(scope1.getProject() == scope2.getProject() ? scope1.getProject() : null);
            this.myScope1 = scope1;
            this.myScope2 = scope2;
            this.myDisplayName = displayName;
        }

        @Override
        public String getDisplayName() {
            if (this.myDisplayName == null) {
                return PsiBundle.message("psi.search.scope.union", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
            }
            return this.myDisplayName;
        }

        @Override
        public boolean contains(VirtualFile file) {
            return this.myScope1.contains(file) || this.myScope2.contains(file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            int res2;
            int res1 = this.myScope1.contains(file1) && this.myScope1.contains(file2) ? this.myScope1.compare(file1, file2) : 0;
            int n = res2 = this.myScope2.contains(file1) && this.myScope2.contains(file2) ? this.myScope2.compare(file1, file2) : 0;
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if ((res1 /= Math.abs(res1)) == (res2 /= Math.abs(res2))) {
                return res1;
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$UnionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope1.isSearchInModuleContent(aModule) || this.myScope2.isSearchInModuleContent(aModule);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$UnionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope1.isSearchInModuleContent(aModule, testSources) || this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() || this.myScope2.isSearchInLibraries();
        }
    }

    private static class IntersectionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;
        private final String myDisplayName;

        private IntersectionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2, String displayName) {
            if (scope1 == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.<init> must not be null");
            }
            if (scope2 == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.<init> must not be null");
            }
            super(scope1 == null ? scope2.getProject() : scope1.getProject());
            this.myScope1 = scope1;
            this.myScope2 = scope2;
            this.myDisplayName = displayName;
        }

        @Override
        public String getDisplayName() {
            if (this.myDisplayName == null) {
                return PsiBundle.message("psi.search.scope.intersection", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
            }
            return this.myDisplayName;
        }

        @Override
        public boolean contains(VirtualFile file) {
            return this.myScope1.contains(file) && this.myScope2.contains(file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            int res1 = this.myScope1.compare(file1, file2);
            int res2 = this.myScope2.compare(file1, file2);
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if ((res1 /= Math.abs(res1)) == (res2 /= Math.abs(res2))) {
                return res1;
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope1.isSearchInModuleContent(aModule) && this.myScope2.isSearchInModuleContent(aModule);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope1.isSearchInModuleContent(aModule, testSources) && this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() && this.myScope2.isSearchInLibraries();
        }
    }
}

