/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListModification;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeListManager
implements ChangeListModification {
    public static ChangeListManager getInstance(Project project) {
        return project.getComponent(ChangeListManager.class);
    }

    public static ChangeListManager getInstanceChecked(final Project project) {
        return ApplicationManager.getApplication().runReadAction(new Computable<ChangeListManager>(){

            public ChangeListManager compute() {
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return project.getComponent(ChangeListManager.class);
            }
        });
    }

    public abstract void scheduleUpdate();

    public abstract void scheduleUpdate(boolean var1);

    public abstract void invokeAfterUpdate(Runnable var1, InvokeAfterUpdateMode var2, String var3, ModalityState var4);

    public abstract void invokeAfterUpdate(Runnable var1, InvokeAfterUpdateMode var2, String var3, Consumer<VcsDirtyScopeManager> var4, ModalityState var5);

    public abstract boolean ensureUpToDate(boolean var1);

    public abstract List<LocalChangeList> getChangeListsCopy();

    @NotNull
    public abstract List<LocalChangeList> getChangeLists();

    public abstract List<File> getAffectedPaths();

    @NotNull
    public abstract List<VirtualFile> getAffectedFiles();

    public abstract boolean isFileAffected(VirtualFile var1);

    @Nullable
    public abstract LocalChangeList findChangeList(String var1);

    @Nullable
    public abstract LocalChangeList getChangeList(String var1);

    public abstract LocalChangeList getDefaultChangeList();

    public abstract boolean isDefaultChangeList(ChangeList var1);

    @Nullable
    public abstract LocalChangeList getChangeList(Change var1);

    @Nullable
    public abstract String getChangeListNameIfOnlyOne(Change[] var1);

    @NotNull
    public abstract Runnable prepareForChangeDeletion(Collection<Change> var1);

    @Nullable
    public abstract Change getChange(@NotNull VirtualFile var1);

    @Nullable
    public abstract LocalChangeList getChangeList(@NotNull VirtualFile var1);

    @Nullable
    public abstract Change getChange(FilePath var1);

    public abstract boolean isUnversioned(VirtualFile var1);

    @NotNull
    public abstract FileStatus getStatus(VirtualFile var1);

    @NotNull
    public abstract Collection<Change> getChangesIn(VirtualFile var1);

    @NotNull
    public abstract Collection<Change> getChangesIn(FilePath var1);

    public abstract void addChangeListListener(ChangeListListener var1);

    public abstract void removeChangeListListener(ChangeListListener var1);

    public abstract void registerCommitExecutor(CommitExecutor var1);

    public abstract void commitChanges(LocalChangeList var1, List<Change> var2);

    public abstract void commitChangesSynchronously(LocalChangeList var1, List<Change> var2);

    public abstract boolean commitChangesSynchronouslyWithResult(LocalChangeList var1, List<Change> var2);

    public abstract void reopenFiles(List<FilePath> var1);

    public abstract List<CommitExecutor> getRegisteredExecutors();

    public abstract void addFilesToIgnore(IgnoredFileBean ... var1);

    public abstract void setFilesToIgnore(IgnoredFileBean ... var1);

    public abstract IgnoredFileBean[] getFilesToIgnore();

    public abstract boolean isIgnoredFile(@NotNull VirtualFile var1);

    @Nullable
    public abstract String getSwitchedBranch(VirtualFile var1);

    public abstract String getDefaultListName();
}

