/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.ui.DialogWrapper;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import org.jetbrains.annotations.Nullable;

public class PasswordPromptDialog
extends DialogWrapper {
    private JPasswordField myPasswordField;
    private final String myPrompt;
    private final String myDefaultValue;

    public PasswordPromptDialog(String prompt, String title, @Nullable String defaultValue) {
        super(true);
        this.myDefaultValue = defaultValue;
        this.setTitle(title);
        this.myPrompt = prompt;
        this.init();
    }

    @Override
    protected JComponent createNorthPanel() {
        return new JLabel(this.myPrompt);
    }

    @Override
    protected JComponent createCenterPanel() {
        this.myPasswordField = new JPasswordField();
        if (this.myDefaultValue != null) {
            this.myPasswordField.setText(this.myDefaultValue);
        }
        return this.myPasswordField;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myPasswordField;
    }

    public String getPassword() {
        return new String(this.myPasswordField.getPassword());
    }
}

