/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.cacheBuilder;

import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;

public class DefaultWordsScanner
implements WordsScanner {
    private final Lexer myLexer;
    private final TokenSet myIdentifierTokenSet;
    private final TokenSet myCommentTokenSet;
    private final TokenSet myLiteralTokenSet;
    private boolean myMayHaveFileRefsInLiterals;

    public DefaultWordsScanner(Lexer lexer, TokenSet identifierTokenSet, TokenSet commentTokenSet, TokenSet literalTokenSet) {
        this.myLexer = lexer;
        this.myIdentifierTokenSet = identifierTokenSet;
        this.myCommentTokenSet = commentTokenSet;
        this.myLiteralTokenSet = literalTokenSet;
    }

    @Override
    public void processWords(CharSequence fileText, Processor<WordOccurrence> processor) {
        this.myLexer.start(fileText);
        WordOccurrence occurence = null;
        while (this.myLexer.getTokenType() != null) {
            IElementType type = this.myLexer.getTokenType();
            if (this.myIdentifierTokenSet.contains(type)) {
                if (occurence == null) {
                    occurence = new WordOccurrence(fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE);
                } else {
                    occurence.init(fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE);
                }
                if (!processor.process((Object)occurence)) {
                    return;
                }
            } else if (this.myCommentTokenSet.contains(type) ? !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.COMMENTS, occurence, false) : (this.myLiteralTokenSet.contains(type) ? !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.LITERALS, occurence, this.myMayHaveFileRefsInLiterals) : !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE, occurence, false))) {
                return;
            }
            this.myLexer.advance();
        }
    }

    protected static boolean stripWords(Processor<WordOccurrence> processor, CharSequence tokenText, int from, int to, WordOccurrence.Kind kind, WordOccurrence occurence, boolean mayHaveFileRefs) {
        int index = from;
        while (index != to) {
            char c;
            char c2 = tokenText.charAt(index);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 != '$' && Character.isJavaIdentifierStart(c2))) {
                ++index;
                continue;
            }
            int wordStart = index;
            while (++index != to && ((c = tokenText.charAt(index)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c != '$' && Character.isJavaIdentifierPart(c))) {
            }
            int wordEnd = index;
            if (occurence == null) {
                occurence = new WordOccurrence(tokenText, wordStart, wordEnd, kind);
            } else {
                occurence.init(tokenText, wordStart, wordEnd, kind);
            }
            if (!processor.process((Object)occurence)) {
                return false;
            }
            if (!mayHaveFileRefs) continue;
            occurence.init(tokenText, wordStart, wordEnd, WordOccurrence.Kind.FOREIGN_LANGUAGE);
            if (processor.process((Object)occurence)) continue;
            return false;
        }
        return true;
    }

    public void setMayHaveFileRefsInLiterals(boolean mayHaveFileRefsInLiterals) {
        this.myMayHaveFileRefsInLiterals = mayHaveFileRefsInLiterals;
    }
}

