/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.openapi.util.ActiveRunnable;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeUpdatePass {
    private DefaultMutableTreeNode myNode;
    private ActiveRunnable myBefore;
    private ActiveRunnable myAfter;
    private long myUpdateStamp;
    private boolean myExpired;
    private DefaultMutableTreeNode myCurrentNode;
    private long myAllocation;

    public TreeUpdatePass(@NotNull DefaultMutableTreeNode node, @Nullable ActiveRunnable before, @Nullable ActiveRunnable after) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/treeView/TreeUpdatePass.<init> must not be null");
        }
        this.myNode = node;
        this.myBefore = before;
        this.myAfter = after;
        this.myAllocation = System.currentTimeMillis();
    }

    public TreeUpdatePass(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/treeView/TreeUpdatePass.<init> must not be null");
        }
        this(node, null, null);
    }

    public DefaultMutableTreeNode getNode() {
        return this.myNode;
    }

    public TreeUpdatePass setUpdateStamp(long updateCount) {
        this.myUpdateStamp = updateCount;
        return this;
    }

    public long getUpdateStamp() {
        return this.myUpdateStamp;
    }

    public void expire() {
        this.myExpired = true;
    }

    public boolean isExpired() {
        return this.myExpired;
    }

    public DefaultMutableTreeNode getCurrentNode() {
        return this.myCurrentNode;
    }

    public void setCurrentNode(DefaultMutableTreeNode currentNode) {
        this.myCurrentNode = currentNode;
    }

    public String toString() {
        return "TreUpdatePass node=" + this.myNode + " stamp=" + this.myUpdateStamp + " expired=" + this.myExpired + " currentNode=" + this.myCurrentNode + " allocation=" + this.myAllocation;
    }

    public boolean willUpdate(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/treeView/TreeUpdatePass.willUpdate must not be null");
        }
        DefaultMutableTreeNode currentNode = this.myCurrentNode != null ? this.myCurrentNode : this.myNode;
        return node.isNodeAncestor(currentNode);
    }
}

