/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.SelectionRequest;
import com.intellij.ide.util.treeView.TreeUpdatePass;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class AbstractTreeUpdater
implements Disposable,
Activatable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.AbstractTreeUpdater");
    private final LinkedList<TreeUpdatePass> myNodeQueue = new LinkedList();
    private final AbstractTreeBuilder myTreeBuilder;
    private final List<Runnable> myRunAfterUpdate = new ArrayList<Runnable>();
    private Runnable myRunBeforeUpdate;
    private final MergingUpdateQueue myUpdateQueue;
    private long myUpdateCount;
    private boolean myReleaseRequested;

    public AbstractTreeUpdater(AbstractTreeBuilder treeBuilder) {
        this.myTreeBuilder = treeBuilder;
        JTree tree = this.myTreeBuilder.getTree();
        JTree component = tree instanceof TreeTableTree ? ((TreeTableTree)tree).getTreeTable() : tree;
        this.myUpdateQueue = new MergingUpdateQueue("UpdateQeue", 300, component.isShowing(), component){

            @Override
            protected Alarm createAlarm(Alarm.ThreadToUse thread, Disposable parent) {
                return new Alarm(thread, parent){

                    @Override
                    protected boolean isEdt() {
                        return AbstractTreeUpdater.this.isEdt();
                    }
                };
            }
        };
        this.myUpdateQueue.setRestartTimerOnAdd(false);
        UiNotifyConnector uiNotifyConnector = new UiNotifyConnector(component, this.myUpdateQueue);
        Disposer.register((Disposable)this, (Disposable)this.myUpdateQueue);
        Disposer.register((Disposable)this, (Disposable)uiNotifyConnector);
    }

    public void setDelay(int delay) {
        this.myUpdateQueue.setMergingTimeSpan(delay);
    }

    public void setPassThroughMode(boolean passThroughMode) {
        this.myUpdateQueue.setPassThrough(passThroughMode);
    }

    public void setModalityStateComponent(JComponent c) {
        this.myUpdateQueue.setModalityStateComponent(c);
    }

    public boolean hasNodesToUpdate() {
        return this.myNodeQueue.size() > 0;
    }

    public void dispose() {
    }

    public synchronized void addSubtreeToUpdate(@NotNull DefaultMutableTreeNode rootNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/treeView/AbstractTreeUpdater.addSubtreeToUpdate must not be null");
        }
        this.addSubtreeToUpdate(new TreeUpdatePass(rootNode).setUpdateStamp(-1L));
    }

    public synchronized void addSubtreeToUpdate(@NotNull TreeUpdatePass toAdd) {
        long newUpdateCount;
        if (toAdd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/treeView/AbstractTreeUpdater.addSubtreeToUpdate must not be null");
        }
        if (this.myReleaseRequested) {
            return;
        }
        assert (!toAdd.isExpired());
        AbstractTreeUi ui = this.myTreeBuilder.getUi();
        if (ui.isUpdatingNow(toAdd.getNode())) {
            toAdd.expire();
        } else {
            Iterator iterator = this.myNodeQueue.iterator();
            while (iterator.hasNext()) {
                TreeUpdatePass passInQueue = (TreeUpdatePass)iterator.next();
                if (passInQueue == toAdd) {
                    toAdd.expire();
                    break;
                }
                if (passInQueue.getNode() == toAdd.getNode()) {
                    toAdd.expire();
                    break;
                }
                if (toAdd.getNode().isNodeAncestor(passInQueue.getNode())) {
                    toAdd.expire();
                    break;
                }
                if (!passInQueue.getNode().isNodeAncestor(toAdd.getNode())) continue;
                iterator.remove();
                passInQueue.expire();
            }
        }
        long l = newUpdateCount = toAdd.getUpdateStamp() == -1L ? this.myUpdateCount : this.myUpdateCount + 1L;
        if (!toAdd.isExpired()) {
            Collection<TreeUpdatePass> yielding = ui.getYeildingPasses();
            for (TreeUpdatePass eachYielding : yielding) {
                DefaultMutableTreeNode eachNode = eachYielding.getCurrentNode();
                if (eachNode == null) continue;
                if (eachNode.isNodeAncestor(toAdd.getNode())) {
                    eachYielding.setUpdateStamp(newUpdateCount);
                    continue;
                }
                toAdd.expire();
            }
        }
        if (toAdd.isExpired()) {
            this.requeueViewUpdateIfNeeded();
            return;
        }
        this.myNodeQueue.add(toAdd);
        this.myUpdateCount = newUpdateCount;
        toAdd.setUpdateStamp(this.myUpdateCount);
        this.requeueViewUpdate();
    }

    private void requeueViewUpdateIfNeeded() {
        if (this.myUpdateQueue.isEmpty() && !this.myNodeQueue.isEmpty()) {
            this.requeueViewUpdate();
        }
    }

    private void requeueViewUpdate() {
        this.queue(new Update("ViewUpdate"){

            @Override
            public boolean isExpired() {
                return AbstractTreeUpdater.this.myTreeBuilder.isDisposed();
            }

            @Override
            public void run() {
                if (AbstractTreeUpdater.this.myTreeBuilder.getTreeStructure().hasSomethingToCommit()) {
                    AbstractTreeUpdater.this.myTreeBuilder.getTreeStructure().commit();
                    AbstractTreeUpdater.this.requeueViewUpdateIfNeeded();
                    return;
                }
                try {
                    AbstractTreeUpdater.this.performUpdate();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    LOG.error(AbstractTreeUpdater.this.myTreeBuilder.getClass().getName(), (Throwable)e);
                }
            }
        });
    }

    private void queue(Update update) {
        if (this.isReleased()) {
            return;
        }
        this.myUpdateQueue.queue(update);
    }

    protected void updateSubtree(DefaultMutableTreeNode node) {
        this.myTreeBuilder.updateSubtree(node);
    }

    public synchronized void performUpdate() {
        if (this.myRunBeforeUpdate != null) {
            this.myRunBeforeUpdate.run();
            this.myRunBeforeUpdate = null;
        }
        while (!this.myNodeQueue.isEmpty() && !this.isInPostponeMode()) {
            final TreeUpdatePass eachPass = this.myNodeQueue.removeFirst();
            this.beforeUpdate(eachPass).doWhenDone(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractTreeUpdater.this.myTreeBuilder.getUi().updateSubtreeNow(eachPass, false);
                    }
                    catch (ProcessCanceledException e) {
                        return;
                    }
                }
            });
        }
        if (this.isReleased()) {
            return;
        }
        this.myTreeBuilder.getUi().maybeReady();
        if (this.myRunAfterUpdate != null) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList runAfterUpdate = null;
                    List list = AbstractTreeUpdater.this.myRunAfterUpdate;
                    synchronized (list) {
                        if (!AbstractTreeUpdater.this.myRunAfterUpdate.isEmpty()) {
                            runAfterUpdate = new ArrayList(AbstractTreeUpdater.this.myRunAfterUpdate);
                            AbstractTreeUpdater.this.myRunAfterUpdate.clear();
                        }
                    }
                    if (runAfterUpdate != null) {
                        for (Runnable r : runAfterUpdate) {
                            r.run();
                        }
                    }
                }
            };
            this.myTreeBuilder.getReady(this).doWhenDone(runnable);
        }
    }

    private boolean isReleased() {
        return this.myTreeBuilder.getUi() == null;
    }

    protected void invokeLater(Runnable runnable) {
        if (this.myTreeBuilder.getUi().isPassthroughMode()) {
            runnable.run();
        } else {
            Application app = ApplicationManager.getApplication();
            if (app != null) {
                app.invokeLater(runnable);
            } else {
                UIUtil.invokeAndWaitIfNeeded((Runnable)runnable);
            }
        }
    }

    protected ActionCallback beforeUpdate(TreeUpdatePass pass) {
        return new ActionCallback.Done();
    }

    public boolean addSubtreeToUpdateByElement(Object element) {
        DefaultMutableTreeNode node;
        if (LOG.isDebugEnabled()) {
            LOG.debug("addSubtreeToUpdateByElement:" + element);
        }
        if ((node = this.myTreeBuilder.getNodeForElement(element)) != null) {
            this.addSubtreeToUpdate(node);
            return true;
        }
        return false;
    }

    public void cancelAllRequests() {
        this.myNodeQueue.clear();
        this.myUpdateQueue.cancelAllUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAfterUpdate(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        List<Runnable> list = this.myRunAfterUpdate;
        synchronized (list) {
            this.myRunAfterUpdate.add(runnable);
        }
    }

    public synchronized void runBeforeUpdate(Runnable runnable) {
        this.myRunBeforeUpdate = runnable;
    }

    public long getUpdateCount() {
        return this.myUpdateCount;
    }

    public boolean isRerunNeededFor(TreeUpdatePass pass) {
        return pass.getUpdateStamp() < this.getUpdateCount();
    }

    public boolean isInPostponeMode() {
        return !this.myUpdateQueue.isActive() && !this.myUpdateQueue.isPassThrough();
    }

    @Override
    public void showNotify() {
        this.myUpdateQueue.showNotify();
    }

    @Override
    public void hideNotify() {
        this.myUpdateQueue.hideNotify();
    }

    protected boolean isEdt() {
        return Alarm.isEventDispatchThread();
    }

    public String toString() {
        return "AbstractTreeUpdater updateCount=" + this.myUpdateCount + " queue=[" + this.myUpdateQueue.toString() + "] " + " nodeQueue=" + this.myNodeQueue;
    }

    public void flush() {
        this.myUpdateQueue.sendFlush();
    }

    public boolean isEnqueuedToUpdate(DefaultMutableTreeNode node) {
        for (TreeUpdatePass each : this.myNodeQueue) {
            if (!each.willUpdate(node)) continue;
            return true;
        }
        return false;
    }

    public final void queueSelection(final SelectionRequest request) {
        this.queue(new Update("UserSelection", 999){

            @Override
            public void run() {
                request.execute(AbstractTreeUpdater.this.myTreeBuilder.getUi());
            }

            @Override
            public boolean isExpired() {
                return AbstractTreeUpdater.this.myTreeBuilder.isDisposed();
            }

            @Override
            public void setRejected() {
                request.reject();
            }
        });
    }

    public void requestRelease() {
        this.myReleaseRequested = true;
        this.reset();
        this.myUpdateQueue.deactivate();
    }

    public void reset() {
        TreeUpdatePass[] passes = this.myNodeQueue.toArray(new TreeUpdatePass[this.myNodeQueue.size()]);
        this.myNodeQueue.clear();
        this.myUpdateQueue.cancelAllUpdates();
        for (TreeUpdatePass each : passes) {
            this.myTreeBuilder.getUi().addToCancelled(each.getNode());
        }
    }
}

