/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.SpacingFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;

public abstract class Spacing {
    private static SpacingFactory myFactory;
    private static final Logger LOG;

    static void setFactory(SpacingFactory factory) {
        myFactory = factory;
    }

    public static Spacing createSpacing(int minSpaces, int maxSpaces, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines) {
        return myFactory.createSpacing(minSpaces, maxSpaces, minLineFeeds, keepLineBreaks, keepBlankLines);
    }

    public static Spacing createSpacing(int minSpaces, int maxSpaces, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines, int prefLineFeeds) {
        return myFactory.createSpacing(minSpaces, maxSpaces, minLineFeeds, keepLineBreaks, keepBlankLines, prefLineFeeds);
    }

    public static Spacing getReadOnlySpacing() {
        return myFactory.getReadOnlySpacing();
    }

    public static Spacing createDependentLFSpacing(int minSpaces, int maxSpaces, TextRange dependance, boolean keepLineBreaks, int keepBlankLines) {
        return myFactory.createDependentLFSpacing(minSpaces, maxSpaces, dependance, keepLineBreaks, keepBlankLines);
    }

    public static Spacing createSafeSpacing(boolean keepLineBreaks, int keepBlankLines) {
        return myFactory.createSafeSpacing(keepLineBreaks, keepBlankLines);
    }

    public static Spacing createKeepingFirstColumnSpacing(int minSpaces, int maxSpaces, boolean keepLineBreaks, int keepBlankLines) {
        return myFactory.createKeepingFirstColumnSpacing(minSpaces, maxSpaces, keepLineBreaks, keepBlankLines);
    }

    static {
        LOG = Logger.getInstance((String)"#com.intellij.formatting.Spacing");
    }
}

