/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionProfileEntry {
    public static final String GENERAL_GROUP_NAME = InspectionsBundle.message("inspection.general.tools.group.name", new Object[0]);

    @Nls
    @NotNull
    public abstract String getGroupDisplayName();

    @NotNull
    public String[] getGroupPath() {
        String groupDisplayName = this.getGroupDisplayName();
        if (groupDisplayName.length() == 0) {
            groupDisplayName = GENERAL_GROUP_NAME;
        }
        String[] stringArray = new String[]{groupDisplayName};
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/InspectionProfileEntry.getGroupPath must not return null");
        }
        return stringArray;
    }

    @Nls
    @NotNull
    public abstract String getDisplayName();

    @NonNls
    @NotNull
    public abstract String getShortName();

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/InspectionProfileEntry.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return null;
    }

    public void readSettings(Element node) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)node);
    }

    public void writeSettings(Element node) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)node);
    }

    public void projectOpened(Project project) {
    }

    public void projectClosed(Project project) {
    }

    @Nullable
    public String getStaticDescription() {
        return null;
    }

    @Nullable
    public String getDescriptionFileName() {
        return null;
    }

    @Nullable
    private URL getDescriptionUrl() {
        String fileName = this.getDescriptionFileName();
        if (fileName == null) {
            return null;
        }
        return ResourceUtil.getResource(this.getDescriptionContextClass(), (String)"/inspectionDescriptions", (String)fileName);
    }

    protected Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        return this.getClass();
    }

    @Nullable
    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            URL descriptionUrl = this.getDescriptionUrl();
            if (descriptionUrl == null) {
                return null;
            }
            return ResourceUtil.loadText((URL)descriptionUrl);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

