/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightTestData;
import com.intellij.codeInsight.EditorInfo;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testFramework.PsiTestCase;
import com.intellij.testFramework.PsiTestData;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public abstract class CodeInsightTestCase
extends PsiTestCase {
    protected Editor myEditor;
    public static final String CARET_MARKER = "<caret>";
    public static final String SELECTION_START_MARKER = "<selection>";
    public static final String SELECTION_END_MARKER = "</selection>";

    public CodeInsightTestCase() {
        this.myRunCommandForTest = true;
    }

    protected Editor createEditor(VirtualFile file) {
        FileEditorManager instance = FileEditorManager.getInstance(this.myProject);
        if (file.getFileType().isBinary()) {
            return null;
        }
        return instance.openTextEditor(new OpenFileDescriptor(this.myProject, file, 0), false);
    }

    @Override
    protected void tearDown() throws Exception {
        VirtualFile[] openFiles;
        FileEditorManager editorManager = FileEditorManager.getInstance(this.myProject);
        for (VirtualFile openFile : openFiles = editorManager.getOpenFiles()) {
            editorManager.closeFile(openFile);
        }
        this.myEditor = null;
        super.tearDown();
    }

    @Override
    protected PsiTestData createData() {
        return new CodeInsightTestData();
    }

    protected void configureByFile(@NonNls String filePath) throws Exception {
        this.configureByFile(filePath, null);
    }

    protected VirtualFile configureByFiles(String projectRoot, String ... files) throws Exception {
        VirtualFile[] vFiles = new VirtualFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            VirtualFile vFile;
            String path = files[i];
            String fullPath = FileUtil.toSystemIndependentName((String)(this.getTestDataPath() + path));
            vFiles[i] = vFile = LocalFileSystem.getInstance().findFileByPath(fullPath);
            CodeInsightTestCase.assertNotNull((String)("file " + fullPath + " not found"), (Object)vFile);
        }
        File projectFile = projectRoot == null ? null : new File(this.getTestDataPath() + projectRoot);
        return this.configureByFiles(projectFile, vFiles);
    }

    protected VirtualFile configureByFile(@NonNls String filePath, String projectRoot) throws Exception {
        String fullPath = this.getTestDataPath() + filePath;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fullPath.replace(File.separatorChar, '/'));
        CodeInsightTestCase.assertNotNull((String)("file " + fullPath + " not found"), (Object)vFile);
        File projectFile = projectRoot == null ? null : new File(this.getTestDataPath() + projectRoot);
        return this.configureByFile(vFile, projectFile);
    }

    protected PsiFile configureByText(FileType fileType, @NonNls String text) throws Throwable {
        return this.configureByText(fileType, text, null);
    }

    protected PsiFile configureByText(final FileType fileType, @NonNls String text, String _extension) throws Throwable {
        final String extension = _extension == null ? fileType.getDefaultExtension() : _extension;
        File dir = this.createTempDirectory();
        File tempFile = File.createTempFile("aaa", "." + extension, dir);
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager.getFileTypeByExtension(extension) != fileType) {
            new WriteCommandAction(this.getProject(), new PsiFile[0]){

                @Override
                protected void run(Result result) throws Throwable {
                    fileTypeManager.associateExtension(fileType, extension);
                }
            }.execute();
        }
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
        VfsUtil.saveText(vFile, text);
        assert (vFile != null);
        VirtualFile vdir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
        ModuleRootManager rootManager = ModuleRootManager.getInstance(this.myModule);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        ContentEntry contentEntry = rootModel.addContentEntry(vdir);
        contentEntry.addSourceFolder(vdir, false);
        rootModel.commit();
        this.configureByExistingFile(vFile);
        CodeInsightTestCase.assertEquals((Object)fileType, (Object)this.myFile.getVirtualFile().getFileType());
        return this.myFile;
    }

    @Override
    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    protected void configureByFile(VirtualFile vFile) throws IOException {
        this.configureByFile(vFile, null);
    }

    protected void configureByExistingFile(VirtualFile virtualFile) {
        this.myFile = null;
        this.myEditor = null;
        Editor editor = this.createEditor(virtualFile);
        Document document = editor.getDocument();
        EditorInfo editorInfo = new EditorInfo(document.getText());
        String newFileText = editorInfo.getNewFileText();
        if (!document.getText().equals(newFileText)) {
            document.setText(newFileText);
        }
        PsiFile file = this.myPsiManager.findFile(virtualFile);
        if (this.myFile == null) {
            this.myFile = file;
        }
        if (this.myEditor == null) {
            this.myEditor = editor;
        }
        editorInfo.applyToEditor(editor);
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
    }

    protected VirtualFile configureByFiles(final File projectRoot, VirtualFile ... vFiles) throws IOException {
        LinkedHashMap<VirtualFile, EditorInfo> editorInfos;
        this.myFile = null;
        this.myEditor = null;
        ModuleRootManager rootManager = ModuleRootManager.getInstance(this.myModule);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        if (this.clearModelBeforeConfiguring()) {
            rootModel.clear();
        }
        File toDirIO = this.createTempDirectory();
        VirtualFile toDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(toDirIO.getCanonicalPath().replace(File.separatorChar, '/'));
        vFiles = (VirtualFile[])ArrayUtil.reverseArray((Object[])vFiles);
        if (projectRoot != null) {
            FileUtil.copyDir((File)projectRoot, (File)toDirIO);
            VirtualFile fromDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectRoot);
            editorInfos = this.copyFilesFillingEditorInfos(fromDir, toDir, (String[])ContainerUtil.map2Array((Object[])vFiles, String.class, (Function)new Function<VirtualFile, String>(){

                public String fun(VirtualFile s) {
                    return s.getPath().substring(projectRoot.getPath().length());
                }
            }));
            VirtualFileManager.getInstance().refresh(false);
        } else {
            editorInfos = new LinkedHashMap<VirtualFile, EditorInfo>();
            for (VirtualFile vFile : vFiles) {
                editorInfos.putAll(this.copyFilesFillingEditorInfos(vFile.getParent(), toDir, vFile.getName()));
            }
        }
        boolean sourceRootAdded = false;
        if (this.isAddDirToContentRoot()) {
            ContentEntry contentEntry = rootModel.addContentEntry(toDir);
            if (this.isAddDirToSource()) {
                sourceRootAdded = true;
                contentEntry.addSourceFolder(toDir, false);
            }
        }
        this.doCommitModel(rootModel);
        if (sourceRootAdded) {
            this.sourceRootAdded(toDir);
        }
        this.openEditorsAndActivateLast(editorInfos);
        return toDir;
    }

    protected void doCommitModel(ModifiableRootModel rootModel) {
        rootModel.commit();
    }

    protected void sourceRootAdded(VirtualFile dir) {
    }

    protected LinkedHashMap<VirtualFile, EditorInfo> copyFilesFillingEditorInfos(String testDataFromDir, VirtualFile toDir, String ... relativePaths) throws IOException {
        if (!testDataFromDir.startsWith("/")) {
            testDataFromDir = "/" + testDataFromDir;
        }
        return this.copyFilesFillingEditorInfos(LocalFileSystem.getInstance().refreshAndFindFileByPath(this.getTestDataPath() + testDataFromDir), toDir, relativePaths);
    }

    protected LinkedHashMap<VirtualFile, EditorInfo> copyFilesFillingEditorInfos(VirtualFile fromDir, VirtualFile toDir, String ... relativePaths) throws IOException {
        LinkedHashMap<VirtualFile, EditorInfo> editorInfos = new LinkedHashMap<VirtualFile, EditorInfo>();
        ArrayList<OutputStream> streamsToClose = new ArrayList<OutputStream>();
        for (String relativePath : relativePaths) {
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            VirtualFile fromFile = fromDir.findFileByRelativePath(relativePath);
            CodeInsightTestCase.assertNotNull((String)(fromDir.getPath() + "/" + relativePath), (Object)fromFile);
            VirtualFile toFile = toDir.findFileByRelativePath(relativePath);
            if (toFile == null) {
                File file = new File(toDir.getPath(), relativePath);
                FileUtil.createIfDoesntExist((File)file);
                toFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                CodeInsightTestCase.assertNotNull((String)file.getCanonicalPath(), (Object)toFile);
            }
            editorInfos.put(toFile, this.copyContent(fromFile, toFile, streamsToClose));
        }
        for (int i = streamsToClose.size() - 1; i >= 0; --i) {
            ((OutputStream)streamsToClose.get(i)).close();
        }
        return editorInfos;
    }

    private EditorInfo copyContent(VirtualFile from, VirtualFile to, List<OutputStream> streamsToClose) throws IOException {
        byte[] content = from.getFileType().isBinary() ? from.contentsToByteArray() : null;
        String fileText = from.getFileType().isBinary() ? null : StringUtil.convertLineSeparators((String)VfsUtil.loadText(from));
        EditorInfo editorInfo = fileText != null ? new EditorInfo(fileText) : null;
        String newFileText = fileText != null ? editorInfo.getNewFileText() : null;
        this.doWrite(newFileText, to, content, streamsToClose);
        return editorInfo;
    }

    protected final void setActiveEditor(Editor editor) {
        this.myEditor = editor;
        this.myFile = this.getPsiFile(editor.getDocument());
    }

    protected List<Editor> openEditorsAndActivateLast(LinkedHashMap<VirtualFile, EditorInfo> editorInfos) {
        List<Editor> list = this.openEditors(editorInfos);
        this.setActiveEditor(list.get(list.size() - 1));
        return list;
    }

    protected final List<Editor> openEditors(final LinkedHashMap<VirtualFile, EditorInfo> editorInfos) {
        return ContainerUtil.map(editorInfos.keySet(), (Function)new Function<VirtualFile, Editor>(){

            public Editor fun(VirtualFile newVFile) {
                EditorInfo editorInfo;
                PsiFile file = CodeInsightTestCase.this.myPsiManager.findFile(newVFile);
                if (CodeInsightTestCase.this.myFile == null) {
                    CodeInsightTestCase.this.myFile = file;
                }
                Editor editor = CodeInsightTestCase.this.createEditor(newVFile);
                if (CodeInsightTestCase.this.myEditor == null) {
                    CodeInsightTestCase.this.myEditor = editor;
                }
                if ((editorInfo = (EditorInfo)editorInfos.get(newVFile)) != null) {
                    editorInfo.applyToEditor(editor);
                }
                return editor;
            }
        });
    }

    private void doWrite(String newFileText, VirtualFile newVFile, byte[] content, List<OutputStream> streamsToClose) throws IOException {
        if (newFileText != null) {
            VfsUtil.saveText(newVFile, newFileText);
        } else {
            OutputStream outputStream = newVFile.getOutputStream((Object)this, -1L, -1L);
            outputStream.write(content);
            streamsToClose.add(outputStream);
        }
    }

    protected boolean isAddDirToContentRoot() {
        return true;
    }

    protected boolean isAddDirToSource() {
        return true;
    }

    protected VirtualFile configureByFile(VirtualFile vFile, File projectRoot) throws IOException {
        return this.configureByFiles(projectRoot, vFile);
    }

    protected boolean clearModelBeforeConfiguring() {
        return false;
    }

    protected void setupCursorAndSelection(Editor editor) {
        RangeMarker selEndMarker;
        Document document = editor.getDocument();
        String text = document.getText();
        int caretIndex = text.indexOf(CARET_MARKER);
        int selStartIndex = text.indexOf(SELECTION_START_MARKER);
        int selEndIndex = text.indexOf(SELECTION_END_MARKER);
        RangeMarker caretMarker = caretIndex >= 0 ? document.createRangeMarker(caretIndex, caretIndex) : null;
        RangeMarker selStartMarker = selStartIndex >= 0 ? document.createRangeMarker(selStartIndex, selStartIndex) : null;
        RangeMarker rangeMarker = selEndMarker = selEndIndex >= 0 ? document.createRangeMarker(selEndIndex, selEndIndex) : null;
        if (caretMarker != null) {
            document.deleteString(caretMarker.getStartOffset(), caretMarker.getStartOffset() + CARET_MARKER.length());
        }
        if (selStartMarker != null) {
            document.deleteString(selStartMarker.getStartOffset(), selStartMarker.getStartOffset() + SELECTION_START_MARKER.length());
        }
        if (selEndMarker != null) {
            document.deleteString(selEndMarker.getStartOffset(), selEndMarker.getStartOffset() + SELECTION_END_MARKER.length());
        }
        String newText = document.getText();
        if (caretMarker != null) {
            int caretLine = StringUtil.offsetToLineNumber((CharSequence)newText, (int)caretMarker.getStartOffset());
            int caretCol = caretMarker.getStartOffset() - StringUtil.lineColToOffset((CharSequence)newText, (int)caretLine, (int)0);
            LogicalPosition pos = new LogicalPosition(caretLine, caretCol);
            editor.getCaretModel().moveToLogicalPosition(pos);
        }
        if (selStartMarker != null) {
            editor.getSelectionModel().setSelection(selStartMarker.getStartOffset(), selEndMarker.getStartOffset());
        }
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
    }

    @Override
    protected void configure(String path, String dataName) throws Exception {
        int selectionEnd;
        super.configure(path, dataName);
        this.myEditor = this.createEditor(this.myFile.getVirtualFile());
        CodeInsightTestData data = (CodeInsightTestData)this.myTestDataBefore;
        LogicalPosition pos = new LogicalPosition(data.getLineNumber() - 1, data.getColumnNumber() - 1);
        this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        int selectionStart = selectionEnd = this.myEditor.getCaretModel().getOffset();
        if (data.getSelectionStartColumnNumber() >= 0) {
            selectionStart = this.myEditor.logicalPositionToOffset(new LogicalPosition(data.getSelectionEndLineNumber() - 1, data.getSelectionStartColumnNumber() - 1));
            selectionEnd = this.myEditor.logicalPositionToOffset(new LogicalPosition(data.getSelectionEndLineNumber() - 1, data.getSelectionEndColumnNumber() - 1));
        }
        this.myEditor.getSelectionModel().setSelection(selectionStart, selectionEnd);
    }

    protected void checkResultByFile(@NonNls String filePath) throws Exception {
        this.checkResultByFile(filePath, false);
    }

    protected void checkResultByFile(String filePath, boolean stripTrailingSpaces) throws Exception {
        String newFileText;
        RangeMarker selEndMarker;
        this.getProject().getComponent(PostprocessReformattingAspect.class).doPostponedFormatting();
        if (stripTrailingSpaces) {
            ((DocumentEx)this.myEditor.getDocument()).stripTrailingSpaces(false);
        }
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        String fullPath = this.getTestDataPath() + filePath;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fullPath.replace(File.separatorChar, '/'));
        CodeInsightTestCase.assertNotNull((String)("Cannot find file " + fullPath), (Object)vFile);
        String fileText = StringUtil.convertLineSeparators((String)VfsUtil.loadText(vFile));
        Document document = EditorFactory.getInstance().createDocument(fileText);
        int caretIndex = fileText.indexOf(CARET_MARKER);
        int selStartIndex = fileText.indexOf(SELECTION_START_MARKER);
        int selEndIndex = fileText.indexOf(SELECTION_END_MARKER);
        RangeMarker caretMarker = caretIndex >= 0 ? document.createRangeMarker(caretIndex, caretIndex) : null;
        RangeMarker selStartMarker = selStartIndex >= 0 ? document.createRangeMarker(selStartIndex, selStartIndex) : null;
        RangeMarker rangeMarker = selEndMarker = selEndIndex >= 0 ? document.createRangeMarker(selEndIndex, selEndIndex) : null;
        if (caretMarker != null) {
            document.deleteString(caretMarker.getStartOffset(), caretMarker.getStartOffset() + CARET_MARKER.length());
        }
        if (selStartMarker != null) {
            document.deleteString(selStartMarker.getStartOffset(), selStartMarker.getStartOffset() + SELECTION_START_MARKER.length());
        }
        if (selEndMarker != null) {
            document.deleteString(selEndMarker.getStartOffset(), selEndMarker.getStartOffset() + SELECTION_END_MARKER.length());
        }
        String newFileText1 = newFileText = document.getText();
        if (stripTrailingSpaces) {
            Document document1 = EditorFactory.getInstance().createDocument(newFileText);
            ((DocumentEx)document1).stripTrailingSpaces(false);
            newFileText1 = document1.getText();
        }
        if (this.myEditor instanceof EditorWindow) {
            this.myEditor = ((EditorWindow)this.myEditor).getDelegate();
            this.myFile = PsiDocumentManager.getInstance(this.getProject()).getPsiFile(this.myEditor.getDocument());
        }
        String text = this.myFile.getText();
        text = StringUtil.convertLineSeparators((String)text);
        CodeInsightTestCase.assertEquals((String)("Text mismatch in file " + filePath), (String)newFileText1, (String)text);
        if (caretMarker != null) {
            int caretLine = StringUtil.offsetToLineNumber((CharSequence)newFileText, (int)caretMarker.getStartOffset());
            int caretCol = caretMarker.getStartOffset() - StringUtil.lineColToOffset((CharSequence)newFileText, (int)caretLine, (int)0);
            CodeInsightTestCase.assertEquals((String)"caretLine", (int)(caretLine + 1), (int)(this.myEditor.getCaretModel().getLogicalPosition().line + 1));
            CodeInsightTestCase.assertEquals((String)"caretColumn", (int)(caretCol + 1), (int)(this.myEditor.getCaretModel().getLogicalPosition().column + 1));
        }
        if (selStartMarker != null && selEndMarker != null) {
            int selStartLine = StringUtil.offsetToLineNumber((CharSequence)newFileText, (int)selStartMarker.getStartOffset());
            int selStartCol = selStartMarker.getStartOffset() - StringUtil.lineColToOffset((CharSequence)newFileText, (int)selStartLine, (int)0);
            int selEndLine = StringUtil.offsetToLineNumber((CharSequence)newFileText, (int)selEndMarker.getEndOffset());
            int selEndCol = selEndMarker.getEndOffset() - StringUtil.lineColToOffset((CharSequence)newFileText, (int)selEndLine, (int)0);
            CodeInsightTestCase.assertEquals((String)"selectionStartLine", (int)(selStartLine + 1), (int)(StringUtil.offsetToLineNumber((CharSequence)newFileText, (int)this.myEditor.getSelectionModel().getSelectionStart()) + 1));
            CodeInsightTestCase.assertEquals((String)"selectionStartCol", (int)(selStartCol + 1), (int)(this.myEditor.getSelectionModel().getSelectionStart() - StringUtil.lineColToOffset((CharSequence)newFileText, (int)selStartLine, (int)0) + 1));
            CodeInsightTestCase.assertEquals((String)"selectionEndLine", (int)(selEndLine + 1), (int)(StringUtil.offsetToLineNumber((CharSequence)newFileText, (int)this.myEditor.getSelectionModel().getSelectionEnd()) + 1));
            CodeInsightTestCase.assertEquals((String)"selectionEndCol", (int)(selEndCol + 1), (int)(this.myEditor.getSelectionModel().getSelectionEnd() - StringUtil.lineColToOffset((CharSequence)newFileText, (int)selEndLine, (int)0) + 1));
        } else {
            CodeInsightTestCase.assertTrue((String)"has no selection", (!this.myEditor.getSelectionModel().hasSelection() ? 1 : 0) != 0);
        }
    }

    @Override
    protected void checkResult(String dataName) throws Exception {
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        super.checkResult(dataName);
        CodeInsightTestData data = (CodeInsightTestData)this.myTestDataAfter;
        if (data.getColumnNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":caretColumn"), (int)data.getColumnNumber(), (int)(this.myEditor.getCaretModel().getLogicalPosition().column + 1));
        }
        if (data.getLineNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":caretLine"), (int)data.getLineNumber(), (int)(this.myEditor.getCaretModel().getLogicalPosition().line + 1));
        }
        int selectionStart = this.myEditor.getSelectionModel().getSelectionStart();
        int selectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
        LogicalPosition startPosition = this.myEditor.offsetToLogicalPosition(selectionStart);
        LogicalPosition endPosition = this.myEditor.offsetToLogicalPosition(selectionEnd);
        if (data.getSelectionStartColumnNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":selectionStartColumn"), (int)data.getSelectionStartColumnNumber(), (int)(startPosition.column + 1));
        }
        if (data.getSelectionStartLineNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":selectionStartLine"), (int)data.getSelectionStartLineNumber(), (int)(startPosition.line + 1));
        }
        if (data.getSelectionEndColumnNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":selectionEndColumn"), (int)data.getSelectionEndColumnNumber(), (int)(endPosition.column + 1));
        }
        if (data.getSelectionEndLineNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":selectionEndLine"), (int)data.getSelectionEndLineNumber(), (int)(endPosition.line + 1));
        }
    }

    public Object getData(String dataId) {
        return PlatformDataKeys.EDITOR.is(dataId) ? this.myEditor : super.getData(dataId);
    }

    protected VirtualFile getVirtualFile(@NonNls String filePath) {
        String fullPath = this.getTestDataPath() + filePath;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fullPath.replace(File.separatorChar, '/'));
        CodeInsightTestCase.assertNotNull((String)("file " + fullPath + " not found"), (Object)vFile);
        return vFile;
    }

    protected String getTestRoot() {
        return FileUtil.toSystemIndependentName((String)this.getTestDataPath());
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    protected void type(char c) {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        TypedAction action = actionManager.getTypedAction();
        action.actionPerformed(this.getEditor(), c, DataManager.getInstance().getDataContext());
    }

    protected void type(@NonNls String s) {
        for (char c : s.toCharArray()) {
            this.type(c);
        }
    }

    protected void undo() {
        UndoManager undoManager = UndoManager.getInstance(this.myProject);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(this.getEditor());
        undoManager.undo(textEditor);
    }

    protected void backspace() {
        CommandProcessor.getInstance().executeCommand(this.getProject(), new Runnable(){

            @Override
            public void run() {
                EditorActionManager actionManager = EditorActionManager.getInstance();
                EditorActionHandler actionHandler = actionManager.getActionHandler("EditorBackSpace");
                actionHandler.execute(CodeInsightTestCase.this.getEditor(), DataManager.getInstance().getDataContext());
            }
        }, "backspace", this.getEditor().getDocument());
    }

    protected void ctrlShiftF7() {
        HighlightUsagesHandler.invoke((Project)this.getProject(), (Editor)this.getEditor(), (PsiFile)this.getFile());
    }

    public static void ctrlW() {
        AnAction action = ActionManager.getInstance().getAction("EditorSelectWord");
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext(), "", action.getTemplatePresentation(), ActionManager.getInstance(), 0);
        event.setInjectedContext(true);
        action.actionPerformed(event);
    }
}

