/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.switchtoif;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ControlFlowUtils;
import com.siyeh.ipp.psiutils.SideEffectChecker;
import com.siyeh.ipp.switchtoif.CaseUtil;
import com.siyeh.ipp.switchtoif.SwitchPredicate;
import com.siyeh.ipp.switchtoif.SwitchStatementBranch;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceSwitchWithIfIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        SwitchPredicate switchPredicate = new SwitchPredicate();
        if (switchPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/switchtoif/ReplaceSwitchWithIfIntention.getElementPredicate must not return null");
        }
        return switchPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        String declarationString;
        String expressionText;
        boolean hadSideEffects;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/switchtoif/ReplaceSwitchWithIfIntention.processIntention must not be null");
        }
        PsiJavaToken switchToken = (PsiJavaToken)element;
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)switchToken.getParent();
        if (switchStatement == null) {
            return;
        }
        PsiExpression switchExpression = switchStatement.getExpression();
        if (switchExpression == null) {
            return;
        }
        Project project = element.getProject();
        if (SideEffectChecker.mayHaveSideEffects(switchExpression)) {
            String variableName;
            hadSideEffects = true;
            PsiType switchExpressionType = switchExpression.getType();
            if (switchExpressionType == null) {
                return;
            }
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            expressionText = variableName = javaCodeStyleManager.suggestUniqueVariableName("i", (PsiElement)switchExpression, true);
            declarationString = switchExpressionType.getPresentableText() + ' ' + variableName + " = " + switchExpression.getText() + ';';
        } else {
            hadSideEffects = false;
            declarationString = null;
            expressionText = switchExpression.getText();
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return;
        }
        PsiStatement[] statements = body.getStatements();
        boolean renameBreaks = false;
        for (int i = 1; i < statements.length - 1; ++i) {
            if (!CaseUtil.containsHiddenBreak(statements[i])) continue;
            renameBreaks = true;
            break;
        }
        ArrayList<SwitchStatementBranch> openBranches = new ArrayList<SwitchStatementBranch>();
        HashSet<PsiLocalVariable> declaredVariables = new HashSet<PsiLocalVariable>();
        ArrayList<SwitchStatementBranch> allBranches = new ArrayList<SwitchStatementBranch>();
        SwitchStatementBranch currentBranch = null;
        PsiElement[] children = body.getChildren();
        for (int i = 1; i < children.length - 1; ++i) {
            PsiElement statement = children[i];
            if (statement instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement label = (PsiSwitchLabelStatement)statement;
                if (currentBranch == null) {
                    openBranches.clear();
                    currentBranch = new SwitchStatementBranch();
                    currentBranch.addPendingVariableDeclarations(declaredVariables);
                    allBranches.add(currentBranch);
                    openBranches.add(currentBranch);
                } else if (currentBranch.hasStatements()) {
                    currentBranch = new SwitchStatementBranch();
                    allBranches.add(currentBranch);
                    openBranches.add(currentBranch);
                }
                if (label.isDefaultCase()) {
                    currentBranch.setDefault();
                    continue;
                }
                PsiExpression value = label.getCaseValue();
                String valueText = ReplaceSwitchWithIfIntention.getCaseValueText(value);
                currentBranch.addCaseValue(valueText);
                continue;
            }
            if (statement instanceof PsiStatement) {
                if (statement instanceof PsiDeclarationStatement) {
                    PsiElement[] elements;
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                    for (PsiElement varElement : elements = declarationStatement.getDeclaredElements()) {
                        PsiLocalVariable variable = (PsiLocalVariable)varElement;
                        declaredVariables.add(variable);
                    }
                }
                for (SwitchStatementBranch branch : openBranches) {
                    branch.addStatement(statement);
                }
                if (ControlFlowUtils.statementMayCompleteNormally((PsiStatement)statement)) continue;
                currentBranch = null;
                continue;
            }
            for (SwitchStatementBranch branch : openBranches) {
                if (statement instanceof PsiWhiteSpace) {
                    branch.addWhiteSpace(statement);
                    continue;
                }
                branch.addComment(statement);
            }
        }
        StringBuilder ifStatementText = new StringBuilder();
        String breakLabel = null;
        if (renameBreaks) {
            breakLabel = CaseUtil.findUniqueLabel((PsiStatement)switchStatement, "Label");
            ifStatementText.append(breakLabel);
            ifStatementText.append(':');
        }
        boolean firstBranch = true;
        SwitchStatementBranch defaultBranch = null;
        for (SwitchStatementBranch branch : allBranches) {
            if (branch.isDefault()) {
                defaultBranch = branch;
                continue;
            }
            List<String> caseValues = branch.getCaseValues();
            List<PsiElement> bodyElements = branch.getBodyElements();
            Set<PsiLocalVariable> pendingVariableDeclarations = branch.getPendingVariableDeclarations();
            ReplaceSwitchWithIfIntention.dumpBranch(ifStatementText, expressionText, caseValues, bodyElements, firstBranch, renameBreaks, breakLabel, pendingVariableDeclarations);
            firstBranch = false;
        }
        if (defaultBranch != null) {
            List<PsiElement> bodyElements = defaultBranch.getBodyElements();
            Set<PsiLocalVariable> pendingVariableDeclarations = defaultBranch.getPendingVariableDeclarations();
            ReplaceSwitchWithIfIntention.dumpDefaultBranch(ifStatementText, bodyElements, firstBranch, renameBreaks, breakLabel, pendingVariableDeclarations);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        if (hadSideEffects) {
            PsiStatement declarationStatement = factory.createStatementFromText(declarationString, (PsiElement)switchStatement);
            PsiStatement ifStatement = factory.createStatementFromText(ifStatementText.toString(), (PsiElement)switchStatement);
            PsiElement ifElement = switchStatement.replace((PsiElement)ifStatement);
            PsiElement parent = ifElement.getParent();
            assert (parent != null);
            parent.addBefore((PsiElement)declarationStatement, ifElement);
        } else {
            PsiStatement newStatement = factory.createStatementFromText(ifStatementText.toString(), (PsiElement)switchStatement);
            switchStatement.replace((PsiElement)newStatement);
        }
    }

    private static String getCaseValueText(PsiExpression value) {
        if (value == null) {
            return "";
        }
        if (value instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)value;
            PsiExpression expression = parenthesizedExpression.getExpression();
            return ReplaceSwitchWithIfIntention.getCaseValueText(expression);
        }
        if (!(value instanceof PsiReferenceExpression)) {
            return value.getText();
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value;
        PsiElement target = referenceExpression.resolve();
        String text = referenceExpression.getText();
        if (!(target instanceof PsiEnumConstant)) {
            return value.getText();
        }
        PsiEnumConstant enumConstant = (PsiEnumConstant)target;
        PsiClass aClass = enumConstant.getContainingClass();
        if (aClass == null) {
            return value.getText();
        }
        String name = aClass.getQualifiedName();
        return name + '.' + text;
    }

    private static void dumpBranch(@NonNls StringBuilder ifStatementString, String expressionText, List<String> caseValues, List<PsiElement> bodyStatements, boolean firstBranch, boolean renameBreaks, String breakLabel, Set<PsiLocalVariable> variables) {
        if (!firstBranch) {
            ifStatementString.append("else ");
        }
        ReplaceSwitchWithIfIntention.dumpCaseValues(ifStatementString, expressionText, caseValues);
        ReplaceSwitchWithIfIntention.dumpBody(ifStatementString, bodyStatements, renameBreaks, breakLabel, variables);
    }

    private static void dumpDefaultBranch(@NonNls StringBuilder ifStatementString, List<PsiElement> bodyStatements, boolean firstBranch, boolean renameBreaks, String breakLabel, Set<PsiLocalVariable> variables) {
        if (!firstBranch) {
            ifStatementString.append("else ");
        }
        ReplaceSwitchWithIfIntention.dumpBody(ifStatementString, bodyStatements, renameBreaks, breakLabel, variables);
    }

    private static void dumpCaseValues(@NonNls StringBuilder ifStatementString, String expressionText, List<String> caseValues) {
        ifStatementString.append("if(");
        boolean firstCaseValue = true;
        for (String caseValue : caseValues) {
            if (!firstCaseValue) {
                ifStatementString.append("||");
            }
            firstCaseValue = false;
            ifStatementString.append(expressionText);
            ifStatementString.append("==");
            ifStatementString.append(caseValue);
        }
        ifStatementString.append(')');
    }

    private static void dumpBody(@NonNls StringBuilder ifStatementString, List<PsiElement> bodyStatements, boolean renameBreaks, String breakLabel, Set<PsiLocalVariable> variables) {
        ifStatementString.append('{');
        for (PsiLocalVariable variable : variables) {
            if (!CaseUtil.isUsedByStatementList(variable, bodyStatements)) continue;
            PsiType varType = variable.getType();
            ifStatementString.append(varType.getPresentableText());
            ifStatementString.append(' ');
            ifStatementString.append(variable.getName());
            ifStatementString.append(';');
        }
        for (PsiElement bodyStatement : bodyStatements) {
            String text = bodyStatement.getText();
            if ("break;".equals(text)) continue;
            ReplaceSwitchWithIfIntention.appendElement(ifStatementString, bodyStatement, renameBreaks, breakLabel);
        }
        ifStatementString.append("\n}");
    }

    private static void appendElement(@NonNls StringBuilder ifStatementString, PsiElement element, boolean renameBreakElements, String breakLabelString) {
        if (!renameBreakElements) {
            String text = element.getText();
            ifStatementString.append(text);
        } else if (element instanceof PsiBreakStatement) {
            PsiIdentifier identifier = ((PsiBreakStatement)element).getLabelIdentifier();
            if (identifier == null || "".equals(identifier.getText())) {
                ifStatementString.append("break ");
                ifStatementString.append(breakLabelString);
                ifStatementString.append(';');
            } else {
                String text = element.getText();
                ifStatementString.append(text);
            }
        } else if (element instanceof PsiBlockStatement || element instanceof PsiCodeBlock || element instanceof PsiIfStatement) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                ReplaceSwitchWithIfIntention.appendElement(ifStatementString, child, renameBreakElements, breakLabelString);
            }
        } else {
            String text = element.getText();
            ifStatementString.append(text);
        }
    }
}

