/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import org.jetbrains.annotations.NonNls;

public class ConditionalUtils {
    private ConditionalUtils() {
    }

    public static PsiStatement stripBraces(PsiStatement branch) {
        if (branch instanceof PsiBlockStatement) {
            PsiBlockStatement block = (PsiBlockStatement)branch;
            PsiCodeBlock codeBlock = block.getCodeBlock();
            PsiStatement[] statements = codeBlock.getStatements();
            if (statements.length == 1) {
                return statements[0];
            }
            return block;
        }
        return branch;
    }

    public static boolean isReturn(PsiStatement statement, @NonNls String value) {
        if (statement == null) {
            return false;
        }
        if (!(statement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
        if (returnStatement.getReturnValue() == null) {
            return false;
        }
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null) {
            return false;
        }
        String returnValueText = returnValue.getText();
        return value.equals(returnValueText);
    }

    public static boolean isAssignment(PsiStatement statement, @NonNls String value) {
        if (statement == null) {
            return false;
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        if (!(expression instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
        PsiExpression rhs = assignment.getRExpression();
        if (rhs == null) {
            return false;
        }
        String rhsText = rhs.getText();
        return value.equals(rhsText);
    }

    public static boolean isAssignment(PsiStatement statement) {
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        return expression instanceof PsiAssignmentExpression;
    }
}

