/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.base;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.BoolUtils;
import com.siyeh.ipp.psiutils.ComparisonUtils;
import com.siyeh.ipp.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Intention
extends PsiElementBaseIntentionAction {
    private final PsiElementPredicate predicate = this.getElementPredicate();

    protected Intention() {
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/base/Intention.invoke must not be null");
        }
        if (Intention.isFileReadOnly(project, file)) {
            return;
        }
        PsiElement element = this.findMatchingElement(file, editor);
        if (element == null) {
            return;
        }
        this.processIntention(element);
    }

    protected abstract void processIntention(@NotNull PsiElement var1) throws IncorrectOperationException;

    @NotNull
    protected abstract PsiElementPredicate getElementPredicate();

    protected static void replaceExpression(@NotNull String newExpression, @NotNull PsiExpression expression) throws IncorrectOperationException {
        if (newExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/base/Intention.replaceExpression must not be null");
        }
        if (expression == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/base/Intention.replaceExpression must not be null");
        }
        PsiManager mgr = expression.getManager();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)mgr.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newCall = factory.createExpressionFromText(newExpression, (PsiElement)expression);
        PsiElement insertedElement = expression.replace((PsiElement)newCall);
        CodeStyleManager codeStyleManager = mgr.getCodeStyleManager();
        codeStyleManager.reformat(insertedElement);
    }

    protected static void replaceExpressionWithNegatedExpression(@NotNull PsiExpression newExpression, @NotNull PsiExpression expression) throws IncorrectOperationException {
        String expString;
        if (newExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/base/Intention.replaceExpressionWithNegatedExpression must not be null");
        }
        if (expression == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/base/Intention.replaceExpressionWithNegatedExpression must not be null");
        }
        PsiManager manager = expression.getManager();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression expressionToReplace = expression;
        String newExpressionText = newExpression.getText();
        if (BoolUtils.isNegated(expression)) {
            expressionToReplace = BoolUtils.findNegation(expression);
            expString = newExpressionText;
        } else if (ComparisonUtils.isComparison(newExpression)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)newExpression;
            PsiJavaToken sign = binaryExpression.getOperationSign();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            assert (rhs != null);
            expString = lhs.getText() + negatedComparison + rhs.getText();
        } else {
            expString = ParenthesesUtils.getPrecedence(newExpression) > 3 ? "!(" + newExpressionText + ')' : '!' + newExpressionText;
        }
        PsiExpression newCall = factory.createExpressionFromText(expString, (PsiElement)expression);
        assert (expressionToReplace != null);
        PsiElement insertedElement = expressionToReplace.replace((PsiElement)newCall);
        CodeStyleManager codeStyleManager = manager.getCodeStyleManager();
        codeStyleManager.reformat(insertedElement);
    }

    protected static void replaceExpressionWithNegatedExpressionString(@NotNull String newExpression, @NotNull PsiExpression expression) throws IncorrectOperationException {
        String expString;
        if (newExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/base/Intention.replaceExpressionWithNegatedExpressionString must not be null");
        }
        if (expression == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/base/Intention.replaceExpressionWithNegatedExpressionString must not be null");
        }
        PsiManager mgr = expression.getManager();
        Project project = mgr.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression expressionToReplace = expression;
        if (BoolUtils.isNegated(expression)) {
            expressionToReplace = BoolUtils.findNegation(expression);
            expString = newExpression;
        } else {
            expString = "!(" + newExpression + ')';
        }
        PsiExpression newCall = factory.createExpressionFromText(expString, (PsiElement)expression);
        assert (expressionToReplace != null);
        PsiElement insertedElement = expressionToReplace.replace((PsiElement)newCall);
        CodeStyleManager codeStyleManager = mgr.getCodeStyleManager();
        codeStyleManager.reformat(insertedElement);
    }

    protected static void replaceStatement(@NonNls @NotNull String newStatementText, @NonNls @NotNull PsiStatement statement) throws IncorrectOperationException {
        if (newStatementText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/base/Intention.replaceStatement must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/base/Intention.replaceStatement must not be null");
        }
        PsiManager mgr = statement.getManager();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)mgr.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)statement);
        PsiElement insertedElement = statement.replace((PsiElement)newStatement);
        CodeStyleManager codeStyleManager = mgr.getCodeStyleManager();
        codeStyleManager.reformat(insertedElement);
    }

    protected static void replaceStatementAndShorten(@NonNls @NotNull String newStatementText, @NonNls @NotNull PsiStatement statement) throws IncorrectOperationException {
        if (newStatementText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/base/Intention.replaceStatementAndShorten must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/base/Intention.replaceStatementAndShorten must not be null");
        }
        PsiManager mgr = statement.getManager();
        Project project = mgr.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)statement);
        PsiElement insertedElement = statement.replace((PsiElement)newStatement);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        PsiElement shortenedElement = codeStyleManager.shortenClassReferences(insertedElement);
        mgr.getCodeStyleManager().reformat(shortenedElement);
    }

    @Nullable
    PsiElement findMatchingElement(PsiFile file, Editor editor) {
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        PsiElement element = file.findElementAt(position);
        return this.findMatchingElement(element);
    }

    @Nullable
    PsiElement findMatchingElement(@Nullable PsiElement element) {
        while (element != null) {
            if (this.predicate.satisfiedBy(element)) {
                return element;
            }
            if (!((element = element.getParent()) instanceof PsiFile)) continue;
            break;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/base/Intention.isAvailable must not be null");
        }
        while (element != null) {
            if (this.predicate.satisfiedBy(element)) {
                return true;
            }
            if (!((element = element.getParent()) instanceof PsiFile)) continue;
            break;
        }
        return false;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static boolean isFileReadOnly(Project project, PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        ReadonlyStatusHandler readonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)project);
        ReadonlyStatusHandler.OperationStatus operationStatus = readonlyStatusHandler.ensureFilesWritable(new VirtualFile[]{virtualFile});
        return operationStatus.hasReadonlyFiles();
    }

    private String getPrefix() {
        Class<?> aClass = ((Object)((Object)this)).getClass();
        String name = aClass.getSimpleName();
        StringBuilder buffer = new StringBuilder(name.length() + 10);
        buffer.append(Character.toLowerCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buffer.append('.');
                buffer.append(Character.toLowerCase(c));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @NotNull
    public String getText() {
        String string = IntentionPowerPackBundle.message(this.getPrefix() + ".name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/base/Intention.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = IntentionPowerPackBundle.defaultableMessage(this.getPrefix() + ".family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/base/Intention.getFamilyName must not return null");
        }
        return string;
    }
}

