/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsstatuses;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.CvsInfo;
import com.intellij.cvsSupport2.changeBrowser.CvsBinaryContentRevision;
import com.intellij.cvsSupport2.changeBrowser.CvsContentRevision;
import com.intellij.cvsSupport2.checkinProject.DirectoryContent;
import com.intellij.cvsSupport2.checkinProject.VirtualFileEntry;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetFileContentOperation;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDateImpl;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.SimpleRevision;
import com.intellij.cvsSupport2.cvsstatuses.CvsStatusProvider;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entry;

public class CvsChangeProvider
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsstatuses.CvsChangeProvider");
    private final CvsVcs2 myVcs;
    private final CvsEntriesManager myEntriesManager;
    private final ProjectFileIndex myFileIndex;
    private final ChangeListManager myChangeListManager;

    public CvsChangeProvider(CvsVcs2 vcs, CvsEntriesManager entriesManager) {
        this.myVcs = vcs;
        this.myEntriesManager = entriesManager;
        this.myFileIndex = ProjectRootManager.getInstance((Project)vcs.getProject()).getFileIndex();
        this.myChangeListManager = ChangeListManager.getInstance((Project)vcs.getProject());
    }

    public void getChanges(VcsDirtyScope dirtyScope, ChangelistBuilder builder, final ProgressIndicator progress, ChangeListManagerGate addGate) {
        VirtualFile dir;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing changes for scope " + dirtyScope);
        }
        Runnable checkCanceled = new Runnable(){

            @Override
            public void run() {
                if (progress != null) {
                    progress.checkCanceled();
                }
            }
        };
        this.showBranchImOn(builder, dirtyScope);
        for (FilePath path : dirtyScope.getRecursivelyDirtyDirectories()) {
            dir = path.getVirtualFile();
            checkCanceled.run();
            if (dir != null) {
                this.processEntriesIn(dir, dirtyScope, builder, true, checkCanceled);
                continue;
            }
            this.processFile(path, builder, checkCanceled);
        }
        for (FilePath path : dirtyScope.getDirtyFiles()) {
            checkCanceled.run();
            if (path.isDirectory()) {
                dir = path.getVirtualFile();
                if (dir != null) {
                    this.processEntriesIn(dir, dirtyScope, builder, false, checkCanceled);
                    continue;
                }
                this.processFile(path, builder, checkCanceled);
                continue;
            }
            this.processFile(path, builder, checkCanceled);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done processing changes");
        }
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(List<VirtualFile> files) {
    }

    private void processEntriesIn(@NotNull VirtualFile dir, VcsDirtyScope scope, ChangelistBuilder builder, boolean recursively, Runnable checkCanceled) {
        VirtualFile[] children;
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/cvsSupport2/cvsstatuses/CvsChangeProvider.processEntriesIn must not be null");
        }
        FilePath path = VcsContextFactory.SERVICE.getInstance().createFilePathOn(dir);
        if (!scope.belongsTo(path)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping out of scope path " + path);
            }
            return;
        }
        DirectoryContent dirContent = CvsChangeProvider.getDirectoryContent(dir, checkCanceled);
        for (VirtualFile file : dirContent.getUnknownFiles()) {
            builder.processUnversionedFile(file);
        }
        for (VirtualFile file : dirContent.getIgnoredFiles()) {
            builder.processIgnoredFile(file);
        }
        for (Entry entry : dirContent.getDeletedDirectories()) {
            builder.processLocallyDeletedFile(VcsUtil.getFilePath((File)CvsVfsUtil.getFileFor(dir, entry.getFileName()), (boolean)true));
        }
        for (Entry entry : dirContent.getDeletedFiles()) {
            builder.processLocallyDeletedFile(VcsUtil.getFilePath((File)CvsVfsUtil.getFileFor(dir, entry.getFileName()), (boolean)false));
        }
        this.checkSwitchedDir(dir, builder, scope);
        if (CvsUtil.fileIsUnderCvs(dir) && dir.getChildren().length == 1 && dirContent.getDeletedFiles().isEmpty() && CvsChangeProvider.hasRemovedFiles(dirContent.getFiles())) {
            builder.processChange(new Change(CurrentContentRevision.create((FilePath)path), CurrentContentRevision.create((FilePath)path), FileStatus.DELETED), CvsVcs2.getKey());
        }
        for (VirtualFileEntry fileEntry : dirContent.getFiles()) {
            this.processFile(dir, fileEntry.getVirtualFile(), fileEntry.getEntry(), builder, checkCanceled);
        }
        if (recursively && (children = CvsVfsUtil.getChildrenOf(dir)) != null) {
            for (VirtualFile file : children) {
                if (!file.isDirectory()) continue;
                boolean isIgnored = this.myFileIndex.isIgnored(file);
                if (!isIgnored) {
                    this.processEntriesIn(file, scope, builder, true, checkCanceled);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Skipping ignored path " + file.getPath());
            }
        }
    }

    private static boolean hasRemovedFiles(Collection<VirtualFileEntry> files) {
        for (VirtualFileEntry e : files) {
            if (!e.getEntry().isRemoved()) continue;
            return true;
        }
        return false;
    }

    private void processFile(FilePath filePath, ChangelistBuilder builder, Runnable checkCanceled) {
        checkCanceled.run();
        VirtualFile dir = filePath.getVirtualFileParent();
        if (dir == null) {
            return;
        }
        Entry entry = this.myEntriesManager.getEntryFor(dir, filePath.getName());
        FileStatus status = CvsStatusProvider.getStatus(filePath.getVirtualFile(), entry);
        VcsRevisionNumber number = entry != null ? this.createRevisionNumber(entry.getRevision(), status) : VcsRevisionNumber.NULL;
        this.processStatus(filePath, dir.findChild(filePath.getName()), status, number, entry != null && entry.isBinary(), builder);
        this.checkSwitchedFile(filePath, builder, dir, entry);
    }

    private void processFile(VirtualFile dir, @Nullable VirtualFile file, Entry entry, ChangelistBuilder builder, Runnable checkCanceled) {
        checkCanceled.run();
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(dir, entry.getFileName());
        FileStatus status = CvsStatusProvider.getStatus(file, entry);
        CvsRevisionNumber number = this.createRevisionNumber(entry.getRevision(), status);
        this.processStatus(filePath, file, status, (VcsRevisionNumber)number, entry.isBinary(), builder);
        this.checkSwitchedFile(filePath, builder, dir, entry);
    }

    private CvsRevisionNumber createRevisionNumber(String revision, FileStatus status) {
        int idx;
        String correctedRevision = FileStatus.DELETED.equals(status) ? ((idx = revision.indexOf(45)) != -1 ? revision.substring(idx + 1) : revision) : revision;
        return new CvsRevisionNumber(correctedRevision);
    }

    private void showBranchImOn(ChangelistBuilder builder, VcsDirtyScope scope) {
        List dirs = ObjectsConvertor.fp2vf((Collection)scope.getRecursivelyDirtyDirectories());
        ArrayList roots = new ArrayList(scope.getAffectedContentRoots());
        Iterator iterator = roots.iterator();
        while (iterator.hasNext()) {
            VirtualFile root = (VirtualFile)iterator.next();
            if (dirs.contains(root)) continue;
            iterator.remove();
        }
        if (roots.isEmpty()) {
            return;
        }
        for (VirtualFile root : roots) {
            this.checkTopLevelForBeingSwitched(root, builder);
        }
    }

    private void checkTopLevelForBeingSwitched(VirtualFile dir, ChangelistBuilder builder) {
        CvsInfo info = this.myEntriesManager.getCvsInfoFor(dir);
        if (info.getRepository() == null) {
            return;
        }
        String dirTag = info.getStickyTag();
        if (dirTag != null) {
            String caption = CvsChangeProvider.getSwitchedTagCaption(dirTag, null, false);
            if (caption != null) {
                builder.processRootSwitch(dir, caption);
            }
        } else {
            builder.processRootSwitch(dir, "HEAD");
        }
    }

    @Nullable
    private static String getSwitchedTagCaption(String tag, String parentTag, boolean checkParentTag) {
        if (tag == null) {
            return "HEAD";
        }
        String tagOnly = tag.substring(1);
        if (CvsUtil.isNonDateTag(tag)) {
            String parentTagOnly;
            if (checkParentTag && parentTag != null && CvsUtil.isNonDateTag(parentTag) && tagOnly.equals(parentTagOnly = parentTag.substring(1))) {
                return null;
            }
            return CvsBundle.message((String)"switched.tag.format", (Object[])new Object[]{tagOnly});
        }
        if (tag.startsWith("D")) {
            try {
                Date date = Entry.STICKY_DATE_FORMAT.parse(tagOnly);
                return CvsBundle.message((String)"switched.date.format", (Object[])new Object[]{date});
            }
            catch (ParseException e) {
                return CvsBundle.message((String)"switched.date.format", (Object[])new Object[]{tagOnly});
            }
        }
        return null;
    }

    private void checkSwitchedDir(VirtualFile dir, ChangelistBuilder builder, VcsDirtyScope scope) {
        String parentBranch;
        CvsInfo parentInfo;
        String parentDirTag;
        VirtualFile parentDir = dir.getParent();
        if (parentDir == null || !this.myFileIndex.isInContent(parentDir)) {
            return;
        }
        CvsInfo info = this.myEntriesManager.getCvsInfoFor(dir);
        if (info.getRepository() == null) {
            builder.processUnversionedFile(dir);
            return;
        }
        String dirTag = info.getStickyTag();
        if (!Comparing.equal((String)dirTag, (String)(parentDirTag = (parentInfo = this.myEntriesManager.getCvsInfoFor(parentDir)).getStickyTag()))) {
            String caption = CvsChangeProvider.getSwitchedTagCaption(dirTag, parentDirTag, true);
            if (caption != null) {
                builder.processSwitchedFile(dir, caption, true);
            }
        } else if (!scope.belongsTo(VcsContextFactory.SERVICE.getInstance().createFilePathOn(parentDir)) && (parentBranch = this.myChangeListManager.getSwitchedBranch(parentDir)) != null) {
            builder.processSwitchedFile(dir, parentBranch, true);
        }
    }

    private void checkSwitchedFile(FilePath filePath, ChangelistBuilder builder, VirtualFile dir, Entry entry) {
        VirtualFile file;
        if (!this.myFileIndex.isInContent(dir)) {
            return;
        }
        String dirTag = this.myEntriesManager.getCvsInfoFor(dir).getStickyTag();
        String dirStickyInfo = CvsChangeProvider.getStickyInfo(dirTag);
        if (entry != null && !Comparing.equal((String)entry.getStickyInformation(), (String)dirStickyInfo) && (file = filePath.getVirtualFile()) != null) {
            if (entry.getStickyTag() != null) {
                builder.processSwitchedFile(file, CvsBundle.message((String)"switched.tag.format", (Object[])new Object[]{entry.getStickyTag()}), false);
            } else if (entry.getStickyDate() != null) {
                builder.processSwitchedFile(file, CvsBundle.message((String)"switched.date.format", (Object[])new Object[]{entry.getStickyDate()}), false);
            } else if (entry.getStickyRevision() != null) {
                builder.processSwitchedFile(file, CvsBundle.message((String)"switched.revision.format", (Object[])new Object[]{entry.getStickyRevision()}), false);
            } else {
                builder.processSwitchedFile(file, "HEAD", false);
            }
        }
    }

    @Nullable
    private static String getStickyInfo(String dirTag) {
        return dirTag != null && dirTag.length() > 1 ? dirTag.substring(1) : null;
    }

    private void processStatus(FilePath filePath, VirtualFile file, FileStatus status, VcsRevisionNumber number, boolean isBinary, ChangelistBuilder builder) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processStatus: filePath=" + filePath + " status=" + status);
        }
        if (status == FileStatus.NOT_CHANGED) {
            if (file != null && FileDocumentManager.getInstance().isFileModifiedAndDocumentUnsaved(file)) {
                builder.processChange(new Change((ContentRevision)this.createCvsRevision(filePath, number, isBinary), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED), CvsVcs2.getKey());
            }
            return;
        }
        if (status == FileStatus.MODIFIED || status == FileStatus.MERGE || status == FileStatus.MERGED_WITH_CONFLICTS) {
            builder.processChange(new Change((ContentRevision)this.createCvsRevision(filePath, number, isBinary), CurrentContentRevision.create((FilePath)filePath), status), CvsVcs2.getKey());
        } else if (status == FileStatus.ADDED) {
            builder.processChange(new Change(null, CurrentContentRevision.create((FilePath)filePath), status), CvsVcs2.getKey());
        } else if (status == FileStatus.DELETED) {
            builder.processChange(new Change((ContentRevision)this.createCvsRevision(filePath, number, isBinary), null, status), CvsVcs2.getKey());
        } else if (status == FileStatus.DELETED_FROM_FS) {
            builder.processLocallyDeletedFile(filePath);
        } else if (status == FileStatus.UNKNOWN) {
            builder.processUnversionedFile(filePath.getVirtualFile());
        } else if (status == FileStatus.IGNORED) {
            builder.processIgnoredFile(filePath.getVirtualFile());
        }
    }

    private ContentRevision createRemote(CvsRevisionNumber revisionNumber, VirtualFile selectedFile) {
        CvsConnectionSettings settings = CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(selectedFile.getParent());
        File file = new File(CvsUtil.getModuleName(selectedFile));
        Object versionInfo = revisionNumber.getDateOrRevision() != null ? RevisionOrDateImpl.createOn(revisionNumber.getDateOrRevision()) : new SimpleRevision(revisionNumber.asString());
        Project project = this.myVcs.getProject();
        File ioFile = new File(selectedFile.getPath());
        if (selectedFile.getFileType().isBinary()) {
            return new CvsBinaryContentRevision(file, ioFile, (RevisionOrDate)versionInfo, settings, project);
        }
        return new CvsContentRevision(file, ioFile, (RevisionOrDate)versionInfo, settings, project);
    }

    @Nullable
    public byte[] getLastUpToDateContentFor(@NotNull VirtualFile f) {
        if (f == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/cvsSupport2/cvsstatuses/CvsChangeProvider.getLastUpToDateContentFor must not be null");
        }
        Entry entry = this.myEntriesManager.getEntryFor(f.getParent(), f.getName());
        if (entry != null && entry.isResultOfMerge()) {
            byte[] content = CvsUtil.getStoredContentForFile(f, entry.getRevision());
            if (content != null) {
                return content;
            }
            return CvsUtil.getCachedStoredContent(f, entry.getRevision());
        }
        final long upToDateTimestamp = this.getUpToDateTimeForFile(f);
        FileRevisionTimestampComparator c = new FileRevisionTimestampComparator(){

            public boolean isSuitable(long revisionTimestamp) {
                return CvsStatusProvider.timeStampsAreEqual(upToDateTimestamp, revisionTimestamp);
            }
        };
        byte[] localHistoryContent = LocalHistory.getByteContent((Project)this.myVcs.getProject(), (VirtualFile)f, (FileRevisionTimestampComparator)c);
        if (localHistoryContent == null && entry != null && CvsUtil.haveCachedContent(f, entry.getRevision())) {
            return CvsUtil.getCachedStoredContent(f, entry.getRevision());
        }
        return localHistoryContent;
    }

    public long getUpToDateTimeForFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/cvsSupport2/cvsstatuses/CvsChangeProvider.getUpToDateTimeForFile must not be null");
        }
        Entry entry = this.myEntriesManager.getEntryFor(vFile.getParent(), vFile.getName());
        if (entry == null) {
            return -1L;
        }
        Date lastModified = entry.getLastModified();
        if (lastModified == null) {
            return -1L;
        }
        return lastModified.getTime();
    }

    private CvsUpToDateRevision createCvsRevision(FilePath path, VcsRevisionNumber revisionNumber, boolean isBinary) {
        if (isBinary) {
            return new CvsUpToDateBinaryRevision(path, revisionNumber);
        }
        return new CvsUpToDateRevision(path, revisionNumber);
    }

    private static boolean isInContent(VirtualFile file) {
        return file == null || !FileTypeManager.getInstance().isFileIgnored(file.getName());
    }

    private static DirectoryContent getDirectoryContent(VirtualFile directory, Runnable checkCanceled) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving directory content for " + directory);
        }
        CvsInfo cvsInfo = CvsEntriesManager.getInstance().getCvsInfoFor(directory);
        DirectoryContent result = new DirectoryContent(cvsInfo);
        VirtualFile[] children = CvsVfsUtil.getChildrenOf(directory);
        if (children == null) {
            children = VirtualFile.EMPTY_ARRAY;
        }
        Collection<Entry> entries = cvsInfo.getEntries();
        HashMap nameToFileMap = new HashMap();
        for (VirtualFile child : children) {
            nameToFileMap.put((Object)child.getName(), (Object)child);
        }
        for (Entry entry : entries) {
            VirtualFile virtualFile;
            checkCanceled.run();
            String fileName = entry.getFileName();
            if (entry.isDirectory()) {
                if (nameToFileMap.containsKey((Object)fileName)) {
                    virtualFile = (VirtualFile)nameToFileMap.get((Object)fileName);
                    if (CvsChangeProvider.isInContent(virtualFile)) {
                        result.addDirectory(new VirtualFileEntry(virtualFile, entry));
                    }
                } else if (!entry.isRemoved() && !FileTypeManager.getInstance().isFileIgnored(fileName)) {
                    result.addDeletedDirectory(entry);
                }
            } else if (nameToFileMap.containsKey((Object)fileName) || entry.isRemoved()) {
                virtualFile = (VirtualFile)nameToFileMap.get((Object)fileName);
                if (CvsChangeProvider.isInContent(virtualFile)) {
                    result.addFile(new VirtualFileEntry(virtualFile, entry));
                }
            } else if (!entry.isAddedFile()) {
                result.addDeletedFile(entry);
            }
            nameToFileMap.remove((Object)fileName);
        }
        for (String name : nameToFileMap.keySet()) {
            checkCanceled.run();
            VirtualFile unknown = (VirtualFile)nameToFileMap.get((Object)name);
            if (unknown.isDirectory()) {
                if (!CvsChangeProvider.isInContent(unknown)) continue;
                result.addUnknownDirectory(unknown);
                continue;
            }
            if (!CvsChangeProvider.isInContent(unknown)) continue;
            boolean isIgnored = result.getCvsInfo().getIgnoreFilter().shouldBeIgnored(unknown.getName());
            if (isIgnored) {
                result.addIgnoredFile(unknown);
                continue;
            }
            result.addUnknownFile(unknown);
        }
        return result;
    }

    private class CvsUpToDateBinaryRevision
    extends CvsUpToDateRevision
    implements BinaryContentRevision {
        private byte[] myBinaryContent;

        public CvsUpToDateBinaryRevision(FilePath path, VcsRevisionNumber revisionNumber) {
            super(path, revisionNumber);
        }

        @Nullable
        public byte[] getBinaryContent() throws VcsException {
            if (this.myBinaryContent == null) {
                try {
                    this.myBinaryContent = this.getUpToDateBinaryContent();
                }
                catch (CannotFindCvsRootException e) {
                    throw new VcsException((Throwable)e);
                }
            }
            return this.myBinaryContent;
        }

        @Override
        @NonNls
        public String toString() {
            return "CvsUpToDateBinaryRevision:" + this.myPath;
        }
    }

    private class CvsUpToDateRevision
    implements ContentRevision {
        protected final FilePath myPath;
        private final VcsRevisionNumber myRevisionNumber;
        private String myContent;

        protected CvsUpToDateRevision(FilePath path, VcsRevisionNumber revisionNumber) {
            this.myRevisionNumber = revisionNumber;
            this.myPath = path;
        }

        @Nullable
        public String getContent() throws VcsException {
            if (this.myContent == null) {
                try {
                    byte[] fileBytes = this.getUpToDateBinaryContent();
                    this.myContent = fileBytes == null ? null : new String(fileBytes, this.myPath.getCharset().name());
                }
                catch (CannotFindCvsRootException e) {
                    this.myContent = null;
                }
                catch (UnsupportedEncodingException e) {
                    this.myContent = null;
                }
            }
            return this.myContent;
        }

        @Nullable
        protected byte[] getUpToDateBinaryContent() throws CannotFindCvsRootException {
            VirtualFile virtualFile = this.myPath.getVirtualFile();
            byte[] result = null;
            if (virtualFile != null) {
                result = CvsChangeProvider.this.getLastUpToDateContentFor(virtualFile);
            }
            if (result == null) {
                GetFileContentOperation operation;
                String createVersionFile = null;
                if (virtualFile != null) {
                    Entry entry = CvsChangeProvider.this.myEntriesManager.getEntryFor(virtualFile.getParent(), virtualFile.getName());
                    if (entry != null && entry.isResultOfMerge()) {
                        createVersionFile = entry.getRevision();
                    }
                    operation = GetFileContentOperation.createForFile(virtualFile, SimpleRevision.createForTheSameVersionOf(virtualFile));
                } else {
                    operation = GetFileContentOperation.createForFile(this.myPath);
                }
                if (operation.getRoot().isOffline()) {
                    return null;
                }
                CvsVcs2.executeQuietOperation(CvsBundle.message((String)"operation.name.get.file.content", (Object[])new Object[0]), operation, CvsChangeProvider.this.myVcs.getProject());
                result = operation.tryGetFileBytes();
                if (result != null && createVersionFile != null) {
                    CvsUtil.storeContentForRevision(virtualFile, createVersionFile, result);
                }
            }
            return result;
        }

        @NotNull
        public FilePath getFile() {
            FilePath filePath = this.myPath;
            if (filePath == null) {
                throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/cvsstatuses/CvsChangeProvider$CvsUpToDateRevision.getFile must not return null");
            }
            return filePath;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myRevisionNumber;
            if (vcsRevisionNumber == null) {
                throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/cvsstatuses/CvsChangeProvider$CvsUpToDateRevision.getRevisionNumber must not return null");
            }
            return vcsRevisionNumber;
        }

        @NonNls
        public String toString() {
            return "CvsUpToDateRevision:" + this.myPath;
        }
    }
}

