/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch;

import com.intellij.openapi.util.text.StringUtil;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.DummyRequestsProgressHandler;
import org.netbeans.lib.cvsclient.progress.sending.IRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;
import org.netbeans.lib.cvsclient.request.ResponseExpectingRequest;

public class RtagCommand
extends AbstractCommand {
    private final String myTagName;
    private boolean myOverrideExistings = false;

    public RtagCommand(String tagName) {
        this.myTagName = tagName;
    }

    public final boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        Requests requests = new Requests((ResponseExpectingRequest)CommandRequest.RTAG, clientEnvironment);
        requests.addArgumentRequest(this.myOverrideExistings, "-F");
        requests.addArgumentRequest(true, this.myTagName);
        for (FileObject fileObject : this.getFileObjects().getFileObjects()) {
            String path = fileObject.getPath();
            if (StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
                path = path.substring(1);
            }
            requests.addArgumentRequest(path);
        }
        return requestProcessor.processRequests(requests, (IRequestsProgressHandler)new DummyRequestsProgressHandler());
    }

    public final String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("rtag ");
        cvsCommandLine.append(this.getCVSArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    private String getCVSArguments() {
        StringBuffer cvsArguments = new StringBuffer();
        cvsArguments.append("-F " + this.myTagName);
        return cvsArguments.toString();
    }

    public void setOverrideExistings(boolean overrideExistings) {
        this.myOverrideExistings = overrideExistings;
    }
}

