/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsErrors;

import com.intellij.cvsSupport2.cvsoperations.cvsErrors.ErrorProcessor;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsMessagesAdapter;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;

public class ErrorMessagesProcessor
extends CvsMessagesAdapter
implements ErrorProcessor {
    private final List<VcsException> myErrors;
    private final List<VcsException> myWarnings;

    public ErrorMessagesProcessor(List<VcsException> errors) {
        this.myErrors = errors;
        this.myWarnings = new ArrayList<VcsException>();
    }

    public ErrorMessagesProcessor() {
        this(new ArrayList<VcsException>());
    }

    @Override
    public void addError(String message, String relativeFilePath, ICvsFileSystem cvsFileSystem, String cvsRoot) {
        this.addErrorOnCurrentMessage(relativeFilePath, message, cvsFileSystem, this.myErrors, cvsRoot);
    }

    @Override
    public void addWarning(String message, String relativeFilePath, ICvsFileSystem cvsFileSystem, String cvsRoot) {
        this.addErrorOnCurrentMessage(relativeFilePath, message, cvsFileSystem, this.myWarnings, cvsRoot);
    }

    private void addErrorOnCurrentMessage(String relativeFileName, String message, ICvsFileSystem cvsFileSystem, List collection, String cvsRoot) {
        VirtualFile vFile = this.getVirtualFile(cvsFileSystem, relativeFileName);
        CvsException vcsException = new CvsException(message, cvsRoot);
        if (vFile != null) {
            vcsException.setVirtualFile(vFile);
        }
        collection.add(vcsException);
    }

    private VirtualFile getVirtualFile(ICvsFileSystem cvsFileSystem, String relativeFileName) {
        if (cvsFileSystem == null) {
            return null;
        }
        if (relativeFileName == null) {
            return null;
        }
        return CvsVfsUtil.findFileByIoFile(cvsFileSystem.getLocalFileSystem().getFile(relativeFileName));
    }

    @Override
    public List<VcsException> getErrors() {
        return this.myErrors;
    }

    public List<VcsException> getWarnings() {
        return this.myWarnings;
    }

    public void clear() {
        this.myErrors.clear();
        this.myWarnings.clear();
    }

    @Override
    public void addError(VcsException ex) {
        this.myErrors.add(ex);
    }

    @Override
    public void addWarning(VcsException ex) {
        this.myWarnings.add(ex);
    }
}

