/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsEdit.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.EditorInfo;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;

public class EditorsPanel
extends JPanel
implements TypeSafeDataProvider {
    public static final DateFormat DATE_FORMAT = SimpleDateFormat.getDateTimeInstance(3, 3);
    private final ListTableModel<EditorInfo> myModel = new ListTableModel(COLUMNS);
    private final TableView<EditorInfo> myTable = new TableView(this.myModel);
    private static final ColumnInfo<EditorInfo, String> USER = new ColumnInfo<EditorInfo, String>(CvsBundle.message((String)"view.editors.user.column.name", (Object[])new Object[0])){

        public String valueOf(EditorInfo object) {
            return object.getUserName();
        }

        public Comparator<EditorInfo> getComparator() {
            return new Comparator<EditorInfo>(){

                @Override
                public int compare(EditorInfo o, EditorInfo o1) {
                    return o.getUserName().compareTo(o1.getUserName());
                }
            };
        }
    };
    private static final ColumnInfo<EditorInfo, String> HOST = new ColumnInfo<EditorInfo, String>(CvsBundle.message((String)"view.editors.host.column.name", (Object[])new Object[0])){

        public String valueOf(EditorInfo object) {
            return object.getHostHame();
        }

        public Comparator<EditorInfo> getComparator() {
            return new Comparator<EditorInfo>(){

                @Override
                public int compare(EditorInfo o, EditorInfo o1) {
                    return o.getHostHame().compareTo(o1.getHostHame());
                }
            };
        }
    };
    private static final ColumnInfo<EditorInfo, String> DATE = new ColumnInfo<EditorInfo, String>(CvsBundle.message((String)"view.editors.date.column.name", (Object[])new Object[0])){

        public String valueOf(EditorInfo object) {
            return DATE_FORMAT.format(object.getEditDate());
        }

        public Comparator<EditorInfo> getComparator() {
            return new Comparator<EditorInfo>(){

                @Override
                public int compare(EditorInfo o, EditorInfo o1) {
                    return o.getEditDate().compareTo(o1.getEditDate());
                }
            };
        }
    };
    private static final ColumnInfo<EditorInfo, String> DIR = new ColumnInfo<EditorInfo, String>(CvsBundle.message((String)"view.editors.directory.column.name", (Object[])new Object[0])){

        public String valueOf(EditorInfo object) {
            return object.getPath();
        }

        public Comparator<EditorInfo> getComparator() {
            return new Comparator<EditorInfo>(){

                @Override
                public int compare(EditorInfo o, EditorInfo o1) {
                    return o.getPath().compareTo(o1.getPath());
                }
            };
        }
    };
    private static final ColumnInfo<EditorInfo, String> FILE = new ColumnInfo<EditorInfo, String>(CvsBundle.message((String)"view.editors.file.column.name", (Object[])new Object[0])){

        public String valueOf(EditorInfo object) {
            return object.getFilePath();
        }

        public Comparator<EditorInfo> getComparator() {
            return new Comparator<EditorInfo>(){

                @Override
                public int compare(EditorInfo o, EditorInfo o1) {
                    return o.getFilePath().compareTo(o1.getFilePath());
                }
            };
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{FILE, USER, DATE, HOST, DIR};
    private final Project myProject;

    public EditorsPanel(Project project, List<EditorInfo> editors) {
        super(new BorderLayout());
        this.myProject = project;
        this.myModel.setItems(editors);
        this.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), "Center");
        EditSourceOnDoubleClickHandler.install(this.myTable);
        EditSourceOnEnterKeyHandler.install(this.myTable, null);
    }

    public void calcData(DataKey key, DataSink sink) {
        if (key.equals(PlatformDataKeys.PROJECT)) {
            sink.put(PlatformDataKeys.PROJECT, (Object)this.myProject);
        } else if (key.equals(PlatformDataKeys.NAVIGATABLE)) {
            EditorInfo editorInfo = (EditorInfo)this.myTable.getSelectedObject();
            if (editorInfo == null) {
                return;
            }
            String filePath = editorInfo.getFilePath();
            int pos = filePath.lastIndexOf(47);
            if (pos >= 0) {
                filePath = filePath.substring(pos + 1);
            }
            File file = new File(editorInfo.getPath(), filePath);
            VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vf != null) {
                sink.put(PlatformDataKeys.NAVIGATABLE, (Object)new OpenFileDescriptor(this.myProject, vf));
            }
        }
    }
}

