/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiMethod;
import com.intellij.spellchecker.NamedElementTokenizer;
import com.intellij.spellchecker.tokenizer.Token;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodNameTokenizerJava
extends NamedElementTokenizer<PsiMethod> {
    @Override
    @Nullable
    public Token[] tokenize(@NotNull PsiMethod element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/MethodNameTokenizerJava.tokenize must not be null");
        }
        PsiMethod[] methods = element.findDeepestSuperMethods();
        boolean isInSource = true;
        for (PsiMethod psiMethod : methods) {
            isInSource &= MethodNameTokenizerJava.isMethodDeclarationInSource(psiMethod);
        }
        return isInSource ? super.tokenize(element) : null;
    }

    private static boolean isMethodDeclarationInSource(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/MethodNameTokenizerJava.isMethodDeclarationInSource must not be null");
        }
        if (psiMethod.getContainingFile() == null) {
            return false;
        }
        VirtualFile virtualFile = psiMethod.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return ProjectRootManager.getInstance((Project)psiMethod.getProject()).getFileIndex().isInSource(virtualFile);
    }
}

