/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.fileTypes.impl;

import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashSet;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.intellij.images.ImagesBundle;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class ImageFileTypeManagerImpl
extends ImageFileTypeManager
implements ApplicationComponent {
    @NonNls
    private static final String NAME = "ImagesFileTypeManager";
    @NonNls
    private static final String IMAGE_FILE_TYPE_NAME = "Images";
    private static final String IMAGE_FILE_TYPE_DESCRIPTION = ImagesBundle.message("images.filetype.description", new Object[0]);
    private static final UserFileType imageFileType = new ImageFileType();

    @Override
    public boolean isImage(VirtualFile file) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType fileTypeByFile = fileTypeManager.getFileTypeByFile(file);
        return fileTypeByFile instanceof ImageFileType;
    }

    @Override
    public FileType getImageFileType() {
        return imageFileType;
    }

    @NotNull
    public String getComponentName() {
        if (NAME == null) {
            throw new IllegalStateException("@NotNull method org/intellij/images/fileTypes/impl/ImageFileTypeManagerImpl.getComponentName must not return null");
        }
        return NAME;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/fileTypes/impl/ImageFileTypeManagerImpl.createFileTypes must not be null");
        }
        String[] readerFormatNames = ImageIO.getReaderFormatNames();
        THashSet processed = new THashSet();
        for (String format : readerFormatNames) {
            String s = format.toLowerCase();
            if (processed.contains(s)) continue;
            processed.add(s);
        }
        consumer.consume((FileType)imageFileType, StringUtil.join((Collection)processed, (String)";"));
    }

    static {
        imageFileType.setIcon(IconLoader.getIcon((String)"/org/intellij/images/icons/ImagesFileType.png"));
        imageFileType.setName(IMAGE_FILE_TYPE_NAME);
        imageFileType.setDescription(IMAGE_FILE_TYPE_DESCRIPTION);
    }

    public static final class ImageFileType
    extends UserBinaryFileType {
    }
}

