/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.FieldCache;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.SchemaReferencesProvider;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComplexTypeDescriptor
extends TypeDescriptor {
    private final XmlNSDescriptorImpl myDocumentDescriptor;
    private final XmlTag myTag;
    private static final FieldCache<XmlElementDescriptor[], ComplexTypeDescriptor, Object, XmlElement> myElementDescriptorsCache = new FieldCache<XmlElementDescriptor[], ComplexTypeDescriptor, Object, XmlElement>(){

        protected XmlElementDescriptor[] compute(ComplexTypeDescriptor complexTypeDescriptor, XmlElement p) {
            return complexTypeDescriptor.doCollectElements(p);
        }

        protected XmlElementDescriptor[] getValue(ComplexTypeDescriptor complexTypeDescriptor, Object p) {
            return complexTypeDescriptor.myElementDescriptors;
        }

        protected void putValue(XmlElementDescriptor[] xmlElementDescriptors, ComplexTypeDescriptor complexTypeDescriptor, Object p) {
            ComplexTypeDescriptor.access$102(complexTypeDescriptor, xmlElementDescriptors);
        }
    };
    private static final FieldCache<XmlAttributeDescriptor[], ComplexTypeDescriptor, Object, XmlElement> myAttributeDescriptorsCache = new FieldCache<XmlAttributeDescriptor[], ComplexTypeDescriptor, Object, XmlElement>(){

        protected final XmlAttributeDescriptor[] compute(ComplexTypeDescriptor complexTypeDescriptor, XmlElement p) {
            return complexTypeDescriptor.doCollectAttributes(p);
        }

        protected final XmlAttributeDescriptor[] getValue(ComplexTypeDescriptor complexTypeDescriptor, Object o) {
            return complexTypeDescriptor.myAttributeDescriptors;
        }

        protected final void putValue(XmlAttributeDescriptor[] xmlAttributeDescriptors, ComplexTypeDescriptor complexTypeDescriptor, Object p) {
            ComplexTypeDescriptor.access$302(complexTypeDescriptor, xmlAttributeDescriptors);
        }
    };
    private volatile XmlElementDescriptor[] myElementDescriptors = null;
    private volatile XmlAttributeDescriptor[] myAttributeDescriptors = null;
    @NonNls
    private static final String PROHIBITED_ATTR_VALUE = "prohibited";
    @NonNls
    private static final String OTHER_NAMESPACE_ATTR_VALUE = "##other";
    @NonNls
    private static final String TRUE_ATTR_VALUE = "true";
    @NonNls
    private static final String REF_ATTR_NAME = "ref";
    @NonNls
    private static final String NAME_ATTR_NAME = "name";
    @NonNls
    private static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    private static final String ATTRIBUTE_TAG_NAME = "attribute";
    private boolean myHasAnyInContentModel;
    @NonNls
    private static final String RESTRICTION_TAG_NAME = "restriction";
    @NonNls
    private static final String EXTENSION_TAG_NAME = "extension";
    @NonNls
    private static final String BASE_ATTR_NAME = "base";

    public ComplexTypeDescriptor(XmlNSDescriptorImpl documentDescriptor, XmlTag tag) {
        this.myDocumentDescriptor = documentDescriptor;
        this.myTag = tag;
    }

    public XmlTag getDeclaration() {
        return this.myTag;
    }

    public XmlElementDescriptor[] getElements(XmlElement context) {
        return (XmlElementDescriptor[])myElementDescriptorsCache.get(null, (Object)this, (Object)context);
    }

    private XmlElementDescriptor[] doCollectElements(@Nullable XmlElement context) {
        LinkedHashMap<String, XmlElementDescriptor> map = new LinkedHashMap<String, XmlElementDescriptor>(5);
        this.collectElements(map, this.myTag, (Set<XmlTag>)new THashSet(), "", context);
        this.addSubstitutionGroups(map);
        ComplexTypeDescriptor.filterAbstractElements(map);
        return map.values().toArray(new XmlElementDescriptor[map.values().size()]);
    }

    private void addSubstitutionGroups(Map<String, XmlElementDescriptor> result) {
        block0: while (true) {
            for (XmlElementDescriptor xmlElementDescriptor : result.values()) {
                XmlElementDescriptorImpl descriptor = (XmlElementDescriptorImpl)xmlElementDescriptor;
                XmlElementDescriptor[] substitutes = this.myDocumentDescriptor.getSubstitutes(descriptor.getName(), descriptor.getNamespace());
                boolean toContinue = false;
                for (XmlElementDescriptor substitute : substitutes) {
                    if (result.get(substitute.getName()) != null) continue;
                    toContinue = true;
                    result.put(substitute.getName(), substitute);
                }
                if (!toContinue) continue;
                continue block0;
            }
            break;
        }
    }

    private static void filterAbstractElements(Map<String, XmlElementDescriptor> result) {
        Iterator<XmlElementDescriptor> iterator = result.values().iterator();
        while (iterator.hasNext()) {
            XmlElementDescriptorImpl descriptor = (XmlElementDescriptorImpl)iterator.next();
            if (!descriptor.isAbstract()) continue;
            iterator.remove();
        }
    }

    public XmlAttributeDescriptor[] getAttributes(@Nullable XmlElement context) {
        return (XmlAttributeDescriptor[])myAttributeDescriptorsCache.get(null, (Object)this, (Object)context);
    }

    private XmlAttributeDescriptor[] doCollectAttributes(@Nullable XmlElement context) {
        ArrayList<XmlAttributeDescriptor> result = new ArrayList<XmlAttributeDescriptor>();
        this.collectAttributes(result, this.myTag, (THashSet<XmlTag>)new THashSet(), "", context);
        return result.toArray(new XmlAttributeDescriptor[result.size()]);
    }

    public XmlNSDescriptorImpl getNsDescriptors() {
        return this.myDocumentDescriptor;
    }

    static boolean processSchemaTags(XmlTag tag, THashSet<XmlTag> visited, TagSchemaProcessor processor) {
        if (tag == null || visited != null && visited.contains((Object)tag)) {
            return true;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        visited.add((Object)tag);
        for (XmlTag t : tag.getSubTags()) {
            TagSchemaProcessor.ProcessingStrategy strategy = null;
            String name = t.getLocalName();
            if (ELEMENT_TAG_NAME.equals(name) && XmlNSDescriptorImpl.checkSchemaNamespace(t) ? (strategy = processor.visitElement(t)) == TagSchemaProcessor.ProcessingStrategy.Stop : (strategy = processor.visitTag(t)) == TagSchemaProcessor.ProcessingStrategy.Stop) {
                return false;
            }
            if (strategy != TagSchemaProcessor.ProcessingStrategy.ProcessChildren) continue;
            ComplexTypeDescriptor.processSchemaTags(t, (THashSet<XmlTag>)visited, processor);
        }
        return true;
    }

    private void collectElements(Map<String, XmlElementDescriptor> result, XmlTag tag, Set<XmlTag> visited, @NotNull String nsPrefixFromContext, @Nullable XmlElement context) {
        block12: {
            XmlTag[] tags;
            block14: {
                XmlTag[] tags2;
                XmlNSDescriptorImpl nsDescriptor;
                block13: {
                    XmlNSDescriptor descriptor;
                    block10: {
                        XmlElementDescriptor element;
                        XmlNSDescriptor namespaceDescriptor;
                        block11: {
                            if (nsPrefixFromContext == null) {
                                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xml/impl/schema/ComplexTypeDescriptor.collectElements must not be null");
                            }
                            if (visited.contains(tag)) {
                                return;
                            }
                            visited.add(tag);
                            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, ELEMENT_TAG_NAME)) break block10;
                            String nameAttr = tag.getAttributeValue(NAME_ATTR_NAME);
                            if (nameAttr == null) break block11;
                            ComplexTypeDescriptor.addElementDescriptor(result, this.myDocumentDescriptor.createElementDescriptor(tag));
                            break block12;
                        }
                        String ref = tag.getAttributeValue(REF_ATTR_NAME);
                        if (ref == null) break block12;
                        String local = XmlUtil.findLocalNameByQualifiedName(ref);
                        String namespace = this.getNamespace(tag, nsPrefixFromContext, ref);
                        XmlNSDescriptorImpl nsDescriptor2 = this.myDocumentDescriptor;
                        if (!namespace.equals(this.myDocumentDescriptor.getDefaultNamespace()) && (namespaceDescriptor = tag.getNSDescriptor(namespace, true)) instanceof XmlNSDescriptorImpl) {
                            nsDescriptor2 = (XmlNSDescriptorImpl)namespaceDescriptor;
                        }
                        if ((element = nsDescriptor2.getElementDescriptor(local, namespace, (Set<XmlNSDescriptorImpl>)new THashSet(), true)) == null) break block12;
                        ComplexTypeDescriptor.addElementDescriptor(result, element);
                        break block12;
                    }
                    if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, "group")) break block13;
                    String ref = tag.getAttributeValue(REF_ATTR_NAME);
                    if (ref == null) break block12;
                    XmlTag groupTag = this.myDocumentDescriptor.findGroup(ref);
                    if (groupTag == null && context instanceof XmlTag && (descriptor = ((XmlTag)context).getNSDescriptor(this.getNamespace(tag, nsPrefixFromContext, ref), true)) instanceof XmlNSDescriptorImpl && descriptor != this.myDocumentDescriptor) {
                        groupTag = ((XmlNSDescriptorImpl)descriptor).findGroup(ref);
                    }
                    if (groupTag == null) break block12;
                    XmlTag[] tags3 = groupTag.getSubTags();
                    String nsPrefixFromRef = XmlUtil.findPrefixByQualifiedName(ref);
                    if (nsPrefixFromRef.length() == 0) {
                        nsPrefixFromRef = nsPrefixFromContext;
                    }
                    for (XmlTag subTag : tags3) {
                        this.collectElements(result, subTag, visited, nsPrefixFromRef, context);
                    }
                    break block12;
                }
                if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, RESTRICTION_TAG_NAME) && !XmlNSDescriptorImpl.equalsToSchemaName(tag, EXTENSION_TAG_NAME)) break block14;
                String base = tag.getAttributeValue(BASE_ATTR_NAME);
                if (base == null) break block12;
                TypeDescriptor descriptor = this.myDocumentDescriptor.findTypeDescriptor(base);
                if (descriptor == this && (nsDescriptor = SchemaReferencesProvider.findRedefinedDescriptor(tag, base)) != null) {
                    descriptor = nsDescriptor.findTypeDescriptor(base);
                }
                if (descriptor instanceof ComplexTypeDescriptor) {
                    ComplexTypeDescriptor complexTypeDescriptor = (ComplexTypeDescriptor)descriptor;
                    complexTypeDescriptor.collectElements(result, complexTypeDescriptor.myTag, visited, base, context);
                }
                for (XmlTag subTag : tags2 = tag.getSubTags()) {
                    this.collectElements(result, subTag, visited, nsPrefixFromContext, context);
                }
                break block12;
            }
            for (XmlTag subTag : tags = tag.getSubTags()) {
                this.collectElements(result, subTag, visited, nsPrefixFromContext, context);
            }
        }
    }

    private String getNamespace(XmlTag tag, String nsPrefixFromContext, String ref) {
        String namespaceFromContext;
        String namespace;
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(ref);
        String string = namespace = "".equals(namespacePrefix) ? this.myDocumentDescriptor.getDefaultNamespace() : tag.getNamespaceByPrefix(namespacePrefix);
        if (namespacePrefix.length() == 0 && nsPrefixFromContext.length() != 0 && (namespaceFromContext = ((XmlDocument)this.myDocumentDescriptor.getDeclaration()).getRootTag().getNamespaceByPrefix(nsPrefixFromContext)).length() > 0) {
            namespace = namespaceFromContext;
        }
        return namespace;
    }

    private static void addElementDescriptor(Map<String, XmlElementDescriptor> result, XmlElementDescriptor element) {
        result.remove(element.getName());
        result.put(element.getName(), element);
    }

    private void collectAttributes(List<XmlAttributeDescriptor> result, XmlTag tag, THashSet<XmlTag> visited, @NotNull String nsPrefixFromContext, @Nullable XmlElement context) {
        block26: {
            block28: {
                block24: {
                    String namespace;
                    String ref;
                    String use;
                    block27: {
                        block25: {
                            if (nsPrefixFromContext == null) {
                                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xml/impl/schema/ComplexTypeDescriptor.collectAttributes must not be null");
                            }
                            if (visited.contains((Object)tag)) {
                                return;
                            }
                            visited.add((Object)tag);
                            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, ELEMENT_TAG_NAME)) {
                                return;
                            }
                            if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, ATTRIBUTE_TAG_NAME)) break block24;
                            use = tag.getAttributeValue("use");
                            String name = tag.getAttributeValue(NAME_ATTR_NAME);
                            if (name == null) break block25;
                            if (PROHIBITED_ATTR_VALUE.equals(use)) {
                                ComplexTypeDescriptor.removeAttributeDescriptor(result, name);
                            } else {
                                ComplexTypeDescriptor.addAttributeDescriptor(result, this.myDocumentDescriptor.createAttributeDescriptor(tag));
                            }
                            break block26;
                        }
                        ref = tag.getAttributeValue(REF_ATTR_NAME);
                        if (ref == null) break block26;
                        if (!PROHIBITED_ATTR_VALUE.equals(use)) break block27;
                        ComplexTypeDescriptor.removeAttributeDescriptor(result, ref);
                        break block26;
                    }
                    String local = XmlUtil.findLocalNameByQualifiedName(ref);
                    XmlAttributeDescriptor attributeDescriptor = this.myDocumentDescriptor.getAttribute(local, namespace = this.getNamespace(tag, nsPrefixFromContext, ref), tag);
                    if (!(attributeDescriptor instanceof XmlAttributeDescriptorImpl)) break block26;
                    if (use != null) {
                        ((XmlAttributeDescriptorImpl)attributeDescriptor).myUse = use;
                    }
                    ComplexTypeDescriptor.addAttributeDescriptor(result, attributeDescriptor);
                    break block26;
                }
                if (!XmlNSDescriptorImpl.equalsToSchemaName(tag, "attributeGroup")) break block28;
                String ref = tag.getAttributeValue(REF_ATTR_NAME);
                if (ref == null) break block26;
                XmlTag groupTag = null;
                XmlTag parentTag = tag.getParentTag();
                if (parentTag != null && context instanceof XmlTag) {
                    String parentGroupName;
                    if (XmlNSDescriptorImpl.equalsToSchemaName(parentTag, "attributeGroup") && (parentGroupName = parentTag.getAttributeValue(NAME_ATTR_NAME)) != null && ref.equals(parentGroupName)) {
                        PsiElement element = tag.getAttribute(REF_ATTR_NAME).getValueElement().getReferences()[0].resolve();
                        if (element instanceof XmlTag) {
                            groupTag = (XmlTag)element;
                        }
                    } else {
                        XmlTag group;
                        XmlNSDescriptor descriptor = ((XmlTag)context).getNSDescriptor(this.getNamespace(tag, nsPrefixFromContext, ref), true);
                        if (descriptor instanceof XmlNSDescriptorImpl && descriptor != this.myDocumentDescriptor && (group = ((XmlNSDescriptorImpl)descriptor).findAttributeGroup(ref)) != null) {
                            groupTag = group;
                        }
                    }
                }
                if (groupTag == null) {
                    groupTag = this.myDocumentDescriptor.findAttributeGroup(ref);
                }
                if (groupTag == null) break block26;
                XmlTag[] tags = groupTag.getSubTags();
                String nsPrefixFromRef = XmlUtil.findPrefixByQualifiedName(ref);
                if (nsPrefixFromRef.length() == 0) {
                    nsPrefixFromRef = nsPrefixFromContext;
                }
                for (XmlTag subTag : tags) {
                    this.collectAttributes(result, subTag, visited, nsPrefixFromRef, context);
                }
                break block26;
            }
            if (XmlNSDescriptorImpl.equalsToSchemaName(tag, RESTRICTION_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, EXTENSION_TAG_NAME)) {
                String base = tag.getAttributeValue(BASE_ATTR_NAME);
                if (base != null) {
                    XmlTag[] tags;
                    if (base.equals(this.myTag.getAttributeValue(NAME_ATTR_NAME))) {
                        PsiElement element = tag.getAttribute(BASE_ATTR_NAME).getValueElement().getReferences()[0].resolve();
                        if (element instanceof XmlTag) {
                            for (XmlTag subTag : ((XmlTag)element).getSubTags()) {
                                this.collectAttributes(result, subTag, visited, nsPrefixFromContext, context);
                            }
                        }
                    } else {
                        TypeDescriptor descriptor = this.myDocumentDescriptor.findTypeDescriptor(base);
                        if (descriptor instanceof ComplexTypeDescriptor) {
                            ComplexTypeDescriptor complexTypeDescriptor = (ComplexTypeDescriptor)descriptor;
                            complexTypeDescriptor.collectAttributes(result, complexTypeDescriptor.myTag, visited, nsPrefixFromContext, context);
                        }
                    }
                    for (XmlTag subTag : tags = tag.getSubTags()) {
                        this.collectAttributes(result, subTag, visited, nsPrefixFromContext, context);
                    }
                }
            } else {
                XmlTag[] tags;
                for (XmlTag subTag : tags = tag.getSubTags()) {
                    this.collectAttributes(result, subTag, visited, nsPrefixFromContext, context);
                }
            }
        }
    }

    private static void removeAttributeDescriptor(List<XmlAttributeDescriptor> result, String name) {
        Iterator<XmlAttributeDescriptor> iterator = result.iterator();
        while (iterator.hasNext()) {
            XmlAttributeDescriptor attributeDescriptor = iterator.next();
            if (!attributeDescriptor.getName().equals(name)) continue;
            iterator.remove();
        }
    }

    private static void addAttributeDescriptor(List<XmlAttributeDescriptor> result, XmlAttributeDescriptor descriptor) {
        ComplexTypeDescriptor.removeAttributeDescriptor(result, descriptor.getName());
        result.add(descriptor);
    }

    public boolean canContainTag(String localName, String namespace, XmlElement context) {
        return this._canContainTag(localName, namespace, this.myTag, context, new HashSet<XmlTag>(5), new CurrentContextInfo(this.myDocumentDescriptor, this.myDocumentDescriptor.getDefaultNamespace()));
    }

    static CurrentContextInfo getContextInfo(CurrentContextInfo info, String ref) {
        XmlTag rootTag = info.documentDescriptor.getTag();
        XmlNSDescriptorImpl nsDescriptor = XmlNSDescriptorImpl.getNSDescriptorToSearchIn(rootTag, ref, info.documentDescriptor);
        String ns = nsDescriptor == info.documentDescriptor ? rootTag.getNamespaceByPrefix(XmlUtil.findPrefixByQualifiedName(ref)) : nsDescriptor.getDefaultNamespace();
        if (Comparing.equal((String)info.expectedDefaultNs, (String)ns) && info.documentDescriptor == nsDescriptor) {
            return info;
        }
        return new CurrentContextInfo(nsDescriptor, ns);
    }

    private boolean _canContainTag(String localName, String namespace, XmlTag tag, XmlElement context, Set<XmlTag> visited, CurrentContextInfo info) {
        String ref;
        if (visited.contains(tag)) {
            return false;
        }
        visited.add(tag);
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "any")) {
            this.myHasAnyInContentModel = true;
            if (OTHER_NAMESPACE_ATTR_VALUE.equals(tag.getAttributeValue("namespace"))) {
                return namespace == null || !namespace.equals(info.expectedDefaultNs);
            }
            return true;
        }
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "group")) {
            XmlTag groupTag;
            ref = tag.getAttributeValue(REF_ATTR_NAME);
            if (ref != null && (groupTag = info.documentDescriptor.findGroup(ref)) != null && this._canContainTag(localName, namespace, groupTag, context, visited, ComplexTypeDescriptor.getContextInfo(info, ref))) {
                return true;
            }
        } else if (XmlNSDescriptorImpl.equalsToSchemaName(tag, RESTRICTION_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, EXTENSION_TAG_NAME)) {
            ComplexTypeDescriptor complexTypeDescriptor;
            TypeDescriptor descriptor;
            String base = tag.getAttributeValue(BASE_ATTR_NAME);
            if (base != null && (descriptor = info.documentDescriptor.findTypeDescriptor(base)) instanceof ComplexTypeDescriptor && (complexTypeDescriptor = (ComplexTypeDescriptor)descriptor)._canContainTag(localName, namespace, complexTypeDescriptor.myTag, context, visited, ComplexTypeDescriptor.getContextInfo(info, base))) {
                this.myHasAnyInContentModel |= complexTypeDescriptor.myHasAnyInContentModel;
                return true;
            }
        } else if (XmlNSDescriptorImpl.equalsToSchemaName(tag, ELEMENT_TAG_NAME)) {
            PsiElement psiElement;
            ref = tag.getAttributeValue(REF_ATTR_NAME);
            XmlTag descriptorTag = tag;
            if (ref != null && (psiElement = SchemaReferencesProvider.createTypeOrElementOrAttributeReference((PsiElement)tag.getAttribute(REF_ATTR_NAME, null).getValueElement()).resolve()) instanceof XmlTag) {
                descriptorTag = (XmlTag)psiElement;
            }
            if (TRUE_ATTR_VALUE.equals(descriptorTag.getAttributeValue("abstract"))) {
                String substitutionValue;
                XmlNSDescriptor _nsDescriptor = tag.getNSDescriptor(namespace, true);
                if (_nsDescriptor == null && context instanceof XmlTag) {
                    _nsDescriptor = ((XmlTag)context).getNSDescriptor(namespace, true);
                }
                XmlNSDescriptorImpl nsDescriptor = _nsDescriptor instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)_nsDescriptor : null;
                XmlElementDescriptor descriptor = nsDescriptor != null ? nsDescriptor.getElementDescriptor(localName, namespace) : null;
                String name = descriptorTag.getAttributeValue(NAME_ATTR_NAME);
                if (descriptor != null && name != null && (substitutionValue = ((XmlTag)descriptor.getDeclaration()).getAttributeValue("substitutionGroup")) != null && name.equals(XmlUtil.findLocalNameByQualifiedName(substitutionValue))) {
                    return true;
                }
            }
        }
        for (XmlTag subTag : tag.getSubTags()) {
            if (!this._canContainTag(localName, namespace, subTag, context, visited, info)) continue;
            return true;
        }
        return false;
    }

    public CanContainAttributeType canContainAttribute(String attributeName, String namespace) {
        return this._canContainAttribute(attributeName, namespace, this.myTag, (Set<String>)new THashSet());
    }

    private CanContainAttributeType _canContainAttribute(String name, String namespace, XmlTag tag, Set<String> visited) {
        XmlTag[] subTags;
        String base;
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "anyAttribute")) {
            String ns = tag.getAttributeValue("namespace");
            CanContainAttributeType canContainAttributeType = CanContainAttributeType.CanContainButDoNotSkip;
            if ("skip".equals(tag.getAttributeValue("processContents"))) {
                canContainAttributeType = CanContainAttributeType.CanContainButSkip;
            }
            if (OTHER_NAMESPACE_ATTR_VALUE.equals(ns)) {
                return !namespace.equals(this.myDocumentDescriptor.getDefaultNamespace()) ? canContainAttributeType : CanContainAttributeType.CanNotContain;
            }
            return canContainAttributeType;
        }
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "attributeGroup")) {
            String ref = tag.getAttributeValue(REF_ATTR_NAME);
            if (ref != null && !visited.contains(ref)) {
                CanContainAttributeType containAttributeType;
                visited.add(ref);
                XmlTag groupTag = this.myDocumentDescriptor.findAttributeGroup(ref);
                if (groupTag != null && (containAttributeType = this._canContainAttribute(name, namespace, groupTag, visited)) != CanContainAttributeType.CanNotContain) {
                    return containAttributeType;
                }
            }
        } else if ((XmlNSDescriptorImpl.equalsToSchemaName(tag, RESTRICTION_TAG_NAME) || XmlNSDescriptorImpl.equalsToSchemaName(tag, EXTENSION_TAG_NAME)) && (base = tag.getAttributeValue(BASE_ATTR_NAME)) != null && !visited.contains(base)) {
            ComplexTypeDescriptor complexTypeDescriptor;
            CanContainAttributeType containAttributeType;
            visited.add(base);
            TypeDescriptor descriptor = this.myDocumentDescriptor.findTypeDescriptor(base);
            if (descriptor instanceof ComplexTypeDescriptor && (containAttributeType = (complexTypeDescriptor = (ComplexTypeDescriptor)descriptor)._canContainAttribute(name, namespace, complexTypeDescriptor.getDeclaration(), visited)) != CanContainAttributeType.CanNotContain) {
                return containAttributeType;
            }
        }
        for (XmlTag subTag : subTags = tag.getSubTags()) {
            CanContainAttributeType containAttributeType = this._canContainAttribute(name, namespace, subTag, visited);
            if (containAttributeType == CanContainAttributeType.CanNotContain) continue;
            return containAttributeType;
        }
        return CanContainAttributeType.CanNotContain;
    }

    public boolean hasAnyInContentModel() {
        return this.myHasAnyInContentModel;
    }

    static /* synthetic */ XmlElementDescriptor[] access$102(ComplexTypeDescriptor x0, XmlElementDescriptor[] x1) {
        x0.myElementDescriptors = x1;
        return x1;
    }

    static /* synthetic */ XmlAttributeDescriptor[] access$302(ComplexTypeDescriptor x0, XmlAttributeDescriptor[] x1) {
        x0.myAttributeDescriptors = x1;
        return x1;
    }

    static enum CanContainAttributeType {
        CanContainButSkip,
        CanContainButDoNotSkip,
        CanNotContain;

    }

    static class CurrentContextInfo {
        final XmlNSDescriptorImpl documentDescriptor;
        final String expectedDefaultNs;

        public CurrentContextInfo(XmlNSDescriptorImpl _nsDescriptor, String _ns) {
            this.documentDescriptor = _nsDescriptor;
            this.expectedDefaultNs = _ns;
        }
    }

    static interface TagSchemaProcessor {
        public ProcessingStrategy visitElement(XmlTag var1);

        public ProcessingStrategy visitTag(XmlTag var1);

        public static enum ProcessingStrategy {
            SkipChildren,
            ProcessChildren,
            Stop;

        }
    }
}

