/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.evaluate.CodeFragmentInputComponent;
import com.intellij.xdebugger.impl.evaluate.EvaluationDialogMode;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.evaluate.ExpressionInputComponent;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.nodes.EvaluatingExpressionRootNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class XDebuggerEvaluationDialog
extends DialogWrapper {
    private final JPanel myMainPanel;
    private final JPanel myResultPanel;
    private final XDebuggerTreePanel myTreePanel;
    private EvaluationInputComponent myInputComponent;
    private final XDebuggerEvaluator myEvaluator;
    private final XDebugSession mySession;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private EvaluationDialogMode myMode;
    private final XSourcePosition mySourcePosition;
    private final SwitchModeAction mySwitchModeAction;

    public XDebuggerEvaluationDialog(@NotNull XDebugSession session, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull XDebuggerEvaluator evaluator, @NotNull String text, EvaluationDialogMode mode, XSourcePosition sourcePosition) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog.<init> must not be null");
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog.<init> must not be null");
        }
        if (evaluator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xdebugger/impl/evaluate/XDebuggerEvaluationDialog.<init> must not be null");
        }
        super(session.getProject(), true);
        this.mySession = session;
        this.myEditorsProvider = editorsProvider;
        this.mySourcePosition = sourcePosition;
        this.setModal(false);
        this.setOKButtonText(XDebuggerBundle.message((String)"xdebugger.button.evaluate", (Object[])new Object[0]));
        this.setCancelButtonText(XDebuggerBundle.message((String)"xdebugger.evaluate.dialog.close", (Object[])new Object[0]));
        this.myTreePanel = new XDebuggerTreePanel(session, editorsProvider, sourcePosition, "XDebugger.Evaluation.Dialog.Tree.Popup");
        this.myResultPanel = new JPanel(new BorderLayout());
        this.myResultPanel.add((Component)new JLabel(XDebuggerBundle.message((String)"xdebugger.evaluate.label.result", (Object[])new Object[0])), "North");
        this.myResultPanel.add((Component)this.myTreePanel.getMainPanel(), "Center");
        this.myEvaluator = evaluator;
        this.myMainPanel = new JPanel(new BorderLayout());
        this.mySwitchModeAction = new SwitchModeAction();
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                XDebuggerEvaluationDialog.this.doOKAction();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 128)), (JComponent)this.getRootPane(), this.myDisposable);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                IdeFocusManager.getInstance((Project)XDebuggerEvaluationDialog.this.mySession.getProject()).requestFocus((Component)((Object)XDebuggerEvaluationDialog.this.myTreePanel.getTree()), true);
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(82, 512)), (JComponent)this.getRootPane(), this.myDisposable);
        this.switchToMode(mode, text);
        this.init();
    }

    protected void doOKAction() {
        this.evaluate();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.mySwitchModeAction, this.getCancelAction()};
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = super.createJButtonForAction(action);
        if (action == this.mySwitchModeAction) {
            int width1 = new JButton((String)XDebuggerEvaluationDialog.getSwitchButtonText((EvaluationDialogMode)EvaluationDialogMode.EXPRESSION)).getPreferredSize().width;
            int width2 = new JButton((String)XDebuggerEvaluationDialog.getSwitchButtonText((EvaluationDialogMode)EvaluationDialogMode.CODE_FRAGMENT)).getPreferredSize().width;
            Dimension size = new Dimension(Math.max(width1, width2), button.getPreferredSize().height);
            button.setMinimumSize(size);
            button.setPreferredSize(size);
        }
        return button;
    }

    private static String getSwitchButtonText(EvaluationDialogMode mode) {
        return mode != EvaluationDialogMode.EXPRESSION ? XDebuggerBundle.message((String)"button.text.expression.mode", (Object[])new Object[0]) : XDebuggerBundle.message((String)"button.text.code.fragment.mode", (Object[])new Object[0]);
    }

    private void switchToMode(EvaluationDialogMode mode, String text) {
        if (this.myMode == mode) {
            return;
        }
        this.myMode = mode;
        this.myInputComponent = this.createInputComponent(mode, text);
        this.myMainPanel.removeAll();
        this.myInputComponent.addComponent(this.myMainPanel, this.myResultPanel);
        this.setTitle(this.myInputComponent.getTitle());
        this.mySwitchModeAction.putValue("Name", XDebuggerEvaluationDialog.getSwitchButtonText(mode));
        JComponent preferredFocusedComponent = this.myInputComponent.getInputEditor().getPreferredFocusedComponent();
        if (preferredFocusedComponent != null) {
            IdeFocusManager.getInstance((Project)this.mySession.getProject()).requestFocus((Component)preferredFocusedComponent, true);
        }
    }

    private EvaluationInputComponent createInputComponent(EvaluationDialogMode mode, String text) {
        Project project = this.mySession.getProject();
        if (mode == EvaluationDialogMode.EXPRESSION) {
            return new ExpressionInputComponent(project, this.myEditorsProvider, this.mySourcePosition, text);
        }
        return new CodeFragmentInputComponent(project, this.myEditorsProvider, this.mySourcePosition, text, this.myDisposable);
    }

    private void evaluate() {
        XDebuggerTree tree = this.myTreePanel.getTree();
        EvaluatingExpressionRootNode root = new EvaluatingExpressionRootNode(this, tree);
        tree.setRoot(root, false);
        this.myResultPanel.invalidate();
        this.myInputComponent.getInputEditor().selectAll();
    }

    protected void dispose() {
        this.myTreePanel.dispose();
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#xdebugger.evaluate";
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public void startEvaluation(XDebuggerEvaluator.XEvaluationCallback evaluationCallback) {
        XDebuggerEditorBase inputEditor = this.myInputComponent.getInputEditor();
        inputEditor.saveTextInHistory();
        String expression = inputEditor.getText();
        this.myEvaluator.evaluate(expression, evaluationCallback, null);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myInputComponent.getInputEditor().getPreferredFocusedComponent();
    }

    private class SwitchModeAction
    extends AbstractAction {
        private SwitchModeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = XDebuggerEvaluationDialog.this.myInputComponent.getInputEditor().getText();
            if (XDebuggerEvaluationDialog.this.myMode == EvaluationDialogMode.EXPRESSION) {
                XDebuggerEvaluationDialog.this.switchToMode(EvaluationDialogMode.CODE_FRAGMENT, text);
            } else {
                if (text.indexOf(10) != -1) {
                    text = "";
                }
                XDebuggerEvaluationDialog.this.switchToMode(EvaluationDialogMode.EXPRESSION, text);
            }
        }
    }
}

