/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionProvider;
import org.jetbrains.annotations.Nullable;

public class JavaVcsSelectionProvider
implements VcsSelectionProvider {
    @Nullable
    public VcsSelection getSelection(VcsContext context) {
        String actionName;
        Editor editor = context.getEditor();
        if (editor == null) {
            return null;
        }
        PsiElement psiElement = TargetElementUtilBase.findTargetElement(editor, 2);
        if (psiElement == null) {
            return null;
        }
        if (!psiElement.isValid()) {
            return null;
        }
        if (psiElement instanceof PsiCompiledElement) {
            return null;
        }
        if (psiElement instanceof PsiClass) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.class", (Object[])new Object[0]);
        } else if (psiElement instanceof PsiField) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.field", (Object[])new Object[0]);
        } else if (psiElement instanceof PsiMethod) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.method", (Object[])new Object[0]);
        } else if (psiElement instanceof PsiCodeBlock) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.code.block", (Object[])new Object[0]);
        } else if (psiElement instanceof PsiStatement) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.statement", (Object[])new Object[0]);
        } else {
            return null;
        }
        TextRange textRange = psiElement.getTextRange();
        if (textRange == null) {
            return null;
        }
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        return new VcsSelection(document, textRange, actionName);
    }
}

