/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import gnu.trove.THashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomChildDescriptionImpl
implements AbstractDomChildrenDescription,
Comparable<AbstractDomChildDescriptionImpl> {
    private final Type myType;
    private Map<Class, Annotation> myCustomAnnotations;
    @Nullable
    private Map myUserMap;

    protected AbstractDomChildDescriptionImpl(Type type) {
        this.myType = type;
    }

    public final void addCustomAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl.addCustomAnnotation must not be null");
        }
        if (this.myCustomAnnotations == null) {
            this.myCustomAnnotations = new THashMap();
        }
        this.myCustomAnnotations.put(annotation.annotationType(), annotation);
    }

    public void setUserMap(Map userMap) {
        this.myUserMap = userMap;
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)(this.myCustomAnnotations == null ? null : this.myCustomAnnotations.get(annotationClass));
    }

    public <T> T getUserData(Key<T> key) {
        return this.myUserMap == null ? null : (T)this.myUserMap.get(key);
    }

    @NotNull
    public final List<? extends DomElement> getStableValues(final @NotNull DomElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl.getStableValues must not be null");
        }
        List list = this.getValues(parent);
        ArrayList<DomElement> result = new ArrayList<DomElement>(list.size());
        DomManager domManager = parent.getManager();
        int i = 0;
        while (i < list.size()) {
            final int i1 = i++;
            result.add(domManager.createStableValue((Factory)new Factory<DomElement>(){

                @Nullable
                public DomElement create() {
                    if (!parent.isValid()) {
                        return null;
                    }
                    List domElements = AbstractDomChildDescriptionImpl.this.getValues(parent);
                    return domElements.size() > i1 ? (DomElement)domElements.get(i1) : null;
                }
            }));
        }
        ArrayList<DomElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl.getStableValues must not return null");
        }
        return arrayList;
    }

    @NotNull
    public final Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl.getType must not return null");
        }
        return type;
    }

    @NotNull
    public DomNameStrategy getDomNameStrategy(@NotNull DomElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl.getDomNameStrategy must not be null");
        }
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(ReflectionUtil.getRawType((Type)this.myType), false);
        DomNameStrategy domNameStrategy = strategy == null ? parent.getNameStrategy() : strategy;
        if (domNameStrategy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl.getDomNameStrategy must not return null");
        }
        return domNameStrategy;
    }
}

