/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.Language;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.indexing.FileBasedIndex;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public final class FileContent
extends UserDataHolderBase {
    private final VirtualFile myFile;
    private final String fileName;
    private final FileType myFileType;
    private Charset myCharset;
    private byte[] myContent;
    private CharSequence myContentAsText;
    private final Key<PsiFile> CACHED_PSI;

    public Project getProject() {
        return (Project)this.getUserData(FileBasedIndex.PROJECT);
    }

    public PsiFile getPsiFile() {
        PsiFile psi = (PsiFile)this.getUserData(FileBasedIndex.PSI_FILE);
        if (psi == null) {
            psi = (PsiFile)this.getUserData(this.CACHED_PSI);
        }
        if (psi == null) {
            Project project = this.getProject();
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
            Language language = ((LanguageFileType)this.getFileType()).getLanguage();
            Language substitutedLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, this.getFile(), project);
            psi = PsiFileFactory.getInstance((Project)project).createFileFromText(this.getFileName(), substitutedLanguage, this.getContentAsText(), false, false);
            psi.putUserData(FileBasedIndex.VIRTUAL_FILE, (Object)this.getFile());
            this.putUserData(this.CACHED_PSI, psi);
        }
        return psi;
    }

    public FileContent(@NotNull VirtualFile file, @NotNull CharSequence contentAsText, Charset charset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/FileContent.<init> must not be null");
        }
        if (contentAsText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/indexing/FileContent.<init> must not be null");
        }
        this(file);
        this.myContentAsText = contentAsText;
        this.myCharset = charset;
    }

    public FileContent(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/FileContent.<init> must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/indexing/FileContent.<init> must not be null");
        }
        this(file);
        this.myContent = content;
        this.myCharset = LoadTextUtil.detectCharset(file, content);
    }

    public FileContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/FileContent.<init> must not be null");
        }
        this.myContentAsText = null;
        this.CACHED_PSI = Key.create((String)"cached psi from content");
        this.myFile = file;
        this.myFileType = FileTypeManager.getInstance().getFileTypeByFile(file);
        this.fileName = file.getName();
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public byte[] getContent() {
        if (this.myContent == null && this.myContentAsText != null) {
            try {
                this.myContent = this.myCharset != null ? ((Object)this.myContentAsText).toString().getBytes(this.myCharset.name()) : ((Object)this.myContentAsText).toString().getBytes();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.myContent;
    }

    public CharSequence getContentAsText() {
        if (this.myFileType.isBinary()) {
            throw new IllegalDataException("Cannot obtain text for binary file type : " + this.myFileType.getDescription());
        }
        if (this.myContentAsText == null && this.myContent != null) {
            this.myContentAsText = LoadTextUtil.getTextByBinaryPresentation(this.myContent, this.myCharset);
        }
        return this.myContentAsText;
    }

    public String toString() {
        return this.fileName;
    }

    public static class IllegalDataException
    extends RuntimeException {
        public IllegalDataException(String message) {
            super(message);
        }

        public IllegalDataException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

