/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.util.containers.HashSet;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaUsageTypeProvider
implements UsageTypeProvider {
    public UsageType getUsageType(PsiElement element) {
        UsageType classUsageType = JavaUsageTypeProvider.getClassUsageType(element);
        if (classUsageType != null) {
            return classUsageType;
        }
        UsageType methodUsageType = JavaUsageTypeProvider.getMethodUsageType(element);
        if (methodUsageType != null) {
            return methodUsageType;
        }
        if (element instanceof PsiLiteralExpression) {
            return UsageType.LITERAL_USAGE;
        }
        return null;
    }

    @Nullable
    private static UsageType getMethodUsageType(PsiElement element) {
        PsiMethod containerMethod;
        if (element instanceof PsiReferenceExpression && (containerMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) != null) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            PsiElement p = referenceExpression.getParent();
            if (p instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)p;
                PsiMethod calledMethod = callExpression.resolveMethod();
                if (qualifier != null && !(qualifier instanceof PsiThisExpression) && calledMethod != null) {
                    if (JavaUsageTypeProvider.haveCommonSuperMethod(containerMethod, calledMethod)) {
                        boolean parametersDelegated = JavaUsageTypeProvider.parametersDelegated(containerMethod, callExpression);
                        if (qualifier instanceof PsiSuperExpression) {
                            return parametersDelegated ? UsageType.DELEGATE_TO_SUPER : UsageType.DELEGATE_TO_SUPER_PARAMETERS_CHANGED;
                        }
                        return parametersDelegated ? UsageType.DELEGATE_TO_ANOTHER_INSTANCE : UsageType.DELEGATE_TO_ANOTHER_INSTANCE_PARAMETERS_CHANGED;
                    }
                } else if (calledMethod == containerMethod) {
                    return UsageType.RECURSION;
                }
            }
        }
        return null;
    }

    private static boolean parametersDelegated(PsiMethod method, PsiMethodCallExpression call) {
        PsiExpression[] arguments;
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != (arguments = call.getArgumentList().getExpressions()).length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiExpression argument = arguments[i];
            if (!(argument instanceof PsiReferenceExpression)) {
                return false;
            }
            if (((PsiReferenceExpression)argument).isReferenceTo((PsiElement)parameter)) continue;
            return false;
        }
        for (PsiParameter parameter : parameters) {
            if (!PsiUtil.isAssigned((PsiParameter)parameter)) continue;
            return false;
        }
        return true;
    }

    private static boolean haveCommonSuperMethod(@NotNull PsiMethod m1, @NotNull PsiMethod m2) {
        if (m1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usages/impl/rules/JavaUsageTypeProvider.haveCommonSuperMethod must not be null");
        }
        if (m2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/usages/impl/rules/JavaUsageTypeProvider.haveCommonSuperMethod must not be null");
        }
        HashSet s1 = new HashSet(Arrays.asList(m1.findDeepestSuperMethods()));
        s1.add((Object)m1);
        HashSet s2 = new HashSet(Arrays.asList(m2.findDeepestSuperMethods()));
        s2.add((Object)m2);
        s1.retainAll((Collection)s2);
        return !s1.isEmpty();
    }

    @Nullable
    private static UsageType getClassUsageType(PsiElement element) {
        PsiJavaCodeReferenceElement classReference;
        PsiTypeElement retType;
        PsiReferenceExpression expression;
        PsiTypeCastExpression castExpression;
        if (element.getParent() instanceof PsiAnnotation && element == ((PsiAnnotation)element.getParent()).getNameReferenceElement()) {
            return UsageType.ANNOTATION;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class, (boolean)false) != null) {
            return UsageType.CLASS_IMPORT;
        }
        PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiReferenceList.class);
        if (referenceList != null) {
            if (referenceList.getParent() instanceof PsiClass) {
                return UsageType.CLASS_EXTENDS_IMPLEMENTS_LIST;
            }
            if (referenceList.getParent() instanceof PsiMethod) {
                return UsageType.CLASS_METHOD_THROWS_LIST;
            }
        }
        if ((castExpression = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeCastExpression.class)) != null && PsiTreeUtil.isAncestor((PsiElement)castExpression.getCastType(), (PsiElement)element, (boolean)true)) {
            return UsageType.CLASS_CAST_TO;
        }
        PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiInstanceOfExpression.class);
        if (instanceOfExpression != null && PsiTreeUtil.isAncestor((PsiElement)instanceOfExpression.getCheckType(), (PsiElement)element, (boolean)true)) {
            return UsageType.CLASS_INSTANCE_OF;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiClassObjectAccessExpression.class) != null) {
            return UsageType.CLASS_CLASS_OBJECT_ACCESS;
        }
        if (element instanceof PsiReferenceExpression && (expression = (PsiReferenceExpression)element).resolve() instanceof PsiClass) {
            return UsageType.CLASS_STATIC_MEMBER_ACCESS;
        }
        PsiParameter psiParameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class);
        if (psiParameter != null) {
            PsiElement scope = psiParameter.getDeclarationScope();
            if (scope instanceof PsiMethod) {
                return UsageType.CLASS_METHOD_PARAMETER_DECLARATION;
            }
            if (scope instanceof PsiCatchSection) {
                return UsageType.CLASS_CATCH_CLAUSE_PARAMETER_DECLARATION;
            }
            if (scope instanceof PsiForeachStatement) {
                return UsageType.CLASS_LOCAL_VAR_DECLARATION;
            }
            return null;
        }
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (psiField != null && PsiTreeUtil.isAncestor((PsiElement)psiField.getTypeElement(), (PsiElement)element, (boolean)true)) {
            return UsageType.CLASS_FIELD_DECLARATION;
        }
        PsiLocalVariable psiLocalVar = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class);
        if (psiLocalVar != null && PsiTreeUtil.isAncestor((PsiElement)psiLocalVar.getTypeElement(), (PsiElement)element, (boolean)true)) {
            return UsageType.CLASS_LOCAL_VAR_DECLARATION;
        }
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (psiMethod != null && (retType = psiMethod.getReturnTypeElement()) != null && PsiTreeUtil.isAncestor((PsiElement)retType, (PsiElement)element, (boolean)true)) {
            return UsageType.CLASS_METHOD_RETURN_TYPE;
        }
        PsiNewExpression psiNewExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
        if (psiNewExpression != null && (classReference = psiNewExpression.getClassReference()) != null && PsiTreeUtil.isAncestor((PsiElement)classReference, (PsiElement)element, (boolean)false)) {
            return UsageType.CLASS_NEW_OPERATOR;
        }
        return null;
    }
}

