/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.ui.Hint;
import com.intellij.ui.HintListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;

public class LightweightHint
extends UserDataHolderBase
implements Hint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.LightweightHint");
    private final JComponent myComponent;
    private JComponent myFocusBackComponent;
    private final EventListenerList myListenerList;
    private MyEscListener myEscListener;
    private JBPopup myPopup;
    private JComponent myParentComponent;
    private boolean myIsRealPopup;
    private boolean myForceLightweightPopup;
    private boolean mySelectingHint;
    private boolean myForceShowAsPopup;
    private String myTitle;

    public LightweightHint(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/LightweightHint.<init> must not be null");
        }
        this.myListenerList = new EventListenerList();
        this.myIsRealPopup = false;
        this.myForceLightweightPopup = false;
        this.myForceShowAsPopup = false;
        this.myTitle = null;
        this.myComponent = component;
    }

    public void setForceLightweightPopup(boolean forceLightweightPopup) {
        this.myForceLightweightPopup = forceLightweightPopup;
    }

    public void setForceShowAsPopup(boolean forceShowAsPopup) {
        this.myForceShowAsPopup = forceShowAsPopup;
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public boolean isSelectingHint() {
        return this.mySelectingHint;
    }

    public void setSelectingHint(boolean selectingHint) {
        this.mySelectingHint = selectingHint;
    }

    @Override
    public void show(@NotNull JComponent parentComponent, int x, int y, JComponent focusBackComponent) {
        if (parentComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/LightweightHint.show must not be null");
        }
        this.myParentComponent = parentComponent;
        this.myFocusBackComponent = focusBackComponent;
        LOG.assertTrue(this.myParentComponent.isShowing());
        this.myEscListener = new MyEscListener();
        this.myComponent.registerKeyboardAction(this.myEscListener, KeyStroke.getKeyStroke(27, 0), 2);
        JLayeredPane layeredPane = parentComponent.getRootPane().getLayeredPane();
        if (!this.myForceShowAsPopup && (this.myForceLightweightPopup || LightweightHint.fitsLayeredPane(layeredPane, this.myComponent, new RelativePoint((Component)parentComponent, new Point(x, y))))) {
            this.beforeShow();
            Dimension preferredSize = this.myComponent.getPreferredSize();
            Point layeredPanePoint = SwingUtilities.convertPoint(parentComponent, x, y, layeredPane);
            this.myComponent.setBounds(layeredPanePoint.x, layeredPanePoint.y, preferredSize.width, preferredSize.height);
            layeredPane.add((Component)this.myComponent, (Object)(250 + layeredPane.getComponentCount()));
            this.myComponent.validate();
            this.myComponent.repaint();
        } else {
            this.myIsRealPopup = true;
            this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(this.myComponent, null).setRequestFocus(false).setResizable(this.myForceShowAsPopup).setMovable(this.myForceShowAsPopup).setTitle(this.myTitle).createPopup();
            this.beforeShow();
            this.myPopup.show(new RelativePoint((Component)this.myParentComponent, new Point(x, y)));
        }
    }

    protected void beforeShow() {
    }

    private static boolean fitsLayeredPane(JLayeredPane pane, JComponent component, RelativePoint desiredLocation) {
        Rectangle lpRect = new Rectangle(pane.getLocationOnScreen().x, pane.getLocationOnScreen().y, pane.getWidth(), pane.getHeight());
        Rectangle componentRect = new Rectangle(desiredLocation.getScreenPoint().x, desiredLocation.getScreenPoint().y, component.getPreferredSize().width, component.getPreferredSize().height);
        return lpRect.contains(componentRect);
    }

    private void fireHintHidden() {
        EventListener[] listeners;
        for (EventListener listener : listeners = this.myListenerList.getListeners(HintListener.class)) {
            ((HintListener)listener).hintHidden(new EventObject(this));
        }
    }

    public final void setLocation(int x, int y) {
        if (this.myIsRealPopup) {
            if (this.myPopup == null) {
                return;
            }
            ((AbstractPopup)this.myPopup).setLocation(new RelativePoint((Component)this.myParentComponent, new Point(x, y)));
        } else {
            this.myComponent.setLocation(x, y);
            Dimension preferredSize = this.myComponent.getPreferredSize();
            if (!preferredSize.equals(this.myComponent.getSize())) {
                JLayeredPane layeredPane = this.myParentComponent.getRootPane().getLayeredPane();
                Point layeredPanePoint = SwingUtilities.convertPoint(this.myParentComponent, x, y, layeredPane);
                this.myComponent.setBounds(layeredPanePoint.x, layeredPanePoint.y, preferredSize.width, preferredSize.height);
            }
            this.myComponent.validate();
            this.myComponent.repaint();
        }
    }

    public final void setBounds(int x, int y, int width, int height) {
        if (this.myIsRealPopup) {
            this.setLocation(x, y);
            if (this.myPopup != null) {
                this.myPopup.setSize(new Dimension(width, height));
            }
        } else {
            this.myComponent.setBounds(x, y, width, height);
            this.myComponent.setLocation(x, y);
            this.myComponent.validate();
            this.myComponent.repaint();
        }
    }

    public final Rectangle getBounds() {
        return this.myComponent.getBounds();
    }

    @Override
    public boolean isVisible() {
        return this.myIsRealPopup ? this.myPopup != null : this.myComponent.isShowing();
    }

    protected final boolean isRealPopup() {
        return this.myIsRealPopup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hide() {
        if (this.isVisible()) {
            if (this.myIsRealPopup) {
                this.myPopup.cancel();
                this.myPopup = null;
            } else {
                JRootPane rootPane = this.myComponent.getRootPane();
                if (rootPane != null) {
                    Rectangle bounds = this.myComponent.getBounds();
                    JLayeredPane layeredPane = rootPane.getLayeredPane();
                    try {
                        if (this.myFocusBackComponent != null) {
                            LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent(this.myFocusBackComponent);
                        }
                        layeredPane.remove(this.myComponent);
                    }
                    finally {
                        LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent(null);
                    }
                    layeredPane.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        }
        if (this.myEscListener != null) {
            this.myComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        }
        this.fireHintHidden();
    }

    public final JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public final void addHintListener(HintListener listener) {
        this.myListenerList.add(HintListener.class, listener);
    }

    @Override
    public final void removeHintListener(HintListener listener) {
        this.myListenerList.remove(HintListener.class, listener);
    }

    public String toString() {
        return this.getComponent().toString();
    }

    private final class MyEscListener
    implements ActionListener {
        private MyEscListener() {
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            LightweightHint.this.hide();
        }
    }
}

