/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.tools.ToolsBundle;

class ToolProcessAdapter
extends ProcessAdapter {
    private final Project myProject;
    private final boolean mySynchronizeAfterExecution;
    private final String myName;

    public ToolProcessAdapter(Project project, boolean synchronizeAfterExecution, String name) {
        this.myProject = project;
        this.mySynchronizeAfterExecution = synchronizeAfterExecution;
        this.myName = name;
    }

    public void processTerminated(ProcessEvent event) {
        final String message = ToolsBundle.message("tools.completed.message", this.myName, event.getExitCode());
        if (this.mySynchronizeAfterExecution) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    VirtualFileManager.getInstance().refresh(true, new Runnable(){

                        @Override
                        public void run() {
                            if (ProjectManagerEx.getInstanceEx().isProjectOpened(ToolProcessAdapter.this.myProject)) {
                                WindowManager.getInstance().getStatusBar(ToolProcessAdapter.this.myProject).setInfo(message);
                            }
                        }
                    });
                }
            });
        }
        if (ProjectManagerEx.getInstanceEx().isProjectOpened(this.myProject)) {
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(message);
        }
    }
}

