/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.actions.BaseGenerateAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFrameworkDescriptor;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateTestMethodAction
extends BaseGenerateAction {
    public GenerateTestMethodAction() {
        super((CodeInsightActionHandler)new MyHandler());
    }

    protected PsiClass getTargetClass(Editor editor, PsiFile file) {
        return GenerateTestMethodAction.findTargetClass(editor, file);
    }

    private static PsiClass findTargetClass(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        return TestIntegrationUtils.findOuterClass(element);
    }

    protected boolean isValidForClass(PsiClass targetClass) {
        return TestIntegrationUtils.isTest((PsiElement)targetClass) && GenerateTestMethodAction.findDescriptor(targetClass) != null;
    }

    private static TestFrameworkDescriptor findDescriptor(PsiClass targetClass) {
        for (TestFrameworkDescriptor each : (TestFrameworkDescriptor[])Extensions.getExtensions((ExtensionPointName)TestFrameworkDescriptor.EXTENSION_NAME)) {
            if (!each.isTestClass((PsiElement)targetClass)) continue;
            return each;
        }
        return null;
    }

    private static class MyHandler
    implements CodeInsightActionHandler {
        private MyHandler() {
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testIntegration/GenerateTestMethodAction$MyHandler.invoke must not be null");
            }
            if (editor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testIntegration/GenerateTestMethodAction$MyHandler.invoke must not be null");
            }
            if (file == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/testIntegration/GenerateTestMethodAction$MyHandler.invoke must not be null");
            }
            try {
                PsiMethod method = this.generateDummyMethod(editor, file);
                if (method == null) {
                    return;
                }
                PsiClass targetClass = GenerateTestMethodAction.findTargetClass(editor, file);
                TestIntegrationUtils.runTestMethodTemplate(TestIntegrationUtils.MethodKind.TEST, GenerateTestMethodAction.findDescriptor(targetClass), editor, targetClass, method, "name", false);
            }
            catch (IncorrectOperationException e) {
                throw new RuntimeException(e);
            }
        }

        @Nullable
        private PsiMethod generateDummyMethod(Editor editor, PsiFile file) throws IncorrectOperationException {
            ArrayList<1> members = new ArrayList<1>();
            final PsiMethod method = TestIntegrationUtils.createDummyMethod(file.getProject());
            final PsiMethod[] result = new PsiMethod[1];
            members.add(new GenerationInfo(){

                @Override
                @NotNull
                public PsiMember getPsiMember() {
                    PsiMethod psiMethod = method;
                    if (psiMethod == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/testIntegration/GenerateTestMethodAction$MyHandler$1.getPsiMember must not return null");
                    }
                    return psiMethod;
                }

                @Override
                public void insert(PsiClass aClass, PsiElement anchor, boolean before) throws IncorrectOperationException {
                    result[0] = (PsiMethod)GenerateMembersUtil.insert(aClass, (PsiMember)method, anchor, before);
                }
            });
            int offset = this.findOffetToInsertMethodTo(editor, file);
            GenerateMembersUtil.insertMembersAtOffset(file, offset, members);
            return CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(result[0]);
        }

        private int findOffetToInsertMethodTo(Editor editor, PsiFile file) {
            int result = editor.getCaretModel().getOffset();
            PsiClass classAtCursor = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(result), PsiClass.class, (boolean)false);
            while (classAtCursor != null && !(classAtCursor.getParent() instanceof PsiFile)) {
                result = classAtCursor.getTextRange().getEndOffset();
                classAtCursor = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)classAtCursor, PsiClass.class);
            }
            return result;
        }

        public boolean startInWriteAction() {
            return true;
        }
    }
}

