/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import junit.framework.Assert;

public class ThreadTracker {
    private final Collection<Thread> before = ThreadTracker.getThreads();
    private final boolean myDefaultProjectInitialized = ((ProjectManagerImpl)ProjectManager.getInstance()).isDefaultProjectInitialized();
    private static final Set<String> wellKnownOffenders = new THashSet<String>(){
        {
            this.add("Alarm pool(own)");
            this.add("Alarm pool(shared)");
            this.add("ApplicationImpl pooled thread");
            this.add("AWT-Shutdown");
            this.add("AWT-Windows");
            this.add("CompilerThread0");
            this.add("Finalizer");
            this.add("FS Synchronizer");
            this.add("IDEA Test Case Thread");
            this.add("Image Fetcher 0");
            this.add("Java2D Disposer");
            this.add("Low Memory Detector");
            this.add("main");
            this.add("Monitor Ctrl-Break");
            this.add("Periodic tasks thread");
            this.add("Reference Handler");
            this.add("Signal Dispatcher");
            this.add("SimpleTimer");
            this.add("timed reference disposer");
            this.add("timer-int");
            this.add("timer-sys");
            this.add("TimerQueue");
            this.add("UserActivityMonitor thread");
            this.add("VM Periodic Task Thread");
            this.add("VM Thread");
            this.add("YJPAgent-Telemetry");
            this.add("Change List Updater");
        }
    };

    private static Collection<Thread> getThreads() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLeak() {
        try {
            if (this.myDefaultProjectInitialized != ((ProjectManagerImpl)ProjectManager.getInstance()).isDefaultProjectInitialized()) {
                return;
            }
            THashSet after = new THashSet(ThreadTracker.getThreads());
            after.removeAll(this.before);
            for (Thread thread : after) {
                String name;
                ThreadGroup group;
                if (thread == Thread.currentThread() || (group = thread.getThreadGroup()) != null && "system".equals(group.getName()) || (name = thread.getName()).startsWith("AWT-EventQueue-0") || name.startsWith("JobScheduler pool ") || wellKnownOffenders.contains(name)) continue;
                String trace = "Thread leaked: " + thread + ": " + name + ";\n ";
                for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                    trace = trace + " at " + stackTraceElement + "\n";
                }
                Assert.fail((String)trace);
            }
        }
        finally {
            this.before.clear();
        }
    }
}

