/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.refactoring.classMembers.AbstractMemberInfoStorage;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import java.util.ArrayList;

public class MemberInfoStorage
extends AbstractMemberInfoStorage<PsiMember, PsiClass, MemberInfo> {
    public MemberInfoStorage(PsiClass aClass, MemberInfoBase.Filter<PsiMember> memberInfoFilter) {
        super(aClass, memberInfoFilter);
    }

    @Override
    protected boolean isInheritor(PsiClass baseClass, PsiClass aClass) {
        return aClass.isInheritor(baseClass, true);
    }

    @Override
    protected void extractClassMembers(PsiClass aClass, ArrayList<MemberInfo> temp) {
        MemberInfo.extractClassMembers(aClass, temp, (MemberInfoBase.Filter<PsiMember>)this.myFilter, false);
    }

    @Override
    protected boolean memberConflict(PsiElement member1, PsiElement member) {
        if (member instanceof PsiMethod && member1 instanceof PsiMethod) {
            return MethodSignatureUtil.areSignaturesEqual((PsiMethod)((PsiMethod)member), (PsiMethod)((PsiMethod)member1));
        }
        if (member instanceof PsiField && member1 instanceof PsiField || member instanceof PsiClass && member1 instanceof PsiClass) {
            return ((PsiNamedElement)member).getName().equals(((PsiNamedElement)member1).getName());
        }
        return false;
    }

    @Override
    protected void buildSubClassesMap(PsiClass aClass) {
        PsiReferenceList implementsList;
        PsiReferenceList extendsList = aClass.getExtendsList();
        if (extendsList != null) {
            this.buildSubClassesMapForList(extendsList.getReferencedTypes(), aClass);
        }
        if ((implementsList = aClass.getImplementsList()) != null) {
            this.buildSubClassesMapForList(implementsList.getReferencedTypes(), aClass);
        }
    }

    private void buildSubClassesMapForList(PsiClassType[] classesList, PsiClass aClass) {
        for (int i = 0; i < classesList.length; ++i) {
            PsiClassType element = classesList[i];
            PsiClass resolved = element.resolve();
            if (resolved == null) continue;
            PsiClass superClass = resolved;
            this.getSubclasses(superClass).add(aClass);
            this.buildSubClassesMap(superClass);
        }
    }
}

