/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithBuilder;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.replaceConstructorWithBuilder.ParameterData;
import com.intellij.refactoring.replaceConstructorWithBuilder.ReplaceConstructorWithBuilderProcessor;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.util.ui.Table;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ReplaceConstructorWithBuilderDialog
extends RefactoringDialog {
    private final PsiMethod[] myConstructors;
    private JRadioButton myCreateBuilderClassRadioButton;
    private JRadioButton myExistingBuilderClassRadioButton;
    private JPanel myWholePanel;
    private JTextField myNewClassName;
    private ReferenceEditorComboWithBrowseButton myPackageTextField;
    private ReferenceEditorComboWithBrowseButton myExistentClassTF;
    private static final Logger LOG = Logger.getInstance((String)("#" + ReplaceConstructorWithBuilderDialog.class.getName()));
    private final LinkedHashMap<String, ParameterData> myParametersMap;
    private MyTableModel myTableModel;
    private Table myTable;
    private static final String RECENT_KEYS = "ReplaceConstructorWithBuilder.RECENT_KEYS";
    private static final int PARAM = 0;
    private static final int FIELD = 1;
    private static final int SETTER = 2;
    private static final int DEFAULT_VALUE = 3;
    private static final int SKIP_SETTER = 4;

    protected ReplaceConstructorWithBuilderDialog(@NotNull Project project, PsiMethod[] constructors) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderDialog.<init> must not be null");
        }
        super(project, false);
        this.myConstructors = constructors;
        this.$$$setupUI$$$();
        this.myParametersMap = new LinkedHashMap();
        for (PsiMethod constructor : constructors) {
            ParameterData.createFromConstructor(constructor, this.myParametersMap);
        }
        this.init();
        this.setTitle("Replace Constructor with Builder");
    }

    protected String getHelpId() {
        return "replace_constructor_with_builder_dialog";
    }

    @Override
    protected void doAction() {
        String packageName;
        String className;
        TableUtil.stopEditing((JTable)this.myTable);
        if (this.myCreateBuilderClassRadioButton.isSelected()) {
            className = this.myNewClassName.getText().trim();
            packageName = this.myPackageTextField.getText().trim();
        } else {
            String fqName = this.myExistentClassTF.getText().trim();
            className = StringUtil.getShortName((String)fqName);
            packageName = StringUtil.getPackageName((String)fqName);
            PsiClass builderClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(StringUtil.getQualifiedName((String)packageName, (String)className), GlobalSearchScope.projectScope((Project)this.myProject));
            if (builderClass != null && !CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)builderClass)) {
                return;
            }
        }
        this.invokeRefactoring(new ReplaceConstructorWithBuilderProcessor(this.getProject(), this.myConstructors, this.myParametersMap, className, packageName, this.myCreateBuilderClassRadioButton.isSelected()));
    }

    protected JComponent createNorthPanel() {
        return this.createTablePanel();
    }

    protected JComponent createCenterPanel() {
        ActionListener enableDisableListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceConstructorWithBuilderDialog.this.setEnabled(ReplaceConstructorWithBuilderDialog.this.myCreateBuilderClassRadioButton.isSelected());
                IdeFocusManager.getInstance((Project)ReplaceConstructorWithBuilderDialog.this.myProject).requestFocus((Component)(ReplaceConstructorWithBuilderDialog.this.myCreateBuilderClassRadioButton.isSelected() ? ReplaceConstructorWithBuilderDialog.this.myNewClassName : ReplaceConstructorWithBuilderDialog.this.myExistentClassTF.getChildComponent()), true);
                ReplaceConstructorWithBuilderDialog.this.validateButtons();
            }
        };
        this.myCreateBuilderClassRadioButton.addActionListener(enableDisableListener);
        this.myExistingBuilderClassRadioButton.addActionListener(enableDisableListener);
        this.myCreateBuilderClassRadioButton.setSelected(true);
        this.setEnabled(true);
        com.intellij.ui.DocumentAdapter validateButtonsListener = new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                ReplaceConstructorWithBuilderDialog.this.validateButtons();
            }
        };
        this.myNewClassName.getDocument().addDocumentListener((javax.swing.event.DocumentListener)validateButtonsListener);
        PsiClass psiClass = this.myConstructors[0].getContainingClass();
        LOG.assertTrue(psiClass != null);
        this.myNewClassName.setText(psiClass.getName() + "Builder");
        return this.myWholePanel;
    }

    private void setEnabled(boolean createNew) {
        this.myNewClassName.setEnabled(createNew);
        this.myPackageTextField.setEnabled(createNew);
        this.myExistentClassTF.setEnabled(!createNew);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNewClassName;
    }

    @Override
    protected void canRun() throws ConfigurationException {
        PsiNameHelper nameHelper = JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper();
        for (ParameterData parameterData : this.myParametersMap.values()) {
            if (!nameHelper.isIdentifier(parameterData.getFieldName())) {
                throw new ConfigurationException("'" + StringUtil.first((String)parameterData.getFieldName(), (int)10, (boolean)true) + "' is not a valid field name");
            }
            if (nameHelper.isIdentifier(parameterData.getSetterName())) continue;
            throw new ConfigurationException("'" + StringUtil.first((String)parameterData.getSetterName(), (int)10, (boolean)true) + "' is not a valid setter name");
        }
        if (this.myCreateBuilderClassRadioButton.isSelected()) {
            String className = this.myNewClassName.getText().trim();
            if (className.length() == 0 || !nameHelper.isQualifiedName(className)) {
                throw new ConfigurationException("'" + StringUtil.first((String)className, (int)10, (boolean)true) + "' is invalid builder class name");
            }
            String packageName = this.myPackageTextField.getText().trim();
            if (!nameHelper.isQualifiedName(packageName)) {
                throw new ConfigurationException("'" + StringUtil.last((CharSequence)packageName, (int)10, (boolean)true) + "' is invalid builder package name");
            }
        } else {
            String qualifiedName = this.myExistentClassTF.getText().trim();
            if (qualifiedName.length() == 0 || !nameHelper.isQualifiedName(qualifiedName)) {
                throw new ConfigurationException("'" + StringUtil.last((CharSequence)qualifiedName, (int)10, (boolean)true) + "' is invalid builder qualified class name");
            }
        }
    }

    private JScrollPane createTablePanel() {
        this.myTableModel = new MyTableModel();
        this.myTable = new Table((TableModel)this.myTableModel);
        this.myTable.setSurrendersFocusOnKeystroke(true);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        columnModel.getColumn(4).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows;
                for (int selectedRow : selectedRows = ReplaceConstructorWithBuilderDialog.this.myTable.getSelectedRows()) {
                    ParameterData parameterData = ReplaceConstructorWithBuilderDialog.this.myTableModel.getParamData(selectedRow);
                    if (parameterData.getDefaultValue() == null) continue;
                    parameterData.setInsertSetter(!parameterData.isInsertSetter());
                }
                TableUtil.selectRows((JTable)ReplaceConstructorWithBuilderDialog.this.myTable, (int[])selectedRows);
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(550, this.myTable.getRowHeight() * 12));
        this.myTable.getSelectionModel().setSelectionMode(2);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myTable);
        TitledBorder titledBorder = IdeBorderFactory.createTitledBorder((String)"Parameters to Pass to the Builder");
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 5, 5, 5);
        CompoundBorder border = BorderFactory.createCompoundBorder(titledBorder, emptyBorder);
        scrollPane.setBorder(border);
        return scrollPane;
    }

    private void createUIComponents() {
        DocumentAdapter adapter = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                ReplaceConstructorWithBuilderDialog.this.validateButtons();
            }
        };
        this.myPackageTextField = new PackageNameReferenceEditorCombo(((PsiJavaFile)this.myConstructors[0].getContainingFile()).getPackageName(), this.myProject, RECENT_KEYS, RefactoringBundle.message((String)"choose.destination.package"));
        ((EditorComboBox)this.myPackageTextField.getChildComponent()).getDocument().addDocumentListener((DocumentListener)adapter);
        this.myExistentClassTF = new ReferenceEditorComboWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)ReplaceConstructorWithBuilderDialog.this.getProject()).createWithInnerClassesScopeChooser("Select Builder Class", GlobalSearchScope.projectScope((Project)ReplaceConstructorWithBuilderDialog.this.myProject), null, null);
                String classText = ReplaceConstructorWithBuilderDialog.this.myExistentClassTF.getText();
                PsiClass currentClass = JavaPsiFacade.getInstance((Project)ReplaceConstructorWithBuilderDialog.this.myProject).findClass(classText, GlobalSearchScope.allScope((Project)ReplaceConstructorWithBuilderDialog.this.myProject));
                if (currentClass != null) {
                    chooser.selectClass(currentClass);
                }
                chooser.showDialog();
                PsiClass selectedClass = chooser.getSelectedClass();
                if (selectedClass != null) {
                    ReplaceConstructorWithBuilderDialog.this.myExistentClassTF.setText(selectedClass.getQualifiedName());
                }
            }
        }, "", PsiManager.getInstance((Project)this.myProject), true, RECENT_KEYS);
        ((EditorComboBox)this.myExistentClassTF.getChildComponent()).getDocument().addDocumentListener((DocumentListener)adapter);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 7;
        gridBagConstraints2.fill = 3;
        jPanel.add((Component)jPanel3, gridBagConstraints2);
        this.myCreateBuilderClassRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Create new");
        jRadioButton2.setMnemonic('C');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)jRadioButton2, gridBagConstraints3);
        this.myExistingBuilderClassRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use existing");
        jRadioButton.setMnemonic('U');
        jRadioButton.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 4;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jRadioButton, gridBagConstraints4);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.insets = new Insets(5, 20, 0, 0);
        jPanel.add((Component)jPanel4, gridBagConstraints5);
        this.myNewClassName = jTextField = new JTextField();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 1;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        jPanel4.add((Component)jTextField, gridBagConstraints6);
        JLabel jLabel = new JLabel();
        jLabel.setText("Builder class name");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(14);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 0;
        gridBagConstraints7.anchor = 17;
        jPanel4.add((Component)jLabel, gridBagConstraints7);
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.myPackageTextField;
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 3;
        gridBagConstraints8.fill = 2;
        jPanel4.add((Component)((Object)referenceEditorComboWithBrowseButton), gridBagConstraints8);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Package for new builder");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 2;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.insets = new Insets(5, 0, 0, 0);
        jPanel4.add((Component)jLabel2, gridBagConstraints9);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 5;
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.fill = 1;
        gridBagConstraints10.insets = new Insets(5, 20, 0, 0);
        jPanel.add((Component)jPanel5, gridBagConstraints10);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Builder class name (fully qualified)");
        jLabel3.setDisplayedMnemonic('B');
        jLabel3.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 0;
        gridBagConstraints11.anchor = 17;
        jPanel5.add((Component)jLabel3, gridBagConstraints11);
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton2 = this.myExistentClassTF;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 1;
        gridBagConstraints12.gridwidth = 2;
        gridBagConstraints12.fill = 2;
        jPanel5.add((Component)((Object)referenceEditorComboWithBrowseButton2), gridBagConstraints12);
        JPanel jPanel6 = new JPanel();
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 1;
        gridBagConstraints13.gridy = 0;
        gridBagConstraints13.weightx = 1.0;
        gridBagConstraints13.fill = 2;
        jPanel5.add((Component)jPanel6, gridBagConstraints13);
        jLabel.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 4) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return ReplaceConstructorWithBuilderDialog.this.myParametersMap.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ParameterData data = this.getParamData(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return data.getType().getCanonicalText() + " " + data.getParamName();
                }
                case 1: {
                    return data.getFieldName();
                }
                case 2: {
                    return data.getSetterName();
                }
                case 3: {
                    return data.getDefaultValue();
                }
                case 4: {
                    return !data.isInsertSetter();
                }
            }
            return null;
        }

        private ParameterData getParamData(int rowIndex) {
            return (ParameterData)ReplaceConstructorWithBuilderDialog.this.myParametersMap.get(new ArrayList(ReplaceConstructorWithBuilderDialog.this.myParametersMap.keySet()).get(rowIndex));
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ParameterData data = this.getParamData(rowIndex);
            switch (columnIndex) {
                case 1: {
                    data.setFieldName((String)aValue);
                    break;
                }
                case 2: {
                    data.setSetterName((String)aValue);
                    break;
                }
                case 3: {
                    data.setDefaultValue((String)aValue);
                    break;
                }
                case 4: {
                    data.setInsertSetter((Boolean)aValue == false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            ParameterData data;
            if (columnIndex == 0) {
                return false;
            }
            return columnIndex != 4 || (data = this.getParamData(rowIndex)).getDefaultValue() != null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Parameter";
                }
                case 1: {
                    return "Field Name";
                }
                case 2: {
                    return "Setter Name";
                }
                case 3: {
                    return "Default Value";
                }
                case 4: {
                    return "Optional Setter";
                }
            }
            assert (false) : "unknown column " + column;
            return null;
        }
    }
}

