/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;

public class AutomaticParametersRenamer
extends AutomaticRenamer {
    public AutomaticParametersRenamer(PsiParameter param, String newParamName) {
        PsiElement scope = param.getDeclarationScope();
        if (scope instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)scope;
            int parameterIndex = method.getParameterList().getParameterIndex(param);
            for (PsiMethod overrider : OverridingMethodsSearch.search((PsiMethod)method)) {
                PsiParameter inheritedParam = overrider.getParameterList().getParameters()[parameterIndex];
                if (Comparing.strEqual((String)inheritedParam.getName(), (String)newParamName)) continue;
                this.myElements.add(inheritedParam);
                this.suggestAllNames(inheritedParam.getName(), newParamName);
            }
        }
    }

    @Override
    public String getDialogTitle() {
        return "Rename parameters";
    }

    @Override
    public String getDialogDescription() {
        return "Rename parameter in hierarchy to:";
    }

    @Override
    public String entityName() {
        return "Parameter";
    }

    @Override
    public boolean isSelectedByDefault() {
        return true;
    }
}

