/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inheritanceToDelegation;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.inheritanceToDelegation.InheritanceToDelegationDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InheritanceToDelegationHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inheritanceToDelegation.InheritanceToDelegationHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"replace.inheritance.with.delegation.title");
    private static final MemberInfoBase.Filter<PsiMember> MEMBER_INFO_FILTER = new MemberInfoBase.Filter<PsiMember>(){

        public boolean includeMember(PsiMember element) {
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                return !method.hasModifierProperty("static") && !method.hasModifierProperty("private");
            }
            return element instanceof PsiClass && ((PsiClass)element).isInterface();
        }
    };

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationHandler.invoke must not be null");
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceInheritWithDelegat");
                return;
            }
            if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationHandler.invoke must not be null");
        }
        if (elements.length != 1) {
            return;
        }
        PsiClass aClass = (PsiClass)elements[0];
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (aClass.isInterface()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.is.interface", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceInheritWithDelegat");
            return;
        }
        if (aClass instanceof JspClass) {
            RefactoringMessageUtil.showNotSupportedForJspClassesError(project, editor, REFACTORING_NAME, "refactoring.replaceInheritWithDelegat");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        PsiClass[] bases = aClass.getSupers();
        String javaLangObject = "java.lang.Object";
        if (bases.length == 0 || bases.length == 1 && "java.lang.Object".equals(bases[0].getQualifiedName())) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.does.not.have.base.classes.or.interfaces", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceInheritWithDelegat");
            return;
        }
        HashMap basesToMemberInfos = new HashMap();
        for (PsiClass base : bases) {
            basesToMemberInfos.put((Object)base, InheritanceToDelegationHandler.createBaseClassMemberInfos(base));
        }
        new InheritanceToDelegationDialog(project, aClass, bases, (HashMap<PsiClass, Collection<MemberInfo>>)basesToMemberInfos).show();
    }

    private static List<MemberInfo> createBaseClassMemberInfos(PsiClass baseClass) {
        PsiClass deepestBase = RefactoringHierarchyUtil.getDeepestNonObjectBase(baseClass);
        LOG.assertTrue(deepestBase != null);
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(baseClass, MEMBER_INFO_FILTER);
        ArrayList<MemberInfo> memberInfoList = new ArrayList<MemberInfo>(memberInfoStorage.getClassMemberInfos(deepestBase));
        List memberInfos = memberInfoStorage.getMemberInfosList(deepestBase);
        for (MemberInfo memberInfo : memberInfos) {
            memberInfoList.add(memberInfo);
        }
        return memberInfoList;
    }
}

