/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.classMembers.DelegatingMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.extractclass.BackpointerUsageVisitor;
import com.intellij.refactoring.extractclass.ExtractClassProcessor;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.ui.MemberSelectionTable;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.VisibilityPanel;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

class ExtractClassDialog
extends RefactoringDialog
implements MemberInfoChangeListener<PsiMember, MemberInfo> {
    private final Map<MemberInfoBase<PsiMember>, PsiMember> myMember2CauseMap = new HashMap();
    private final PsiClass sourceClass;
    private final List<MemberInfo> memberInfo;
    private final JTextField classNameField;
    private final ReferenceEditorComboWithBrowseButton packageTextField;
    private final JTextField sourceClassTextField;
    private JCheckBox myGenerateAccessorsCb;
    private VisibilityPanel myVisibilityPanel;

    ExtractClassDialog(PsiClass sourceClass, PsiMember selectedMember) {
        super(sourceClass.getProject(), true);
        this.setModal(true);
        this.setTitle(RefactorJBundle.message("extract.class.title", new Object[0]));
        this.myVisibilityPanel = new VisibilityPanel(true, true);
        this.myVisibilityPanel.setVisibility(null);
        this.sourceClass = sourceClass;
        com.intellij.ui.DocumentAdapter docListener = new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                ExtractClassDialog.this.validateButtons();
            }
        };
        this.classNameField = new JTextField();
        PsiFile file = sourceClass.getContainingFile();
        String text = file instanceof PsiJavaFile ? ((PsiJavaFile)file).getPackageName() : "";
        this.packageTextField = new PackageNameReferenceEditorCombo(text, this.myProject, "ExtractClass.RECENTS_KEY", RefactorJBundle.message("choose.destination.package.label", new Object[0]));
        ((EditorComboBox)this.packageTextField.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                ExtractClassDialog.this.validateButtons();
            }
        });
        this.classNameField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)docListener);
        this.sourceClassTextField = new JTextField();
        MemberInfoBase.Filter<PsiMember> filter = new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                if (element instanceof PsiMethod) {
                    return !((PsiMethod)element).isConstructor() && ((PsiMethod)element).getBody() != null;
                }
                if (element instanceof PsiField) {
                    return true;
                }
                if (element instanceof PsiClass) {
                    return PsiTreeUtil.isAncestor((PsiElement)ExtractClassDialog.this.sourceClass, (PsiElement)element, (boolean)true);
                }
                return false;
            }
        };
        this.memberInfo = MemberInfo.extractClassMembers(this.sourceClass, filter, false);
        for (MemberInfo info : this.memberInfo) {
            if (!((PsiMember)info.getMember()).equals(selectedMember)) continue;
            info.setChecked(true);
        }
        super.init();
        this.sourceClassTextField.setText(sourceClass.getQualifiedName());
        this.validateButtons();
    }

    @Override
    protected void doAction() {
        List<PsiField> fields = this.getFieldsToExtract();
        List<PsiMethod> methods = this.getMethodsToExtract();
        List<PsiClass> classes = this.getClassesToExtract();
        String newClassName = this.getClassName();
        String packageName = this.getPackageName();
        ExtractClassProcessor processor = new ExtractClassProcessor(this.sourceClass, fields, methods, classes, packageName, newClassName, this.myVisibilityPanel.getVisibility(), this.isGenerateAccessors());
        this.invokeRefactoring(processor);
    }

    @Override
    protected void canRun() throws ConfigurationException {
        Project project = this.sourceClass.getProject();
        PsiNameHelper nameHelper = JavaPsiFacade.getInstance((Project)project).getNameHelper();
        List<PsiMethod> methods = this.getMethodsToExtract();
        List<PsiField> fields = this.getFieldsToExtract();
        List<PsiClass> innerClasses = this.getClassesToExtract();
        if (methods.isEmpty() && fields.isEmpty() && innerClasses.isEmpty()) {
            throw new ConfigurationException("Nothing found to extract");
        }
        String className = this.getClassName();
        if (className.length() == 0 || !nameHelper.isIdentifier(className)) {
            throw new ConfigurationException("'" + StringUtil.first((String)className, (int)10, (boolean)true) + "' is invalid extracted class name");
        }
        String packageName = this.getPackageName();
        if (packageName.length() == 0 || !nameHelper.isQualifiedName(packageName)) {
            throw new ConfigurationException("'" + StringUtil.last((CharSequence)packageName, (int)10, (boolean)true) + "' is invalid extracted class package name");
        }
    }

    @NotNull
    public String getPackageName() {
        String string = this.packageTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/extractclass/ExtractClassDialog.getPackageName must not return null");
        }
        return string;
    }

    @NotNull
    public String getClassName() {
        String string = this.classNameField.getText().trim();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/extractclass/ExtractClassDialog.getClassName must not return null");
        }
        return string;
    }

    public List<PsiField> getFieldsToExtract() {
        return this.getMembersToExtract(true, PsiField.class);
    }

    public <T> List<T> getMembersToExtract(boolean checked, Class<T> memberClass) {
        ArrayList<PsiMember> out = new ArrayList<PsiMember>();
        for (MemberInfo info : this.memberInfo) {
            PsiMember member;
            if (checked && !info.isChecked() || !checked && info.isChecked() || !memberClass.isAssignableFrom((member = (PsiMember)info.getMember()).getClass())) continue;
            out.add(member);
        }
        return out;
    }

    public List<PsiMethod> getMethodsToExtract() {
        return this.getMembersToExtract(true, PsiMethod.class);
    }

    public List<PsiClass> getClassesToExtract() {
        return this.getMembersToExtract(true, PsiClass.class);
    }

    public List<PsiClassInitializer> getClassInitializersToExtract() {
        return this.getMembersToExtract(true, PsiClassInitializer.class);
    }

    public boolean isGenerateAccessors() {
        return this.myGenerateAccessorsCb.isSelected();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.ExtractClass";
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createVerticalBox();
        this.sourceClassTextField.setEditable(false);
        JPanel sourceClassPanel = new JPanel(new BorderLayout());
        sourceClassPanel.add((Component)new JLabel(RefactorJBundle.message("extract.class.from.label", new Object[0])), "North");
        sourceClassPanel.add((Component)this.sourceClassTextField, "Center");
        box.add(sourceClassPanel);
        box.add(Box.createVerticalStrut(10));
        JLabel classNameLabel = new JLabel(RefactorJBundle.message("name.for.new.class.label", new Object[0]));
        classNameLabel.setLabelFor(this.classNameField);
        classNameLabel.setDisplayedMnemonic('N');
        JPanel classNamePanel = new JPanel(new BorderLayout());
        classNamePanel.add((Component)classNameLabel, "North");
        classNamePanel.add((Component)this.classNameField, "Center");
        box.add(classNamePanel);
        box.add(Box.createVerticalStrut(5));
        JPanel packageNamePanel = new JPanel(new BorderLayout());
        JLabel packageLabel = new JLabel(RefactorJBundle.message("package.for.new.class.label", new Object[0]));
        packageLabel.setLabelFor((Component)((Object)this.packageTextField));
        packageLabel.setDisplayedMnemonic('P');
        packageNamePanel.add((Component)packageLabel, "North");
        packageNamePanel.add((Component)((Object)this.packageTextField), "Center");
        box.add(packageNamePanel);
        box.add(Box.createVerticalStrut(10));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "Center");
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        MemberSelectionPanel memberSelectionPanel = new MemberSelectionPanel(RefactorJBundle.message("members.to.extract.label", new Object[0]), this.memberInfo, null);
        MemberSelectionTable table = memberSelectionPanel.getTable();
        table.setMemberInfoModel(new DelegatingMemberInfoModel<PsiMember, MemberInfo>(table.getMemberInfoModel()){

            @Override
            public Boolean isFixedAbstract(MemberInfo member) {
                return Boolean.TRUE;
            }

            @Override
            public int checkForProblems(@NotNull MemberInfo member) {
                if (member == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractclass/ExtractClassDialog$4.checkForProblems must not be null");
                }
                PsiMember cause = this.getCause(member);
                if (member.isChecked() && cause != null) {
                    return 2;
                }
                if (!member.isChecked() && cause != null) {
                    return 1;
                }
                return 0;
            }

            @Override
            public String getTooltipText(MemberInfo member) {
                PsiMember cause = this.getCause(member);
                if (cause != null) {
                    String presentation = SymbolPresentationUtil.getSymbolPresentableText((PsiElement)cause);
                    if (member.isChecked()) {
                        return "Depends on " + presentation + " from " + ExtractClassDialog.this.sourceClass.getName();
                    }
                    String className = ExtractClassDialog.this.getClassName();
                    return "Depends on " + presentation + " from new class" + (className.length() > 0 ? ": " + className : "");
                }
                return null;
            }

            private PsiMember getCause(MemberInfo member) {
                PsiMember cause = (PsiMember)ExtractClassDialog.this.myMember2CauseMap.get((Object)member);
                if (cause != null) {
                    return cause;
                }
                BackpointerUsageVisitor visitor = member.isChecked() ? new BackpointerUsageVisitor(ExtractClassDialog.this.getFieldsToExtract(), ExtractClassDialog.this.getClassesToExtract(), ExtractClassDialog.this.getMethodsToExtract(), ExtractClassDialog.this.sourceClass) : new BackpointerUsageVisitor(ExtractClassDialog.this.getMembersToExtract(false, PsiField.class), ExtractClassDialog.this.getMembersToExtract(false, PsiClass.class), ExtractClassDialog.this.getMembersToExtract(false, PsiMethod.class), ExtractClassDialog.this.sourceClass, false);
                ((PsiMember)member.getMember()).accept((PsiElementVisitor)visitor);
                cause = visitor.getCause();
                ExtractClassDialog.this.myMember2CauseMap.put(member, cause);
                return cause;
            }
        });
        panel.add((Component)memberSelectionPanel, "Center");
        table.addMemberInfoChangeListener(this);
        this.myGenerateAccessorsCb = new JCheckBox("Generate accessors");
        this.myGenerateAccessorsCb.setMnemonic('G');
        panel.add((Component)this.myGenerateAccessorsCb, "South");
        panel.add((Component)this.myVisibilityPanel, "East");
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classNameField;
    }

    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactorj.extractClass");
    }

    public void memberInfoChanged(MemberInfoChange memberInfoChange) {
        this.validateButtons();
        this.myMember2CauseMap.clear();
    }
}

