/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectDialog;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectViewDescriptor;
import com.intellij.refactoring.extractMethodObject.MethodToMoveUsageInfo;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodObjectProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExtractMethodObjectProcessor.class.getName()));
    @NonNls
    public static final String REFACTORING_NAME = "Extract Method Object";
    private final PsiElementFactory myElementFactory;
    private final MyExtractMethodProcessor myExtractProcessor;
    private boolean myCreateInnerClass = true;
    private String myInnerClassName;
    private boolean myMultipleExitPoints;
    private PsiField[] myOutputFields;
    private PsiMethod myInnerMethod;
    private boolean myMadeStatic = false;
    private final Set<MethodToMoveUsageInfo> myUsages = new HashSet<MethodToMoveUsageInfo>();
    private PsiClass myInnerClass;

    public ExtractMethodObjectProcessor(Project project, Editor editor, PsiElement[] elements, String innerClassName) {
        super(project);
        this.myInnerClassName = innerClassName;
        this.myExtractProcessor = new MyExtractMethodProcessor(project, editor, elements, null, REFACTORING_NAME, innerClassName, "refactoring.extractMethodObject");
        this.myElementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new ExtractMethodObjectViewDescriptor(this.getMethod());
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        PsiReference[] refs;
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (PsiReference ref : refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.getMethod(), (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
            PsiElement element = ref.getElement();
            if (element == null || !element.isValid()) continue;
            result.add(new UsageInfo(element));
        }
        if (this.isCreateInnerClass()) {
            final HashSet usedMethods = new HashSet();
            this.getMethod().accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                    super.visitMethodCallExpression(expression);
                    PsiMethod method = expression.resolveMethod();
                    if (method != null) {
                        usedMethods.add(method);
                    }
                }
            });
            for (PsiMethod usedMethod : usedMethods) {
                if (!usedMethod.getModifierList().hasModifierProperty("private")) continue;
                PsiMethod toMove = usedMethod;
                for (PsiReference reference : ReferencesSearch.search((PsiElement)usedMethod)) {
                    if (PsiTreeUtil.isAncestor((PsiElement)this.getMethod(), (PsiElement)reference.getElement(), (boolean)false)) continue;
                    toMove = null;
                    break;
                }
                if (toMove == null) continue;
                this.myUsages.add(new MethodToMoveUsageInfo(toMove));
            }
        }
        UsageInfo[] usageInfos = result.toArray(new UsageInfo[result.size()]);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(usageInfos);
        if (usageInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor.findUsages must not return null");
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        try {
            if (this.isCreateInnerClass()) {
                this.myInnerClass = (PsiClass)this.getMethod().getContainingClass().add((PsiElement)this.myElementFactory.createClass(this.getInnerClassName()));
                boolean isStatic = this.copyMethodModifiers() && this.notHasGeneratedFields();
                for (UsageInfo usage : usages) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)usage.getElement(), PsiMethodCallExpression.class);
                    if (methodCallExpression == null) continue;
                    this.replaceMethodCallExpression(this.inferTypeArguments(methodCallExpression), methodCallExpression);
                }
                PsiParameter[] parameters = this.getMethod().getParameterList().getParameters();
                if (parameters.length > 0) {
                    this.createInnerClassConstructor(parameters);
                } else if (isStatic) {
                    PsiMethod copy = (PsiMethod)this.getMethod().copy();
                    copy.setName("invoke");
                    this.myInnerClass.add((PsiElement)copy);
                    if (this.myMultipleExitPoints) {
                        this.addOutputVariableFieldsWithGetters();
                    }
                    return;
                }
                if (this.myMultipleExitPoints) {
                    this.addOutputVariableFieldsWithGetters();
                }
                this.copyMethodWithoutParameters();
                this.copyMethodTypeParameters();
            } else {
                for (UsageInfo usage : usages) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)usage.getElement(), PsiMethodCallExpression.class);
                    if (methodCallExpression == null) continue;
                    methodCallExpression.replace((PsiElement)this.processMethodDeclaration(methodCallExpression.getArgumentList()));
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void moveUsedMethodsToInner() {
        if (!this.myUsages.isEmpty()) {
            ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
            for (MethodToMoveUsageInfo usage : this.myUsages) {
                memberInfos.add(new MemberInfo((PsiMember)((PsiMethod)usage.getElement())));
            }
            final MemberSelectionPanel panel = new MemberSelectionPanel("Methods to move to the extracted class", memberInfos, null);
            DialogWrapper dlg = new DialogWrapper(this.myProject, false){
                {
                    super(x0, x1);
                    this.init();
                    this.setTitle("Move Methods Used in Extracted Block Only");
                }

                protected JComponent createCenterPanel() {
                    return panel;
                }
            };
            dlg.show();
            if (dlg.isOK()) {
                for (MemberInfo memberInfo : panel.getTable().getSelectedMemberInfos()) {
                    if (!memberInfo.isChecked()) continue;
                    this.myInnerClass.add(((PsiMember)memberInfo.getMember()).copy());
                    ((PsiMember)memberInfo.getMember()).delete();
                }
            }
        }
    }

    private void addOutputVariableFieldsWithGetters() throws IncorrectOperationException {
        HashMap<String, String> var2FieldNames = new HashMap<String, String>();
        Object[] outputVariables = this.myExtractProcessor.getOutputVariables();
        for (int i = 0; i < outputVariables.length; ++i) {
            PsiField field;
            PsiVariable var = outputVariables[i];
            PsiField outputField = this.myOutputFields[i];
            String name = this.getPureName(var);
            LOG.assertTrue(name != null);
            if (outputField != null) {
                var2FieldNames.put(var.getName(), outputField.getName());
                this.myInnerClass.add((PsiElement)outputField);
            }
            LOG.assertTrue((field = PropertyUtil.findPropertyField((Project)this.myProject, (PsiClass)this.myInnerClass, (String)name, (boolean)false)) != null, (Object)("i:" + i + "; output variables: " + Arrays.toString(outputVariables) + "; parameters: " + Arrays.toString(this.getMethod().getParameterList().getParameters()) + "; output field: " + outputField));
            this.myInnerClass.add((PsiElement)PropertyUtil.generateGetterPrototype((PsiField)field));
        }
        PsiParameter[] params = this.getMethod().getParameterList().getParameters();
        ParameterInfoImpl[] infos = new ParameterInfoImpl[params.length];
        for (int i = 0; i < params.length; ++i) {
            PsiParameter param = params[i];
            infos[i] = new ParameterInfoImpl(i, param.getName(), param.getType());
        }
        ChangeSignatureProcessor cp = new ChangeSignatureProcessor(this.myProject, this.getMethod(), false, null, this.getMethod().getName(), (PsiType)new PsiImmediateClassType(this.myInnerClass, PsiSubstitutor.EMPTY), infos);
        cp.run();
        PsiCodeBlock body = this.getMethod().getBody();
        LOG.assertTrue(body != null);
        ArrayList vars = new ArrayList();
        final LinkedHashMap replacementMap = new LinkedHashMap();
        body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((PsiVariable[])outputVariables, vars){
            final /* synthetic */ PsiVariable[] val$outputVariables;
            final /* synthetic */ List val$vars;
            {
                this.val$outputVariables = psiVariableArray;
                this.val$vars = list;
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                super.visitReturnStatement(statement);
                try {
                    replacementMap.put(statement, ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText("return this;", (PsiElement)statement));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            public void visitDeclarationStatement(PsiDeclarationStatement statement) {
                PsiElement[] declaredElements;
                super.visitDeclarationStatement(statement);
                for (PsiElement declaredElement : declaredElements = statement.getDeclaredElements()) {
                    if (!(declaredElement instanceof PsiVariable)) continue;
                    for (PsiVariable variable : this.val$outputVariables) {
                        PsiLocalVariable var = (PsiLocalVariable)declaredElement;
                        if (!Comparing.strEqual((String)var.getName(), (String)variable.getName())) continue;
                        PsiExpression initializer = var.getInitializer();
                        if (initializer == null) {
                            replacementMap.put(statement, null);
                            continue;
                        }
                        replacementMap.put(var, var);
                    }
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                PsiElement resolved = expression.resolve();
                if (resolved instanceof PsiLocalVariable) {
                    String var = ((PsiLocalVariable)resolved).getName();
                    for (PsiVariable variable : this.val$outputVariables) {
                        if (!Comparing.strEqual((String)variable.getName(), (String)var)) continue;
                        this.val$vars.add((PsiLocalVariable)resolved);
                        break;
                    }
                }
            }
        });
        for (PsiLocalVariable var : vars) {
            String fieldName = (String)var2FieldNames.get(var.getName());
            for (PsiReference reference : ReferencesSearch.search((PsiElement)var)) {
                reference.handleElementRename(fieldName);
            }
        }
        for (PsiElement statement : replacementMap.keySet()) {
            PsiElement replacement = (PsiElement)replacementMap.get(statement);
            if (replacement != null) {
                if (statement instanceof PsiLocalVariable) {
                    PsiLocalVariable variable = (PsiLocalVariable)statement;
                    variable.normalizeDeclaration();
                    PsiExpression initializer = variable.getInitializer();
                    LOG.assertTrue(initializer != null);
                    PsiStatement assignmentStatement = this.myElementFactory.createStatementFromText((String)var2FieldNames.get(variable.getName()) + " = " + initializer.getText() + ";", statement);
                    PsiDeclarationStatement declaration = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiDeclarationStatement.class);
                    LOG.assertTrue(declaration != null);
                    declaration.replace((PsiElement)assignmentStatement);
                    continue;
                }
                statement.replace(replacement);
                continue;
            }
            statement.delete();
        }
    }

    private String getPureName(PsiVariable var) {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        return var instanceof PsiLocalVariable ? styleManager.variableNameToPropertyName(var.getName(), VariableKind.LOCAL_VARIABLE) : styleManager.variableNameToPropertyName(var.getName(), VariableKind.PARAMETER);
    }

    public PsiExpression processMethodDeclaration(PsiExpressionList expressionList) throws IncorrectOperationException {
        if (this.isCreateInnerClass()) {
            String typeArguments = this.getMethod().hasTypeParameters() ? "<" + StringUtil.join(Arrays.asList(this.getMethod().getTypeParameters()), (Function)new Function<PsiTypeParameter, String>(){

                public String fun(PsiTypeParameter typeParameter) {
                    String typeParameterName = typeParameter.getName();
                    LOG.assertTrue(typeParameterName != null);
                    return typeParameterName;
                }
            }, (String)", ") + ">" : "";
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)this.myElementFactory.createExpressionFromText("invoke" + expressionList.getText(), null);
            return this.replaceMethodCallExpression(typeArguments, methodCallExpression);
        }
        String paramsDeclaration = this.getMethod().getParameterList().getText();
        PsiType returnType = this.getMethod().getReturnType();
        LOG.assertTrue(returnType != null);
        PsiCodeBlock methodBody = this.getMethod().getBody();
        LOG.assertTrue(methodBody != null);
        return this.myElementFactory.createExpressionFromText("new Object(){ \nprivate " + returnType.getPresentableText() + " " + this.myInnerClassName + paramsDeclaration + methodBody.getText() + "}." + this.myInnerClassName + expressionList.getText(), null);
    }

    private PsiMethodCallExpression replaceMethodCallExpression(String inferredTypeArguments, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        String newReplacement;
        String staticqualifier = this.getMethod().hasModifierProperty("static") && this.notHasGeneratedFields() ? this.getInnerClassName() : null;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        if (staticqualifier != null) {
            newReplacement = argumentList.getExpressions().length > 0 ? "new " + staticqualifier + inferredTypeArguments + argumentList.getText() + "." : staticqualifier + ".";
        } else {
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            String qualifier = qualifierExpression != null ? qualifierExpression.getText() + "." : "";
            newReplacement = qualifier + "new " + this.getInnerClassName() + inferredTypeArguments + argumentList.getText() + ".";
        }
        return (PsiMethodCallExpression)methodCallExpression.replace((PsiElement)this.myElementFactory.createExpressionFromText(newReplacement + "invoke()", null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private String inferTypeArguments(PsiMethodCallExpression methodCallExpression) {
        String string;
        PsiReferenceParameterList list = methodCallExpression.getMethodExpression().getParameterList();
        if (list != null && list.getTypeArguments().length > 0) {
            String string2 = list.getText();
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor.inferTypeArguments must not return null");
        }
        PsiTypeParameter[] methodTypeParameters = this.getMethod().getTypeParameters();
        if (methodTypeParameters.length <= 0) return "";
        ArrayList<String> typeSignature = new ArrayList<String>();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)this.getMethod().getProject()).getResolveHelper();
        for (PsiTypeParameter typeParameter : methodTypeParameters) {
            PsiType type = resolveHelper.inferTypeForMethodTypeParameter(typeParameter, this.getMethod().getParameterList().getParameters(), methodCallExpression.getArgumentList().getExpressions(), PsiSubstitutor.EMPTY, (PsiElement)methodCallExpression, false);
            if (type == null) return "";
            if (PsiType.NULL.equals(type)) {
                return "";
            }
            typeSignature.add(type.getPresentableText());
        }
        String string3 = "<" + StringUtil.join(typeSignature, (String)", ") + ">";
        string = string3;
        if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor.inferTypeArguments must not return null");
        return string;
    }

    @Override
    protected String getCommandName() {
        return REFACTORING_NAME;
    }

    private boolean copyMethodModifiers() throws IncorrectOperationException {
        PsiModifierList methodModifierList = this.getMethod().getModifierList();
        PsiModifierList innerClassModifierList = this.myInnerClass.getModifierList();
        LOG.assertTrue(innerClassModifierList != null);
        innerClassModifierList.setModifierProperty(VisibilityUtil.getVisibilityModifier((PsiModifierList)methodModifierList), true);
        boolean isStatic = methodModifierList.hasModifierProperty("static");
        innerClassModifierList.setModifierProperty("static", isStatic);
        return isStatic;
    }

    private void copyMethodTypeParameters() throws IncorrectOperationException {
        PsiTypeParameterList typeParameterList = this.myInnerClass.getTypeParameterList();
        LOG.assertTrue(typeParameterList != null);
        for (PsiTypeParameter parameter : this.getMethod().getTypeParameters()) {
            typeParameterList.add((PsiElement)parameter);
        }
    }

    private void copyMethodWithoutParameters() throws IncorrectOperationException {
        PsiMethod newMethod = this.myElementFactory.createMethod("invoke", this.getMethod().getReturnType());
        newMethod.getThrowsList().replace((PsiElement)this.getMethod().getThrowsList());
        PsiCodeBlock replacedMethodBody = newMethod.getBody();
        LOG.assertTrue(replacedMethodBody != null);
        PsiCodeBlock methodBody = this.getMethod().getBody();
        LOG.assertTrue(methodBody != null);
        replacedMethodBody.replace((PsiElement)methodBody);
        PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"static", (this.myInnerClass.hasModifierProperty("static") && this.notHasGeneratedFields() ? 1 : 0) != 0);
        this.myInnerMethod = (PsiMethod)this.myInnerClass.add((PsiElement)newMethod);
    }

    private boolean notHasGeneratedFields() {
        return !this.myMultipleExitPoints && this.getMethod().getParameterList().getParametersCount() == 0;
    }

    private void createInnerClassConstructor(PsiParameter[] parameters) throws IncorrectOperationException {
        PsiMethod constructor = this.myElementFactory.createConstructor();
        PsiParameterList parameterList = constructor.getParameterList();
        for (PsiParameter parameter : parameters) {
            PsiModifierList parameterModifierList = parameter.getModifierList();
            LOG.assertTrue(parameterModifierList != null);
            String parameterName = parameter.getName();
            LOG.assertTrue(parameterName != null);
            PsiParameter parm = this.myElementFactory.createParameter(parameterName, parameter.getType());
            if (CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS) {
                PsiModifierList modifierList = parm.getModifierList();
                LOG.assertTrue(modifierList != null);
                modifierList.setModifierProperty("final", true);
            }
            parameterList.add((PsiElement)parm);
            PsiField field = this.createField(parm, constructor, parameterModifierList.hasModifierProperty("final"));
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter)) {
                reference.handleElementRename(field.getName());
            }
        }
        this.myInnerClass.add((PsiElement)constructor);
    }

    private PsiField createField(PsiParameter parameter, PsiMethod constructor, boolean isFinal) {
        String parameterName = parameter.getName();
        PsiType type = parameter.getType();
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).toArrayType();
        }
        try {
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.getMethod().getProject());
            String fieldName = styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)styleManager.variableNameToPropertyName((String)parameterName, (VariableKind)VariableKind.PARAMETER), null, (PsiType)type).names[0];
            PsiField field = this.myElementFactory.createField(fieldName, type);
            PsiModifierList modifierList = field.getModifierList();
            LOG.assertTrue(modifierList != null);
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"org.jetbrains.annotations.Nullable", (boolean)false)) {
                modifierList.addAfter((PsiElement)this.myElementFactory.createAnnotationFromText("@org.jetbrains.annotations.Nullable", (PsiElement)field), null);
            }
            modifierList.setModifierProperty("final", isFinal);
            PsiCodeBlock methodBody = constructor.getBody();
            LOG.assertTrue(methodBody != null);
            String stmtText = Comparing.strEqual((String)parameterName, (String)fieldName) ? "this." + fieldName + " = " + parameterName + ";" : fieldName + " = " + parameterName + ";";
            PsiStatement assignmentStmt = this.myElementFactory.createStatementFromText(stmtText, (PsiElement)methodBody);
            assignmentStmt = (PsiStatement)CodeStyleManager.getInstance((Project)constructor.getProject()).reformat((PsiElement)assignmentStmt);
            methodBody.add((PsiElement)assignmentStmt);
            field = (PsiField)this.myInnerClass.add((PsiElement)field);
            return field;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected void changeInstanceAccess(Project project) throws IncorrectOperationException {
        if (this.myMadeStatic) {
            PsiReference[] refs;
            for (PsiReference ref : refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.myInnerMethod, (SearchScope)GlobalSearchScope.projectScope((Project)project), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                PsiElement element = ref.getElement();
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
                if (callExpression == null) continue;
                this.replaceMethodCallExpression(this.inferTypeArguments(callExpression), callExpression);
            }
        }
    }

    public PsiMethod getMethod() {
        return this.myExtractProcessor.getExtractedMethod();
    }

    public String getInnerClassName() {
        return this.myInnerClassName;
    }

    public void setCreateInnerClass(boolean createInnerClass) {
        this.myCreateInnerClass = createInnerClass;
    }

    public boolean isCreateInnerClass() {
        return this.myCreateInnerClass;
    }

    public MyExtractMethodProcessor getExtractProcessor() {
        return this.myExtractProcessor;
    }

    static /* synthetic */ PsiField[] access$502(ExtractMethodObjectProcessor x0, PsiField[] x1) {
        x0.myOutputFields = x1;
        return x1;
    }

    public class MyExtractMethodProcessor
    extends ExtractMethodProcessor {
        public MyExtractMethodProcessor(Project project, Editor editor, PsiElement[] elements, PsiType forcedReturnType, String refactoringName, String initialMethodName, String helpId) {
            super(project, editor, elements, forcedReturnType, refactoringName, initialMethodName, helpId);
        }

        @Override
        protected void apply(AbstractExtractDialog dialog) {
            super.apply(dialog);
            ExtractMethodObjectProcessor.this.myCreateInnerClass = ((ExtractMethodObjectDialog)dialog).createInnerClass();
            ExtractMethodObjectProcessor.this.myInnerClassName = ExtractMethodObjectProcessor.this.myCreateInnerClass ? StringUtil.capitalize((String)dialog.getChosenMethodName()) : dialog.getChosenMethodName();
        }

        @Override
        protected AbstractExtractDialog createExtractMethodDialog(boolean direct) {
            return new ExtractMethodObjectDialog(this.myProject, this.myTargetClass, this.myInputVariables, this.myReturnType, this.myTypeParameterList, (PsiType[])this.myThrownExceptions, this.myStatic, this.myCanBeStatic, this.myElements, ExtractMethodObjectProcessor.this.myMultipleExitPoints);
        }

        @Override
        protected boolean checkOutputVariablesCount() {
            ExtractMethodObjectProcessor.this.myMultipleExitPoints = super.checkOutputVariablesCount();
            ExtractMethodObjectProcessor.access$502(ExtractMethodObjectProcessor.this, new PsiField[this.myOutputVariables.length]);
            for (int i = 0; i < this.myOutputVariables.length; ++i) {
                PsiVariable variable = this.myOutputVariables[i];
                if (this.myInputVariables.contains(variable)) continue;
                JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
                String fieldName = styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)((ExtractMethodObjectProcessor)ExtractMethodObjectProcessor.this).getPureName((PsiVariable)variable), null, (PsiType)variable.getType()).names[0];
                try {
                    ((ExtractMethodObjectProcessor)ExtractMethodObjectProcessor.this).myOutputFields[i] = ExtractMethodObjectProcessor.this.myElementFactory.createField(fieldName, variable.getType());
                    continue;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            return !ExtractMethodObjectProcessor.this.myCreateInnerClass && ExtractMethodObjectProcessor.this.myMultipleExitPoints;
        }

        @Override
        public PsiElement processMatch(Match match) throws IncorrectOperationException {
            PsiExpression expression;
            PsiMethodCallExpression methodCallExpression;
            PsiElement element;
            block5: {
                block6: {
                    PsiExpression psiExpression;
                    block7: {
                        block4: {
                            boolean makeStatic = ExtractMethodObjectProcessor.this.myInnerMethod != null && RefactoringUtil.isInStaticContext(match.getMatchStart(), this.getExtractedMethod().getContainingClass());
                            element = super.processMatch(match);
                            if (makeStatic) {
                                ExtractMethodObjectProcessor.this.myMadeStatic = true;
                                PsiModifierList modifierList = ExtractMethodObjectProcessor.this.myInnerMethod.getContainingClass().getModifierList();
                                LOG.assertTrue(modifierList != null);
                                modifierList.setModifierProperty("static", true);
                                PsiUtil.setModifierProperty((PsiModifierListOwner)ExtractMethodObjectProcessor.this.myInnerMethod, (String)"static", (boolean)true);
                            }
                            methodCallExpression = null;
                            if (!(element instanceof PsiMethodCallExpression)) break block4;
                            methodCallExpression = (PsiMethodCallExpression)element;
                            break block5;
                        }
                        if (!(element instanceof PsiExpressionStatement)) break block6;
                        expression = ((PsiExpressionStatement)element).getExpression();
                        if (!(expression instanceof PsiMethodCallExpression)) break block7;
                        methodCallExpression = (PsiMethodCallExpression)expression;
                        break block5;
                    }
                    if (!(expression instanceof PsiAssignmentExpression) || !((psiExpression = ((PsiAssignmentExpression)expression).getRExpression()) instanceof PsiMethodCallExpression)) break block5;
                    methodCallExpression = (PsiMethodCallExpression)psiExpression;
                    break block5;
                }
                if (element instanceof PsiDeclarationStatement) {
                    PsiElement[] declaredElements;
                    for (PsiElement declaredElement : declaredElements = ((PsiDeclarationStatement)element).getDeclaredElements()) {
                        PsiExpression initializer;
                        if (!(declaredElement instanceof PsiLocalVariable) || !((initializer = ((PsiLocalVariable)declaredElement).getInitializer()) instanceof PsiMethodCallExpression)) continue;
                        methodCallExpression = (PsiMethodCallExpression)initializer;
                        break;
                    }
                }
            }
            if (methodCallExpression == null) {
                return element;
            }
            expression = ExtractMethodObjectProcessor.this.processMethodDeclaration(methodCallExpression.getArgumentList());
            return methodCallExpression.replace((PsiElement)expression);
        }

        public PsiVariable[] getOutputVariables() {
            return this.myOutputVariables;
        }

        @Override
        protected void declareNecessaryVariablesAfterCall(PsiVariable outputVariable) throws IncorrectOperationException {
            if (ExtractMethodObjectProcessor.this.myMultipleExitPoints) {
                String object = StringUtil.decapitalize((String)ExtractMethodObjectProcessor.this.myInnerClassName);
                PsiStatement methodCallStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.getMethodCall(), PsiStatement.class);
                LOG.assertTrue(methodCallStatement != null);
                methodCallStatement.replace((PsiElement)ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(ExtractMethodObjectProcessor.this.myInnerClassName + " " + object + " = " + this.getMethodCall().getText() + ";", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod));
                List<PsiVariable> usedVariables = this.myControlFlowWrapper.getUsedVariables();
                Collection<ControlFlowUtil.VariableInfo> reassigned = this.myControlFlowWrapper.getInitializedTwice();
                for (PsiVariable variable : usedVariables) {
                    String name = variable.getName();
                    LOG.assertTrue(name != null);
                    PsiStatement st = null;
                    if (this.isDeclaredInside(variable)) {
                        st = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(variable.getType().getCanonicalText() + " " + name + " = " + object + "." + PropertyUtil.suggestGetterName((String)ExtractMethodObjectProcessor.this.getPureName(variable), (PsiType)variable.getType()) + "();", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod);
                        if (reassigned.contains(new ControlFlowUtil.VariableInfo(variable, null))) {
                            PsiElement[] psiElements = ((PsiDeclarationStatement)st).getDeclaredElements();
                            assert (psiElements.length > 0);
                            PsiVariable var = (PsiVariable)psiElements[0];
                            PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)false);
                        }
                    } else if (ArrayUtil.find((Object[])this.myOutputVariables, (Object)variable) != -1) {
                        st = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(name + " = " + object + "." + PropertyUtil.suggestGetterName((String)ExtractMethodObjectProcessor.this.getPureName(variable), (PsiType)variable.getType()) + "();", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod);
                    }
                    if (st == null) continue;
                    this.addToMethodCallLocation((PsiElement)st);
                }
            } else {
                super.declareNecessaryVariablesAfterCall(outputVariable);
            }
        }
    }
}

