/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractInterface;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperProcessor;
import com.intellij.refactoring.ui.YesNoPreviewUsagesDialog;

public class ExtractClassUtil {
    public static void askAndTurnRefsToSuper(final Project project, PsiClass aClass, PsiClass aSuperClass) {
        final SmartPsiElementPointer classPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)aClass);
        final SmartPsiElementPointer interfacePointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)aSuperClass);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                PsiElement classElement = classPointer.getElement();
                PsiElement interfaceElement = interfacePointer.getElement();
                if (classElement instanceof PsiClass && interfaceElement instanceof PsiClass) {
                    PsiClass superClass = (PsiClass)interfaceElement;
                    String superClassName = superClass.getName();
                    String className = ((PsiClass)classElement).getName();
                    String createdString = superClass.isInterface() ? RefactoringBundle.message((String)"interface.has.been.successfully.created", (Object[])new Object[]{superClassName}) : RefactoringBundle.message((String)"class.has.been.successfully.created", (Object[])new Object[]{superClassName});
                    String message = createdString + "\n" + RefactoringBundle.message((String)"use.super.references.prompt", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), className, superClassName});
                    YesNoPreviewUsagesDialog dialog = new YesNoPreviewUsagesDialog(RefactoringBundle.message((String)"analyze.and.replace.usages"), message, JavaRefactoringSettings.getInstance().EXTRACT_INTERFACE_PREVIEW_USAGES, null, project);
                    dialog.show();
                    if (dialog.isOK()) {
                        boolean isPreviewUsages;
                        JavaRefactoringSettings.getInstance().EXTRACT_INTERFACE_PREVIEW_USAGES = isPreviewUsages = dialog.isPreviewUsages();
                        TurnRefsToSuperProcessor processor = new TurnRefsToSuperProcessor(project, (PsiClass)classElement, (PsiClass)interfaceElement, true);
                        processor.setPreviewUsages(isPreviewUsages);
                        processor.run();
                    }
                }
            }
        });
    }
}

