/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public class ChangeSignatureTargetUtil {
    private ChangeSignatureTargetUtil() {
    }

    @Nullable
    public static PsiMember findTargetMember(PsiFile file, Editor editor) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiTypeParameterList typeParameterList;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameterList.class) != null) {
            return (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        }
        PsiMethodCallExpression expression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        if (expression != null) {
            assert (element != null);
            PsiExpression qualifierExpression = expression.getMethodExpression().getQualifierExpression();
            if (PsiTreeUtil.isAncestor((PsiElement)qualifierExpression, (PsiElement)element, (boolean)false)) {
                PsiElement parent;
                PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)qualifierExpression, PsiExpressionList.class);
                if (expressionList != null && (parent = expressionList.getParent()) instanceof PsiMethodCallExpression) {
                    return ((PsiMethodCallExpression)parent).resolveMethod();
                }
            } else {
                return expression.resolveMethod();
            }
        }
        if ((typeParameterList = (PsiTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeParameterList.class)) != null) {
            return (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)typeParameterList, PsiMember.class);
        }
        PsiReferenceParameterList referenceParameterList = (PsiReferenceParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiReferenceParameterList.class);
        if (referenceParameterList != null && (referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiJavaCodeReferenceElement.class)) != null) {
            PsiElement resolved = referenceElement.resolve();
            if (resolved instanceof PsiClass) {
                return (PsiMember)resolved;
            }
            if (resolved instanceof PsiMethod) {
                return (PsiMember)resolved;
            }
        }
        return null;
    }
}

