/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallReferenceUsageInfo;
import com.intellij.refactoring.changeSignature.CallerUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeInfoImpl;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureViewDescriptor;
import com.intellij.refactoring.changeSignature.MethodCallUsageInfo;
import com.intellij.refactoring.changeSignature.NewParameterCollidesWithLocalUsageInfo;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.PsiCallReference;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.rename.JavaUnresolvableLocalCollisionDetector;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ChangeSignatureProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.ChangeSignatureProcessor");
    @Modifier
    private final String myNewVisibility;
    private final ChangeInfoImpl myChangeInfo;
    private final PsiManager myManager;
    private final PsiElementFactory myFactory;
    private final boolean myGenerateDelegate;
    private final Set<PsiMethod> myPropagateParametersMethods;
    private final Set<PsiMethod> myPropagateExceptionsMethods;

    public ChangeSignatureProcessor(Project project, PsiMethod method, boolean generateDelegate, @Modifier String newVisibility, String newName, PsiType newType, @NotNull ParameterInfoImpl[] parameterInfo) {
        if (parameterInfo == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/refactoring/changeSignature/ChangeSignatureProcessor.<init> must not be null");
        }
        this(project, method, generateDelegate, newVisibility, newName, newType != null ? CanonicalTypes.createTypeWrapper(newType) : null, parameterInfo, null, null, null);
    }

    public ChangeSignatureProcessor(Project project, PsiMethod method, boolean generateDelegate, String newVisibility, String newName, PsiType newType, ParameterInfoImpl[] parameterInfo, ThrownExceptionInfo[] exceptionInfos) {
        this(project, method, generateDelegate, newVisibility, newName, newType != null ? CanonicalTypes.createTypeWrapper(newType) : null, parameterInfo, exceptionInfos, null, null);
    }

    public ChangeSignatureProcessor(Project project, PsiMethod method, boolean generateDelegate, String newVisibility, String newName, CanonicalTypes.Type newType, @NotNull ParameterInfoImpl[] parameterInfo, ThrownExceptionInfo[] thrownExceptions, Set<PsiMethod> propagateParametersMethods, Set<PsiMethod> propagateExceptionsMethods) {
        if (parameterInfo == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/refactoring/changeSignature/ChangeSignatureProcessor.<init> must not be null");
        }
        super(project);
        this.myManager = PsiManager.getInstance((Project)project);
        this.myFactory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
        this.myGenerateDelegate = generateDelegate;
        this.myPropagateParametersMethods = propagateParametersMethods != null ? propagateParametersMethods : new HashSet();
        this.myPropagateExceptionsMethods = propagateExceptionsMethods != null ? propagateExceptionsMethods : new HashSet();
        LOG.assertTrue(method.isValid());
        this.myNewVisibility = newVisibility == null ? VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList()) : newVisibility;
        this.myChangeInfo = new ChangeInfoImpl(this.myNewVisibility, method, newName, newType, parameterInfo, thrownExceptions);
        LOG.assertTrue(this.myChangeInfo.getMethod().isValid());
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new ChangeSignatureViewDescriptor(this.myChangeInfo.getMethod());
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        PsiMethod method = this.myChangeInfo.getMethod();
        this.findSimpleUsages(method, result);
        UsageInfo[] usageInfos = result.toArray(new UsageInfo[result.size()]);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(usageInfos);
        if (usageInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/changeSignature/ChangeSignatureProcessor.findUsages must not return null");
        }
        return usageInfoArray;
    }

    private void findSimpleUsages(PsiMethod method, ArrayList<UsageInfo> result) {
        PsiMethod[] overridingMethods = this.findSimpleUsagesWithoutParameters(method, result, true, true, true);
        this.findUsagesInCallers(result);
        this.findParametersUsage(method, result, overridingMethods);
    }

    private PsiMethod[] findSimpleUsagesWithoutParameters(PsiMethod method, ArrayList<UsageInfo> result, boolean isToModifyArgs, boolean isToThrowExceptions, boolean isOriginal) {
        boolean needToChangeCalls;
        PsiMethod[] overridingMethods;
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myProject);
        for (PsiMethod overridingMethod : overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)method.getUseScope(), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
            result.add(new OverriderUsageInfo(overridingMethod, method, isOriginal, isToModifyArgs, isToThrowExceptions));
        }
        boolean bl = needToChangeCalls = !this.myGenerateDelegate && (this.myChangeInfo.isNameChanged || this.myChangeInfo.isParameterSetOrOrderChanged || this.myChangeInfo.isExceptionSetOrOrderChanged || this.myChangeInfo.isVisibilityChanged);
        if (needToChangeCalls) {
            PsiReference[] refs;
            int parameterCount = method.getParameterList().getParametersCount();
            for (PsiReference ref : refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)method, (SearchScope)projectScope, (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                boolean isToCatchExceptions;
                PsiElement element = ref.getElement();
                boolean bl2 = isToCatchExceptions = isToThrowExceptions && this.needToCatchExceptions(RefactoringUtil.getEnclosingMethod(element));
                if (!isToCatchExceptions && RefactoringUtil.isMethodUsage(element)) {
                    PsiExpressionList list = RefactoringUtil.getArgumentListByMethodReference(element);
                    if (!method.isVarArgs() && list.getExpressions().length != parameterCount) continue;
                }
                if (RefactoringUtil.isMethodUsage(element)) {
                    result.add(new MethodCallUsageInfo(element, isToModifyArgs, isToCatchExceptions));
                    continue;
                }
                if (element instanceof PsiDocTagValue) {
                    result.add(new UsageInfo(ref.getElement()));
                    continue;
                }
                if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
                    DefaultConstructorImplicitUsageInfo implicitUsageInfo = new DefaultConstructorImplicitUsageInfo((PsiMethod)element, ((PsiMethod)element).getContainingClass(), method);
                    result.add(implicitUsageInfo);
                    continue;
                }
                if (element instanceof PsiClass) {
                    LOG.assertTrue(method.isConstructor());
                    PsiClass psiClass = (PsiClass)element;
                    if (ChangeSignatureProcessor.shouldPropagateToNonPhysicalMethod(method, result, psiClass, this.myPropagateParametersMethods) || ChangeSignatureProcessor.shouldPropagateToNonPhysicalMethod(method, result, psiClass, this.myPropagateExceptionsMethods)) continue;
                    result.add(new NoConstructorClassUsageInfo(psiClass));
                    continue;
                }
                if (ref instanceof PsiCallReference) {
                    result.add(new CallReferenceUsageInfo((PsiCallReference)ref));
                    continue;
                }
                result.add((UsageInfo)new MoveRenameUsageInfo(element, ref, (PsiElement)method));
            }
        } else if (this.myChangeInfo.isParameterTypesChanged) {
            PsiReference[] refs;
            for (PsiReference reference : refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)method, (SearchScope)projectScope, (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                PsiElement element = reference.getElement();
                if (element instanceof PsiDocTagValue) {
                    result.add(new UsageInfo(reference));
                    continue;
                }
                if (!(element instanceof XmlElement)) continue;
                result.add((UsageInfo)new MoveRenameUsageInfo(reference, (PsiElement)method));
            }
        }
        this.detectLocalsCollisionsInMethod(method, result, isOriginal);
        for (PsiMethod overridingMethod : overridingMethods) {
            this.detectLocalsCollisionsInMethod(overridingMethod, result, isOriginal);
        }
        return overridingMethods;
    }

    private static boolean shouldPropagateToNonPhysicalMethod(PsiMethod method, ArrayList<UsageInfo> result, PsiClass containingClass, Set<PsiMethod> propagateMethods) {
        for (PsiMethod psiMethod : propagateMethods) {
            if (psiMethod.isPhysical() || !Comparing.strEqual((String)psiMethod.getName(), (String)containingClass.getName())) continue;
            result.add(new DefaultConstructorImplicitUsageInfo(psiMethod, containingClass, method));
            return true;
        }
        return false;
    }

    private void findUsagesInCallers(ArrayList<UsageInfo> usages) {
        for (PsiMethod caller : this.myPropagateParametersMethods) {
            usages.add(new CallerUsageInfo(caller, true, this.myPropagateExceptionsMethods.contains(caller)));
        }
        for (PsiMethod caller : this.myPropagateExceptionsMethods) {
            usages.add(new CallerUsageInfo(caller, this.myPropagateParametersMethods.contains(caller), true));
        }
        HashSet merged = new HashSet();
        merged.addAll(this.myPropagateParametersMethods);
        merged.addAll(this.myPropagateExceptionsMethods);
        for (PsiMethod method : merged) {
            this.findSimpleUsagesWithoutParameters(method, usages, this.myPropagateParametersMethods.contains(method), this.myPropagateExceptionsMethods.contains(method), false);
        }
    }

    private boolean needToChangeCalls() {
        return this.myChangeInfo.isNameChanged || this.myChangeInfo.isParameterSetOrOrderChanged || this.myChangeInfo.isExceptionSetOrOrderChanged;
    }

    private boolean needToCatchExceptions(PsiMethod caller) {
        return this.myChangeInfo.isExceptionSetOrOrderChanged && !this.myPropagateExceptionsMethods.contains(caller);
    }

    private void detectLocalsCollisionsInMethod(PsiMethod method, ArrayList<UsageInfo> result, boolean isOriginal) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        HashSet deletedOrRenamedParameters = new HashSet();
        if (isOriginal) {
            deletedOrRenamedParameters.addAll(Arrays.asList(parameters));
            for (ParameterInfoImpl parameterInfo : this.myChangeInfo.newParms) {
                if (parameterInfo.oldParameterIndex < 0) continue;
                PsiParameter parameter = parameters[parameterInfo.oldParameterIndex];
                if (!parameterInfo.getName().equals(parameter.getName())) continue;
                deletedOrRenamedParameters.remove(parameter);
            }
        }
        for (ParameterInfoImpl parameterInfo : this.myChangeInfo.newParms) {
            int oldParameterIndex = parameterInfo.oldParameterIndex;
            String newName = parameterInfo.getName();
            if (oldParameterIndex >= 0) {
                PsiParameter parameter;
                if (!isOriginal || newName.equals((parameter = parameters[oldParameterIndex]).getName())) continue;
                JavaUnresolvableLocalCollisionDetector.visitLocalsCollisions((PsiElement)parameter, newName, (PsiElement)method.getBody(), null, new JavaUnresolvableLocalCollisionDetector.CollidingVariableVisitor((Set)deletedOrRenamedParameters, result, parameter, method){
                    final /* synthetic */ Set val$deletedOrRenamedParameters;
                    final /* synthetic */ ArrayList val$result;
                    final /* synthetic */ PsiParameter val$parameter;
                    final /* synthetic */ PsiMethod val$method;
                    {
                        this.val$deletedOrRenamedParameters = set;
                        this.val$result = arrayList;
                        this.val$parameter = psiParameter;
                        this.val$method = psiMethod;
                    }

                    @Override
                    public void visitCollidingElement(PsiVariable collidingVariable) {
                        if (!this.val$deletedOrRenamedParameters.contains(collidingVariable)) {
                            this.val$result.add(new RenamedParameterCollidesWithLocalUsageInfo(this.val$parameter, (PsiElement)collidingVariable, this.val$method));
                        }
                    }
                });
                continue;
            }
            JavaUnresolvableLocalCollisionDetector.visitLocalsCollisions((PsiElement)method, newName, (PsiElement)method.getBody(), null, new JavaUnresolvableLocalCollisionDetector.CollidingVariableVisitor((Set)deletedOrRenamedParameters, result, method){
                final /* synthetic */ Set val$deletedOrRenamedParameters;
                final /* synthetic */ ArrayList val$result;
                final /* synthetic */ PsiMethod val$method;
                {
                    this.val$deletedOrRenamedParameters = set;
                    this.val$result = arrayList;
                    this.val$method = psiMethod;
                }

                @Override
                public void visitCollidingElement(PsiVariable collidingVariable) {
                    if (!this.val$deletedOrRenamedParameters.contains(collidingVariable)) {
                        this.val$result.add(new NewParameterCollidesWithLocalUsageInfo((PsiElement)collidingVariable, (PsiElement)collidingVariable, this.val$method));
                    }
                }
            });
        }
    }

    private void findParametersUsage(PsiMethod method, ArrayList<UsageInfo> result, PsiMethod[] overriders) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (ParameterInfoImpl info : this.myChangeInfo.newParms) {
            if (info.oldParameterIndex < 0) continue;
            PsiParameter parameter = parameters[info.oldParameterIndex];
            if (info.getName().equals(parameter.getName())) continue;
            ChangeSignatureProcessor.addParameterUsages(parameter, result, info);
            for (PsiMethod overrider : overriders) {
                PsiParameter parameter1 = overrider.getParameterList().getParameters()[info.oldParameterIndex];
                if (!parameter.getName().equals(parameter1.getName())) continue;
                ChangeSignatureProcessor.addParameterUsages(parameter1, result, info);
            }
        }
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        boolean condition = elements.length == 1 && elements[0] instanceof PsiMethod;
        LOG.assertTrue(condition);
        this.myChangeInfo.updateMethod((PsiMethod)elements[0]);
    }

    private void addMethodConflicts(MultiMap<PsiElement, String> conflicts) {
        String newMethodName = this.myChangeInfo.newName;
        try {
            ParameterInfoImpl[] parameters;
            PsiMethod prototype;
            PsiManager manager = PsiManager.getInstance((Project)this.myProject);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiMethod method = this.myChangeInfo.getMethod();
            CanonicalTypes.Type returnType = this.myChangeInfo.newReturnType;
            if (returnType != null) {
                prototype = factory.createMethod(newMethodName, returnType.getType((PsiElement)method, manager));
            } else {
                prototype = factory.createConstructor();
                prototype.setName(newMethodName);
            }
            for (ParameterInfoImpl info : parameters = this.myChangeInfo.newParms) {
                PsiType parameterType = info.createType((PsiElement)method, manager);
                PsiParameter param = factory.createParameter(info.getName(), parameterType);
                prototype.getParameterList().add((PsiElement)param);
            }
            ConflictsUtil.checkMethodConflicts(method.getContainingClass(), method, prototype, conflicts);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        MultiMap conflictDescriptions = new MultiMap();
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        this.addMethodConflicts((MultiMap<PsiElement, String>)conflictDescriptions);
        RenameUtil.addConflictDescriptions(usagesIn, (MultiMap<PsiElement, String>)conflictDescriptions);
        HashSet usagesSet = new HashSet(Arrays.asList(usagesIn));
        RenameUtil.removeConflictUsages((Set<UsageInfo>)usagesSet);
        if (this.myChangeInfo.isVisibilityChanged) {
            try {
                this.addInaccessibilityDescriptions((Set<UsageInfo>)usagesSet, (MultiMap<PsiElement, String>)conflictDescriptions);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myPrepareSuccessfulSwingThreadCallback != null && !conflictDescriptions.isEmpty()) {
            ConflictsDialog dialog = new ConflictsDialog(this.myProject, (MultiMap<PsiElement, String>)conflictDescriptions);
            dialog.show();
            if (!dialog.isOK()) {
                if (dialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        if (this.myChangeInfo.isReturnTypeChanged) {
            this.askToRemoveCovariantOverriders((Set<UsageInfo>)usagesSet);
        }
        refUsages.set((Object)usagesSet.toArray(new UsageInfo[usagesSet.size()]));
        this.prepareSuccessful();
        return true;
    }

    private void addInaccessibilityDescriptions(Set<UsageInfo> usages, MultiMap<PsiElement, String> conflictDescriptions) throws IncorrectOperationException {
        PsiMethod method = this.myChangeInfo.getMethod();
        PsiModifierList modifierList = (PsiModifierList)method.getModifierList().copy();
        VisibilityUtil.setVisibility((PsiModifierList)modifierList, (String)this.myNewVisibility);
        Iterator<UsageInfo> iterator = usages.iterator();
        while (iterator.hasNext()) {
            UsageInfo usageInfo = iterator.next();
            PsiElement element = usageInfo.getElement();
            if (element == null || !(element instanceof PsiReferenceExpression)) continue;
            PsiClass accessObjectClass = null;
            PsiExpression qualifier = ((PsiReferenceExpression)element).getQualifierExpression();
            if (qualifier != null) {
                accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
            }
            if (JavaPsiFacade.getInstance((Project)element.getProject()).getResolveHelper().isAccessible((PsiMember)method, modifierList, element, accessObjectClass, null)) continue;
            String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accesible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)method, true), this.myNewVisibility, RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(element), true)});
            conflictDescriptions.putValue((Object)method, (Object)message);
            if (this.needToChangeCalls()) continue;
            iterator.remove();
        }
    }

    private void askToRemoveCovariantOverriders(Set<UsageInfo> usages) {
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)this.myChangeInfo.getMethod())) {
            ArrayList<UsageInfo> covariantOverriderInfos = new ArrayList<UsageInfo>();
            for (UsageInfo usageInfo : usages) {
                PsiType type;
                if (!(usageInfo instanceof OverriderUsageInfo)) continue;
                OverriderUsageInfo info = (OverriderUsageInfo)usageInfo;
                PsiMethod overrider = info.getElement();
                PsiMethod baseMethod = info.getBaseMethod();
                PsiSubstitutor substitutor = ChangeSignatureProcessor.calculateSubstitutor(overrider, baseMethod);
                try {
                    type = substitutor.substitute(this.myChangeInfo.newReturnType.getType((PsiElement)this.myChangeInfo.getMethod(), this.myManager));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    return;
                }
                PsiType overriderType = overrider.getReturnType();
                if (overriderType == null || !type.isAssignableFrom(overriderType)) continue;
                covariantOverriderInfos.add(usageInfo);
            }
            this.preprocessCovariantOverriders(covariantOverriderInfos);
            if (!(covariantOverriderInfos.isEmpty() || !ApplicationManager.getApplication().isUnitTestMode() && this.isProcessCovariantOverriders())) {
                for (UsageInfo usageInfo : covariantOverriderInfos) {
                    usages.remove(usageInfo);
                }
            }
        }
    }

    protected void preprocessCovariantOverriders(List<UsageInfo> covariantOverriderInfos) {
    }

    protected boolean isProcessCovariantOverriders() {
        return Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"do.you.want.to.process.overriding.methods.with.covariant.return.type"), (String)ChangeSignatureHandler.REFACTORING_NAME, (Icon)Messages.getQuestionIcon()) == 0;
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
        try {
            if (this.myChangeInfo.isNameChanged) {
                this.myChangeInfo.newNameIdentifier = factory.createIdentifier(this.myChangeInfo.newName);
            }
            if (this.myChangeInfo.isReturnTypeChanged) {
                this.myChangeInfo.newTypeElement = this.myChangeInfo.newReturnType.getType((PsiElement)this.myChangeInfo.getMethod(), this.myManager);
            }
            if (this.myGenerateDelegate) {
                this.generateDelegate();
            }
            for (UsageInfo usage : usages) {
                if (usage instanceof CallerUsageInfo) {
                    CallerUsageInfo callerUsageInfo = (CallerUsageInfo)usage;
                    this.processCallerMethod(callerUsageInfo.getMethod(), null, callerUsageInfo.isToInsertParameter(), callerUsageInfo.isToInsertException());
                    continue;
                }
                if (!(usage instanceof OverriderUsageInfo)) continue;
                OverriderUsageInfo info = (OverriderUsageInfo)usage;
                PsiMethod method = info.getElement();
                PsiMethod baseMethod = info.getBaseMethod();
                if (info.isOriginalOverrider()) {
                    this.processPrimaryMethod(method, baseMethod, false);
                    continue;
                }
                this.processCallerMethod(method, baseMethod, info.isToInsertArgs(), info.isToCatchExceptions());
            }
            LOG.assertTrue(this.myChangeInfo.getMethod().isValid());
            this.processPrimaryMethod(this.myChangeInfo.getMethod(), null, true);
            ArrayList<UsageInfo> postponedUsages = new ArrayList<UsageInfo>();
            for (UsageInfo usage : usages) {
                PsiElement element = usage.getElement();
                if (element == null) continue;
                if (usage instanceof DefaultConstructorImplicitUsageInfo) {
                    DefaultConstructorImplicitUsageInfo defConstructorUsage = (DefaultConstructorImplicitUsageInfo)usage;
                    PsiMethod constructor = defConstructorUsage.getConstructor();
                    if (!constructor.isPhysical()) {
                        boolean toPropagate = this.myPropagateParametersMethods.remove(constructor);
                        PsiClass containingClass = defConstructorUsage.getContainingClass();
                        constructor = (PsiMethod)containingClass.add((PsiElement)constructor);
                        PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)containingClass.getModifierList()), (boolean)true);
                        if (toPropagate) {
                            this.myPropagateParametersMethods.add(constructor);
                        }
                    }
                    this.addSuperCall(constructor, defConstructorUsage.getBaseConstructor(), usages);
                    continue;
                }
                if (usage instanceof NoConstructorClassUsageInfo) {
                    this.addDefaultConstructor(((NoConstructorClassUsageInfo)usage).getPsiClass(), usages);
                    continue;
                }
                if (element instanceof PsiJavaCodeReferenceElement) {
                    if (usage instanceof MethodCallUsageInfo) {
                        MethodCallUsageInfo methodCallInfo = (MethodCallUsageInfo)usage;
                        this.processMethodUsage(methodCallInfo.getElement(), this.myChangeInfo, methodCallInfo.isToChangeArguments(), methodCallInfo.isToCatchExceptions(), methodCallInfo.getReferencedMethod(), usages);
                        continue;
                    }
                    if (usage instanceof MyParameterUsageInfo) {
                        String newName = ((MyParameterUsageInfo)usage).newParameterName;
                        String oldName = ((MyParameterUsageInfo)usage).oldParameterName;
                        ChangeSignatureProcessor.processParameterUsage((PsiReferenceExpression)element, oldName, newName);
                        continue;
                    }
                    postponedUsages.add(usage);
                    continue;
                }
                if (usage instanceof CallReferenceUsageInfo) {
                    ((CallReferenceUsageInfo)usage).getReference().handleChangeSignature((ChangeInfo)this.myChangeInfo);
                    continue;
                }
                if (element instanceof PsiEnumConstant) {
                    this.fixActualArgumentsList(((PsiEnumConstant)element).getArgumentList(), this.myChangeInfo, true);
                    continue;
                }
                if (usage instanceof OverriderUsageInfo) continue;
                postponedUsages.add(usage);
            }
            for (UsageInfo usageInfo : postponedUsages) {
                PsiReference reference;
                PsiElement element = usageInfo.getElement();
                if (element == null || (reference = usageInfo instanceof MoveRenameUsageInfo ? usageInfo.getReference() : element.getReference()) == null) continue;
                PsiMethod target = null;
                if (usageInfo instanceof MyParameterUsageInfo) {
                    PsiParameter[] newParams;
                    String newParameterName = ((MyParameterUsageInfo)usageInfo).newParameterName;
                    for (PsiParameter newParam : newParams = this.myChangeInfo.getMethod().getParameterList().getParameters()) {
                        if (!newParam.getName().equals(newParameterName)) continue;
                        target = newParam;
                        break;
                    }
                } else {
                    target = this.myChangeInfo.getMethod();
                }
                if (target == null) continue;
                reference.bindToElement((PsiElement)target);
            }
            LOG.assertTrue(this.myChangeInfo.getMethod().isValid());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void generateDelegate() throws IncorrectOperationException {
        PsiMethod delegate = (PsiMethod)this.myChangeInfo.getMethod().copy();
        PsiClass targetClass = this.myChangeInfo.getMethod().getContainingClass();
        LOG.assertTrue(!targetClass.isInterface());
        ChangeSignatureProcessor.makeEmptyBody(this.myFactory, delegate);
        PsiCallExpression callExpression = ChangeSignatureProcessor.addDelegatingCallTemplate(delegate, this.myChangeInfo.newName);
        this.addDelegateArguments(callExpression);
        targetClass.addBefore((PsiElement)delegate, (PsiElement)this.myChangeInfo.getMethod());
    }

    private void addDelegateArguments(PsiCallExpression callExpression) throws IncorrectOperationException {
        ParameterInfoImpl[] newParms = this.myChangeInfo.newParms;
        for (int i = 0; i < newParms.length; ++i) {
            ParameterInfoImpl newParm = newParms[i];
            PsiExpression actualArg = newParm.oldParameterIndex >= 0 ? this.myFactory.createExpressionFromText(this.myChangeInfo.oldParameterNames[newParm.oldParameterIndex], (PsiElement)callExpression) : this.myChangeInfo.getValue(i, callExpression);
            callExpression.getArgumentList().add((PsiElement)actualArg);
        }
    }

    public static void makeEmptyBody(PsiElementFactory factory, PsiMethod delegate) throws IncorrectOperationException {
        PsiCodeBlock body = delegate.getBody();
        if (body != null) {
            body.replace((PsiElement)factory.createCodeBlock());
        } else {
            delegate.add((PsiElement)factory.createCodeBlock());
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)delegate, (String)"abstract", (boolean)false);
    }

    public static PsiCallExpression addDelegatingCallTemplate(PsiMethod delegate, String newName) throws IncorrectOperationException {
        PsiCallExpression callExpression;
        Project project = delegate.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiCodeBlock body = delegate.getBody();
        assert (body != null);
        if (delegate.isConstructor()) {
            PsiStatement callStatement = factory.createStatementFromText("this();", null);
            callStatement = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)callStatement);
            callStatement = body.add((PsiElement)callStatement);
            callExpression = (PsiCallExpression)((PsiExpressionStatement)callStatement).getExpression();
        } else if (PsiType.VOID.equals(delegate.getReturnType())) {
            PsiStatement callStatement = factory.createStatementFromText(newName + "();", null);
            callStatement = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)callStatement);
            callStatement = body.add((PsiElement)callStatement);
            callExpression = (PsiCallExpression)((PsiExpressionStatement)callStatement).getExpression();
        } else {
            PsiStatement callStatement = factory.createStatementFromText("return " + newName + "();", null);
            callStatement = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)callStatement);
            callStatement = body.add((PsiElement)callStatement);
            callExpression = (PsiCallExpression)((PsiReturnStatement)callStatement).getReturnValue();
        }
        return callExpression;
    }

    private void addDefaultConstructor(PsiClass aClass, UsageInfo[] usages) throws IncorrectOperationException {
        if (!(aClass instanceof PsiAnonymousClass)) {
            PsiMethod defaultConstructor = this.myFactory.createMethodFromText(aClass.getName() + "(){}", (PsiElement)aClass);
            defaultConstructor = (PsiMethod)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)defaultConstructor);
            defaultConstructor = (PsiMethod)aClass.add((PsiElement)defaultConstructor);
            PsiUtil.setModifierProperty((PsiModifierListOwner)defaultConstructor, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList()), (boolean)true);
            this.addSuperCall(defaultConstructor, null, usages);
        } else {
            PsiElement parent = aClass.getParent();
            if (parent instanceof PsiNewExpression) {
                PsiExpressionList argumentList = ((PsiNewExpression)parent).getArgumentList();
                this.fixActualArgumentsList(argumentList, this.myChangeInfo, true);
            }
        }
    }

    private void addSuperCall(PsiMethod constructor, PsiMethod callee, UsageInfo[] usages) throws IncorrectOperationException {
        PsiExpressionStatement superCall = (PsiExpressionStatement)this.myFactory.createStatementFromText("super();", (PsiElement)constructor);
        PsiCodeBlock body = constructor.getBody();
        assert (body != null);
        PsiStatement[] statements = body.getStatements();
        superCall = statements.length > 0 ? (PsiExpressionStatement)body.addBefore((PsiElement)superCall, (PsiElement)statements[0]) : (PsiExpressionStatement)body.add((PsiElement)superCall);
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)superCall.getExpression();
        this.processMethodUsage((PsiElement)callExpression.getMethodExpression(), this.myChangeInfo, true, false, callee, usages);
    }

    private PsiParameter createNewParameter(ParameterInfoImpl newParm, PsiSubstitutor substitutor) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        PsiType type = substitutor.substitute(newParm.createType((PsiElement)this.myChangeInfo.getMethod().getParameterList(), this.myManager));
        return factory.createParameter(newParm.getName(), type);
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{UsageViewUtil.getDescriptiveName((PsiElement)this.myChangeInfo.getMethod())});
    }

    private void processMethodUsage(PsiElement ref, ChangeInfoImpl changeInfo, boolean toChangeArguments, boolean toCatchExceptions, PsiMethod callee, UsageInfo[] usages) throws IncorrectOperationException {
        PsiElement last;
        if (changeInfo.isNameChanged && ref instanceof PsiJavaCodeReferenceElement && (last = ((PsiJavaCodeReferenceElement)ref).getReferenceNameElement()) instanceof PsiIdentifier && last.getText().equals(changeInfo.oldName)) {
            last.replace((PsiElement)changeInfo.newNameIdentifier);
        }
        PsiMethod caller = RefactoringUtil.getEnclosingMethod(ref);
        if (toChangeArguments) {
            PsiExpression qualifierExpression;
            boolean toInsertDefaultValue;
            PsiExpressionList list = RefactoringUtil.getArgumentListByMethodReference(ref);
            boolean bl = toInsertDefaultValue = !this.myPropagateParametersMethods.contains(caller);
            if (toInsertDefaultValue && ref instanceof PsiReferenceExpression && (qualifierExpression = ((PsiReferenceExpression)ref).getQualifierExpression()) instanceof PsiSuperExpression && ChangeSignatureProcessor.callerSignatureIsAboutToChangeToo(caller, usages)) {
                toInsertDefaultValue = false;
            }
            this.fixActualArgumentsList(list, changeInfo, toInsertDefaultValue);
        }
        if (toCatchExceptions && (!(ref instanceof PsiReferenceExpression) || !(((PsiReferenceExpression)ref).getQualifierExpression() instanceof PsiSuperExpression)) && this.needToCatchExceptions(caller)) {
            PsiClassType[] newExceptions = callee != null ? ChangeSignatureProcessor.getCalleeChangedExceptionInfo(callee) : this.getPrimaryChangedExceptionInfo(changeInfo);
            this.fixExceptions(ref, newExceptions);
        }
    }

    private static boolean callerSignatureIsAboutToChangeToo(PsiMethod caller, UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (!(usage instanceof MethodCallUsageInfo) || !MethodSignatureUtil.isSuperMethod((PsiMethod)((MethodCallUsageInfo)usage).getReferencedMethod(), (PsiMethod)caller)) continue;
            return true;
        }
        return false;
    }

    private static PsiClassType[] getCalleeChangedExceptionInfo(PsiMethod callee) {
        return callee.getThrowsList().getReferencedTypes();
    }

    private PsiClassType[] getPrimaryChangedExceptionInfo(ChangeInfoImpl changeInfo) throws IncorrectOperationException {
        PsiClassType[] newExceptions = new PsiClassType[changeInfo.newExceptions.length];
        for (int i = 0; i < newExceptions.length; ++i) {
            newExceptions[i] = (PsiClassType)changeInfo.newExceptions[i].myType.getType((PsiElement)this.myChangeInfo.getMethod(), this.myManager);
        }
        return newExceptions;
    }

    private void fixExceptions(PsiElement ref, PsiClassType[] newExceptions) throws IncorrectOperationException {
        newExceptions = ChangeSignatureProcessor.filterCheckedExceptions(newExceptions);
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiTryStatement.class, PsiMethod.class});
        if (context instanceof PsiTryStatement) {
            PsiParameter[] catchParameters;
            PsiTryStatement tryStatement = (PsiTryStatement)context;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            Collection<PsiClassType> classes = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock);
            for (PsiParameter parameter : catchParameters = tryStatement.getCatchBlockParameters()) {
                PsiType caughtType = parameter.getType();
                if (!(caughtType instanceof PsiClassType) || ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)caughtType) || !ChangeSignatureProcessor.isCatchParameterRedundant((PsiClassType)caughtType, classes)) continue;
                parameter.getParent().delete();
            }
            PsiClassType[] exceptionsToAdd = ChangeSignatureProcessor.filterUnhandledExceptions(newExceptions, (PsiElement)tryBlock);
            ChangeSignatureProcessor.addExceptions(exceptionsToAdd, tryStatement);
            ChangeSignatureProcessor.adjustPossibleEmptyTryStatement(tryStatement);
        } else if ((newExceptions = ChangeSignatureProcessor.filterUnhandledExceptions(newExceptions, ref)).length > 0) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
            PsiTryStatement tryStatement = (PsiTryStatement)elementFactory.createStatementFromText("try {} catch (Exception e) {}", null);
            PsiStatement anchor = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiStatement.class);
            LOG.assertTrue(anchor != null);
            tryStatement.getTryBlock().add((PsiElement)anchor);
            tryStatement = (PsiTryStatement)anchor.getParent().addAfter((PsiElement)tryStatement, (PsiElement)anchor);
            ChangeSignatureProcessor.addExceptions(newExceptions, tryStatement);
            anchor.delete();
            tryStatement.getCatchSections()[0].delete();
        }
    }

    private static PsiClassType[] filterCheckedExceptions(PsiClassType[] exceptions) {
        ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
        for (PsiClassType exceptionType : exceptions) {
            if (ExceptionUtil.isUncheckedException(exceptionType)) continue;
            result.add(exceptionType);
        }
        return result.toArray(new PsiClassType[result.size()]);
    }

    private static void adjustPossibleEmptyTryStatement(PsiTryStatement tryStatement) throws IncorrectOperationException {
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock != null && tryStatement.getCatchSections().length == 0 && tryStatement.getFinallyBlock() == null) {
            PsiElement firstBodyElement = tryBlock.getFirstBodyElement();
            if (firstBodyElement != null) {
                tryStatement.getParent().addRangeAfter(firstBodyElement, tryBlock.getLastBodyElement(), (PsiElement)tryStatement);
            }
            tryStatement.delete();
        }
    }

    private static void addExceptions(PsiClassType[] exceptionsToAdd, PsiTryStatement tryStatement) throws IncorrectOperationException {
        for (PsiClassType type : exceptionsToAdd) {
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)tryStatement.getProject());
            String name = styleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type).names[0];
            name = styleManager.suggestUniqueVariableName(name, (PsiElement)tryStatement, false);
            PsiCatchSection catchSection = JavaPsiFacade.getInstance((Project)tryStatement.getProject()).getElementFactory().createCatchSection(type, name, (PsiElement)tryStatement);
            tryStatement.add((PsiElement)catchSection);
        }
    }

    private void fixPrimaryThrowsLists(PsiMethod method, PsiClassType[] newExceptions) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[newExceptions.length];
        for (int i = 0; i < refs.length; ++i) {
            refs[i] = elementFactory.createReferenceElementByType(newExceptions[i]);
        }
        PsiReferenceList throwsList = elementFactory.createReferenceList(refs);
        this.replaceThrowsList(method, throwsList);
    }

    private void replaceThrowsList(PsiMethod method, PsiReferenceList throwsList) throws IncorrectOperationException {
        PsiReferenceList methodThrowsList = (PsiReferenceList)method.getThrowsList().replace((PsiElement)throwsList);
        methodThrowsList = (PsiReferenceList)JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)methodThrowsList);
        this.myManager.getCodeStyleManager().reformatRange((PsiElement)method, method.getParameterList().getTextRange().getEndOffset(), methodThrowsList.getTextRange().getEndOffset());
    }

    private static PsiClassType[] filterUnhandledExceptions(PsiClassType[] exceptions, PsiElement place) {
        ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
        for (PsiClassType exception : exceptions) {
            if (ExceptionUtil.isHandled(exception, place)) continue;
            result.add(exception);
        }
        return result.toArray(new PsiClassType[result.size()]);
    }

    private static boolean isCatchParameterRedundant(PsiClassType catchParamType, Collection<PsiClassType> thrownTypes) {
        for (PsiClassType exceptionType : thrownTypes) {
            if (!exceptionType.isConvertibleFrom((PsiType)catchParamType)) continue;
            return false;
        }
        return true;
    }

    private static int getNonVarargCount(ChangeInfoImpl changeInfo, PsiExpression[] args) {
        if (!changeInfo.wasVararg) {
            return args.length;
        }
        return changeInfo.oldParameterTypes.length - 1;
    }

    private void fixActualArgumentsList(PsiExpressionList list, ChangeInfoImpl changeInfo, boolean toInsertDefaultValue) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)list.getProject()).getElementFactory();
        if (changeInfo.isParameterSetOrOrderChanged) {
            if (changeInfo.isPropagationEnabled) {
                ParameterInfoImpl[] createdParmsInfo;
                for (ParameterInfoImpl info : createdParmsInfo = changeInfo.getCreatedParmsInfoWithoutVarargs()) {
                    PsiExpression newArg = toInsertDefaultValue ? this.createDefaultValue(factory, info, list) : factory.createExpressionFromText(info.getName(), (PsiElement)list);
                    list.add((PsiElement)newArg);
                }
            } else {
                int i;
                int newArgsLength;
                int newNonVarargCount;
                PsiExpression[] args = list.getExpressions();
                int nonVarargCount = ChangeSignatureProcessor.getNonVarargCount(changeInfo, args);
                int varargCount = args.length - nonVarargCount;
                PsiExpression[] newVarargInitializers = null;
                if (changeInfo.arrayToVarargs) {
                    PsiNewExpression expression;
                    PsiArrayInitializerExpression arrayInitializer;
                    newNonVarargCount = changeInfo.newParms.length - 1;
                    ParameterInfoImpl lastNewParm = changeInfo.newParms[changeInfo.newParms.length - 1];
                    PsiExpression arrayToConvert = args[lastNewParm.oldParameterIndex];
                    if (arrayToConvert instanceof PsiNewExpression && (arrayInitializer = (expression = (PsiNewExpression)arrayToConvert).getArrayInitializer()) != null) {
                        newVarargInitializers = arrayInitializer.getInitializers();
                    }
                    newArgsLength = newVarargInitializers == null ? changeInfo.newParms.length : newNonVarargCount + newVarargInitializers.length;
                } else if (changeInfo.retainsVarargs) {
                    newNonVarargCount = changeInfo.newParms.length - 1;
                    newArgsLength = newNonVarargCount + varargCount;
                } else if (changeInfo.obtainsVarags) {
                    newArgsLength = newNonVarargCount = changeInfo.newParms.length - 1;
                } else {
                    newNonVarargCount = changeInfo.newParms.length;
                    newArgsLength = changeInfo.newParms.length;
                }
                PsiExpression[] newArgs = new PsiExpression[newArgsLength];
                for (i = 0; i < newNonVarargCount; ++i) {
                    newArgs[i] = this.createActualArgument(list, changeInfo.newParms[i], toInsertDefaultValue, args);
                }
                if (changeInfo.arrayToVarargs) {
                    if (newVarargInitializers == null) {
                        newArgs[newNonVarargCount] = this.createActualArgument(list, changeInfo.newParms[newNonVarargCount], toInsertDefaultValue, args);
                    } else {
                        for (i = 0; i < newVarargInitializers.length; ++i) {
                            newArgs[i + newNonVarargCount] = newVarargInitializers[i];
                        }
                    }
                } else {
                    int newVarargCount = newArgsLength - newNonVarargCount;
                    LOG.assertTrue(newVarargCount == 0 || newVarargCount == varargCount);
                    for (int i2 = 0; i2 < newVarargCount; ++i2) {
                        newArgs[newNonVarargCount + i2] = args[nonVarargCount + i2];
                    }
                }
                ChangeSignatureUtil.synchronizeList(list, Arrays.asList(newArgs), ExpressionList.INSTANCE, changeInfo.toRemoveParm);
            }
        }
    }

    private PsiExpression createActualArgument(PsiExpressionList list, ParameterInfoImpl info, boolean toInsertDefaultValue, PsiExpression[] args) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)list.getProject()).getElementFactory();
        int index = info.oldParameterIndex;
        if (index >= 0) {
            return args[index];
        }
        if (toInsertDefaultValue) {
            return this.createDefaultValue(factory, info, list);
        }
        return factory.createExpressionFromText(info.getName(), (PsiElement)list);
    }

    private PsiExpression createDefaultValue(PsiElementFactory factory, ParameterInfoImpl info, final PsiExpressionList list) throws IncorrectOperationException {
        PsiCallExpression callExpression;
        if (info.useAnySingleVariable) {
            final PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)list.getProject()).getResolveHelper();
            final PsiType type = info.getTypeWrapper().getType((PsiElement)this.myChangeInfo.getMethod(), this.myManager);
            VariablesProcessor processor = new VariablesProcessor(false){

                @Override
                protected boolean check(PsiVariable var, ResolveState state) {
                    if (var instanceof PsiField && !resolveHelper.isAccessible((PsiMember)((PsiField)var), (PsiElement)list, null)) {
                        return false;
                    }
                    PsiType varType = ((PsiSubstitutor)state.get(PsiSubstitutor.KEY)).substitute(var.getType());
                    return type.isAssignableFrom(varType);
                }

                @Override
                public boolean execute(PsiElement pe, ResolveState state) {
                    super.execute(pe, state);
                    return this.size() < 2;
                }
            };
            PsiScopesUtil.treeWalkUp(processor, (PsiElement)list, null);
            if (processor.size() == 1) {
                PsiVariable result = processor.getResult(0);
                return factory.createExpressionFromText(result.getName(), (PsiElement)list);
            }
        }
        return (callExpression = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)list, PsiCallExpression.class)) != null ? info.getValue(callExpression) : factory.createExpressionFromText(info.defaultValue, (PsiElement)list);
    }

    private static void addParameterUsages(PsiParameter parameter, ArrayList<UsageInfo> results, ParameterInfoImpl info) {
        PsiManager manager = parameter.getManager();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)manager.getProject());
        for (PsiReference psiReference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)projectScope, (boolean)false)) {
            PsiElement parmRef = psiReference.getElement();
            MyParameterUsageInfo usageInfo = new MyParameterUsageInfo(parmRef, parameter.getName(), info.getName());
            results.add(usageInfo);
        }
    }

    private void processCallerMethod(PsiMethod caller, PsiMethod baseMethod, boolean toInsertParams, boolean toInsertThrows) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] arrayed;
        LOG.assertTrue(toInsertParams || toInsertThrows);
        if (toInsertParams) {
            ArrayList<PsiParameter> newParameters = new ArrayList<PsiParameter>();
            newParameters.addAll(Arrays.asList(caller.getParameterList().getParameters()));
            ParameterInfoImpl[] primaryNewParms = this.myChangeInfo.newParms;
            PsiSubstitutor substitutor = baseMethod == null ? PsiSubstitutor.EMPTY : ChangeSignatureProcessor.calculateSubstitutor(caller, baseMethod);
            for (ParameterInfoImpl info : primaryNewParms) {
                if (info.oldParameterIndex >= 0) continue;
                newParameters.add(this.createNewParameter(info, substitutor));
            }
            arrayed = newParameters.toArray(new PsiParameter[newParameters.size()]);
            boolean[] toRemoveParm = new boolean[arrayed.length];
            Arrays.fill(toRemoveParm, false);
            ChangeSignatureProcessor.resolveParameterVsFieldsConflicts((PsiParameter[])arrayed, caller, caller.getParameterList(), toRemoveParm);
        }
        if (toInsertThrows) {
            ArrayList<PsiJavaCodeReferenceElement> newThrowns = new ArrayList<PsiJavaCodeReferenceElement>();
            PsiReferenceList throwsList = caller.getThrowsList();
            newThrowns.addAll(Arrays.asList(throwsList.getReferenceElements()));
            ThrownExceptionInfo[] primaryNewExns = this.myChangeInfo.newExceptions;
            for (ThrownExceptionInfo thrownExceptionInfo : primaryNewExns) {
                if (thrownExceptionInfo.oldIndex >= 0) continue;
                PsiClassType type = (PsiClassType)thrownExceptionInfo.createType((PsiElement)caller, this.myManager);
                PsiJavaCodeReferenceElement ref = JavaPsiFacade.getInstance((Project)caller.getProject()).getElementFactory().createReferenceElementByType(type);
                newThrowns.add(ref);
            }
            arrayed = newThrowns.toArray(new PsiJavaCodeReferenceElement[newThrowns.size()]);
            boolean[] toRemoveParm = new boolean[arrayed.length];
            Arrays.fill(toRemoveParm, false);
            ChangeSignatureUtil.synchronizeList(throwsList, Arrays.asList(arrayed), ThrowsList.INSTANCE, toRemoveParm);
        }
    }

    private void processPrimaryMethod(PsiMethod method, PsiMethod baseMethod, boolean isOriginal) throws IncorrectOperationException {
        PsiSubstitutor substitutor;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        if (this.myChangeInfo.isVisibilityChanged) {
            PsiModifierList modifierList = method.getModifierList();
            String highestVisibility = isOriginal ? this.myNewVisibility : VisibilityUtil.getHighestVisibility((String)this.myNewVisibility, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList));
            VisibilityUtil.setVisibility((PsiModifierList)modifierList, (String)highestVisibility);
        }
        if (this.myChangeInfo.isNameChanged) {
            String newName;
            String string = newName = baseMethod == null ? this.myChangeInfo.newName : RefactoringUtil.suggestNewOverriderName(method.getName(), baseMethod.getName(), this.myChangeInfo.newName);
            if (newName != null && !newName.equals(method.getName())) {
                PsiIdentifier nameId = method.getNameIdentifier();
                assert (nameId != null);
                nameId.replace((PsiElement)JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory().createIdentifier(newName));
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor = baseMethod == null ? PsiSubstitutor.EMPTY : ChangeSignatureProcessor.calculateSubstitutor(method, baseMethod);
        if (this.myChangeInfo.isReturnTypeChanged) {
            PsiTypeElement typeElement;
            PsiType returnType = substitutor.substitute(this.myChangeInfo.newTypeElement);
            if (method.getName().equals(this.myChangeInfo.newName) && (typeElement = method.getReturnTypeElement()) != null) {
                typeElement.replace((PsiElement)factory.createTypeElement(returnType));
            }
        }
        PsiParameterList list = method.getParameterList();
        PsiParameter[] parameters = list.getParameters();
        PsiParameter[] newParms = new PsiParameter[this.myChangeInfo.newParms.length];
        for (int i = 0; i < newParms.length; ++i) {
            ParameterInfoImpl info = this.myChangeInfo.newParms[i];
            int index = info.oldParameterIndex;
            if (index >= 0) {
                String oldType;
                PsiParameter parameter;
                newParms[i] = parameter = parameters[index];
                String oldName = this.myChangeInfo.oldParameterNames[index];
                if (!oldName.equals(info.getName()) && oldName.equals(parameter.getName())) {
                    PsiIdentifier newIdentifier = factory.createIdentifier(info.getName());
                    parameter.getNameIdentifier().replace((PsiElement)newIdentifier);
                }
                if ((oldType = this.myChangeInfo.oldParameterTypes[index]).equals(info.getTypeText())) continue;
                parameter.normalizeDeclaration();
                PsiType newType = substitutor.substitute(info.createType((PsiElement)this.myChangeInfo.getMethod().getParameterList(), this.myManager));
                parameter.getTypeElement().replace((PsiElement)factory.createTypeElement(newType));
                continue;
            }
            newParms[i] = this.createNewParameter(info, substitutor);
        }
        ChangeSignatureProcessor.resolveParameterVsFieldsConflicts(newParms, method, list, this.myChangeInfo.toRemoveParm);
        this.fixJavadocsForChangedMethod(method);
        if (this.myChangeInfo.isExceptionSetOrOrderChanged) {
            PsiClassType[] newExceptions = this.getPrimaryChangedExceptionInfo(this.myChangeInfo);
            this.fixPrimaryThrowsLists(method, newExceptions);
        }
    }

    private static void resolveParameterVsFieldsConflicts(PsiParameter[] newParms, PsiMethod method, PsiParameterList list, boolean[] toRemoveParm) throws IncorrectOperationException {
        ArrayList<FieldConflictsResolver> conflictResolvers = new ArrayList<FieldConflictsResolver>();
        for (PsiParameter parameter : newParms) {
            conflictResolvers.add(new FieldConflictsResolver(parameter.getName(), method.getBody()));
        }
        ChangeSignatureUtil.synchronizeList(list, Arrays.asList(newParms), ParameterList.INSTANCE, toRemoveParm);
        JavaCodeStyleManager.getInstance((Project)list.getProject()).shortenClassReferences((PsiElement)list);
        for (FieldConflictsResolver fieldConflictsResolver : conflictResolvers) {
            fieldConflictsResolver.fix();
        }
    }

    private static PsiSubstitutor calculateSubstitutor(PsiMethod derivedMethod, PsiMethod baseMethod) {
        PsiSubstitutor substitutor;
        if (derivedMethod.getManager().areElementsEquivalent((PsiElement)derivedMethod, (PsiElement)baseMethod)) {
            substitutor = PsiSubstitutor.EMPTY;
        } else {
            PsiClass baseClass = baseMethod.getContainingClass();
            PsiClass derivedClass = derivedMethod.getContainingClass();
            if (baseClass != null && derivedClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)derivedClass, (PsiClass)baseClass, (boolean)true)) {
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)derivedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                MethodSignature superMethodSignature = baseMethod.getSignature(superClassSubstitutor);
                MethodSignature methodSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
                PsiSubstitutor superMethodSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superMethodSignature);
                substitutor = superMethodSubstitutor != null ? superMethodSubstitutor : superClassSubstitutor;
            } else {
                substitutor = PsiSubstitutor.EMPTY;
            }
        }
        return substitutor;
    }

    private static void processParameterUsage(PsiReferenceExpression ref, String oldName, String newName) throws IncorrectOperationException {
        PsiElement last = ref.getReferenceNameElement();
        if (last instanceof PsiIdentifier && last.getText().equals(oldName)) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)ref.getProject()).getElementFactory();
            PsiIdentifier newNameIdentifier = factory.createIdentifier(newName);
            last.replace((PsiElement)newNameIdentifier);
        }
    }

    private void fixJavadocsForChangedMethod(PsiMethod method) throws IncorrectOperationException {
        ParameterInfoImpl[] newParms;
        PsiParameter[] parameters = method.getParameterList().getParameters();
        LOG.assertTrue(parameters.length == (newParms = this.myChangeInfo.newParms).length);
        HashSet newParameters = new HashSet();
        for (int i = 0; i < newParms.length; ++i) {
            ParameterInfoImpl newParm = newParms[i];
            if (newParm.oldParameterIndex >= 0 && newParm.getName().equals(this.myChangeInfo.oldParameterNames[newParm.oldParameterIndex])) continue;
            newParameters.add(parameters[i]);
        }
        RefactoringUtil.fixJavadocsForParams(method, (Set<PsiParameter>)newParameters);
    }

    private static class ThrowsList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiReferenceList, PsiJavaCodeReferenceElement> {
        public static final ThrowsList INSTANCE = new ThrowsList();

        private ThrowsList() {
        }

        @Override
        public List<PsiJavaCodeReferenceElement> getChildren(PsiReferenceList throwsList) {
            return Arrays.asList(throwsList.getReferenceElements());
        }
    }

    private static class ParameterList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiParameterList, PsiParameter> {
        public static final ParameterList INSTANCE = new ParameterList();

        private ParameterList() {
        }

        @Override
        public List<PsiParameter> getChildren(PsiParameterList psiParameterList) {
            return Arrays.asList(psiParameterList.getParameters());
        }
    }

    private static class ExpressionList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiExpressionList, PsiExpression> {
        public static final ExpressionList INSTANCE = new ExpressionList();

        private ExpressionList() {
        }

        @Override
        public List<PsiExpression> getChildren(PsiExpressionList psiExpressionList) {
            return Arrays.asList(psiExpressionList.getExpressions());
        }
    }

    private static class RenamedParameterCollidesWithLocalUsageInfo
    extends UnresolvableCollisionUsageInfo {
        private final PsiElement myCollidingElement;
        private final PsiMethod myMethod;

        public RenamedParameterCollidesWithLocalUsageInfo(PsiParameter parameter, PsiElement collidingElement, PsiMethod method) {
            super((PsiElement)parameter, collidingElement);
            this.myCollidingElement = collidingElement;
            this.myMethod = method;
        }

        @Override
        public String getDescription() {
            return RefactoringBundle.message((String)"there.is.already.a.0.in.the.1.it.will.conflict.with.the.renamed.parameter", (Object[])new Object[]{RefactoringUIUtil.getDescription(this.myCollidingElement, true), RefactoringUIUtil.getDescription((PsiElement)this.myMethod, true)});
        }
    }

    private static class MyParameterUsageInfo
    extends UsageInfo {
        final String oldParameterName;
        final String newParameterName;

        public MyParameterUsageInfo(PsiElement element, String oldParameterName, String newParameterName) {
            super(element);
            this.oldParameterName = oldParameterName;
            this.newParameterName = newParameterName;
        }
    }
}

