/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IntroduceTargetChooser {
    private IntroduceTargetChooser() {
    }

    public static <T extends PsiElement> void showChooser(Editor editor, List<T> expressions, final Pass<T> callback, final Function<T, String> renderer) {
        final ScopeHighlighter highlighter = new ScopeHighlighter(editor);
        final DefaultListModel<PsiElement> model = new DefaultListModel<PsiElement>();
        for (PsiElement expr : expressions) {
            model.addElement(expr);
        }
        final JList<Object> list = new JList<Object>(model);
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                PsiElement expr = (PsiElement)value;
                if (expr.isValid()) {
                    this.setText((String)renderer.fun((Object)expr));
                }
                return rendererComponent;
            }
        });
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                highlighter.dropHighlight();
                int index = list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                PsiElement expr = (PsiElement)model.get(index);
                ArrayList<PsiElement> toExtract = new ArrayList<PsiElement>();
                toExtract.add(expr);
                highlighter.highlight(expr, toExtract);
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder(list).setTitle("Expressions").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                callback.pass((Object)((PsiElement)list.getSelectedValue()));
            }
        }).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                highlighter.dropHighlight();
            }
        }).createPopup().showInBestPositionFor(editor);
    }
}

