/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.daemon.QuickFixProvider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.lookup.LookupElementFactory;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.pom.xml.impl.events.XmlAttributeSetImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDecl;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeImpl
extends XmlElementImpl
implements XmlAttribute {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlAttributeImpl");
    private final int myHC = ourHC++;
    private volatile String myDisplayText = null;
    private volatile int[] myGapDisplayStarts = null;
    private volatile int[] myGapPhysicalStarts = null;
    private volatile TextRange myValueTextRange;

    public final int hashCode() {
        return this.myHC;
    }

    public XmlAttributeImpl() {
        super(XmlElementType.XML_ATTRIBUTE);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == XmlTokenType.XML_NAME) {
            return 229;
        }
        if (i == XmlElementType.XML_ATTRIBUTE_VALUE) {
            return 243;
        }
        return 0;
    }

    public XmlAttributeValue getValueElement() {
        return (XmlAttributeValue)XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this);
    }

    public void setValue(String valueText) throws IncorrectOperationException {
        final ASTNode value = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this);
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAttribute attribute = XmlElementFactory.getInstance((Project)this.getProject()).createXmlAttribute("a", valueText);
        final ASTNode newValue = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild((ASTNode)attribute);
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

            public PomModelEvent runInner() {
                XmlAttributeImpl att = XmlAttributeImpl.this;
                if (value != null) {
                    if (newValue != null) {
                        att.replaceChild(value, newValue.copyElement());
                    } else {
                        att.removeChild(value);
                    }
                } else if (newValue != null) {
                    att.addChild(newValue.copyElement());
                }
                return XmlAttributeSetImpl.createXmlAttributeSet(model, XmlAttributeImpl.this.getParent(), XmlAttributeImpl.this.getName(), newValue != null ? newValue.getText() : null);
            }
        });
    }

    public XmlElement getNameElement() {
        return (XmlElement)XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getNamespace() {
        String name = this.getName();
        String prefixByQualifiedName = XmlUtil.findPrefixByQualifiedName(name);
        if (prefixByQualifiedName.length() == 0) {
            return "";
        }
        String string = this.getParent().getNamespaceByPrefix(prefixByQualifiedName);
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlAttributeImpl.getNamespace must not return null");
        return string2;
    }

    @NonNls
    @NotNull
    public String getNamespacePrefix() {
        String string = XmlUtil.findPrefixByQualifiedName(this.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlAttributeImpl.getNamespacePrefix must not return null");
        }
        return string;
    }

    public XmlTag getParent() {
        PsiElement parentTag = super.getParent();
        return parentTag instanceof XmlTag ? (XmlTag)parentTag : null;
    }

    @NotNull
    public String getLocalName() {
        String string = XmlUtil.findLocalNameByQualifiedName(this.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlAttributeImpl.getLocalName must not return null");
        }
        return string;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlAttributeImpl.accept must not be null");
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttribute((XmlAttribute)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getValue() {
        XmlAttributeValue valueElement = this.getValueElement();
        return valueElement != null ? valueElement.getValue() : null;
    }

    public String getDisplayValue() {
        String displayText = this.myDisplayText;
        if (displayText != null) {
            return displayText;
        }
        XmlAttributeValue value = this.getValueElement();
        if (value == null) {
            return null;
        }
        PsiElement firstChild = value.getFirstChild();
        if (firstChild == null) {
            return null;
        }
        ASTNode child = firstChild.getNode();
        TextRange valueTextRange = new TextRange(0, value.getTextLength());
        if (child != null && child.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            valueTextRange = new TextRange(child.getTextLength(), valueTextRange.getEndOffset());
            child = child.getTreeNext();
        }
        TIntArrayList gapsStarts = new TIntArrayList();
        TIntArrayList gapsShifts = new TIntArrayList();
        StringBuilder buffer = new StringBuilder(this.getTextLength());
        while (child != null) {
            int start = buffer.length();
            IElementType elementType = child.getElementType();
            if (elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                valueTextRange = new TextRange(valueTextRange.getStartOffset(), child.getTextRange().getStartOffset() - value.getTextRange().getStartOffset());
                break;
            }
            if (elementType == XmlTokenType.XML_CHAR_ENTITY_REF) {
                buffer.append(XmlUtil.getCharFromEntityRef(child.getText()));
            } else if (elementType == XmlElementType.XML_ENTITY_REF) {
                buffer.append(XmlUtil.getEntityValue((XmlEntityRef)child));
            } else {
                buffer.append(child.getText());
            }
            int end = buffer.length();
            int originalLength = child.getTextLength();
            if (end - start != originalLength) {
                gapsStarts.add(start);
                gapsShifts.add(originalLength - (end - start));
            }
            child = child.getTreeNext();
        }
        int[] gapDisplayStarts = ArrayUtil.newIntArray((int)gapsShifts.size());
        int[] gapPhysicalStarts = ArrayUtil.newIntArray((int)gapsShifts.size());
        int currentGapsSum = 0;
        for (int i = 0; i < gapDisplayStarts.length; ++i) {
            gapDisplayStarts[i] = gapsStarts.get(i);
            gapPhysicalStarts[i] = gapDisplayStarts[i] + (currentGapsSum += gapsShifts.get(i));
        }
        this.myGapDisplayStarts = gapDisplayStarts;
        this.myGapPhysicalStarts = gapPhysicalStarts;
        this.myValueTextRange = valueTextRange;
        this.myDisplayText = buffer.toString();
        return this.myDisplayText;
    }

    public int physicalToDisplay(int physicalIndex) {
        this.getDisplayValue();
        if (physicalIndex < 0 || physicalIndex > this.myValueTextRange.getLength()) {
            return -1;
        }
        if (this.myGapPhysicalStarts.length == 0) {
            return physicalIndex;
        }
        int bsResult = Arrays.binarySearch(this.myGapPhysicalStarts, physicalIndex);
        int gapIndex = bsResult > 0 ? bsResult : (bsResult < -1 ? -bsResult - 2 : -1);
        if (gapIndex < 0) {
            return physicalIndex;
        }
        int shift = this.myGapPhysicalStarts[gapIndex] - this.myGapDisplayStarts[gapIndex];
        return Math.max(this.myGapDisplayStarts[gapIndex], physicalIndex - shift);
    }

    public int displayToPhysical(int displayIndex) {
        String displayValue = this.getDisplayValue();
        if (displayValue == null || displayIndex < 0 || displayIndex > displayValue.length()) {
            return -1;
        }
        if (this.myGapDisplayStarts.length == 0) {
            return displayIndex;
        }
        int bsResult = Arrays.binarySearch(this.myGapDisplayStarts, displayIndex);
        int gapIndex = bsResult > 0 ? bsResult - 1 : (bsResult < -1 ? -bsResult - 2 : -1);
        if (gapIndex < 0) {
            return displayIndex;
        }
        int shift = this.myGapPhysicalStarts[gapIndex] - this.myGapDisplayStarts[gapIndex];
        return displayIndex + shift;
    }

    public TextRange getValueTextRange() {
        this.getDisplayValue();
        return this.myValueTextRange;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myDisplayText = null;
        this.myGapDisplayStarts = null;
        this.myGapPhysicalStarts = null;
        this.myValueTextRange = null;
    }

    @Override
    @NotNull
    public String getName() {
        XmlElement element = this.getNameElement();
        String string = element != null ? element.getText() : "";
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlAttributeImpl.getName must not return null");
        }
        return string;
    }

    public boolean isNamespaceDeclaration() {
        String name = this.getName();
        return name.startsWith("xmlns:") || name.equals("xmlns");
    }

    public PsiElement setName(final @NotNull String nameText) throws IncorrectOperationException {
        if (nameText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlAttributeImpl.setName must not be null");
        }
        final ASTNode name = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(this);
        final String oldName = name.getText();
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAttribute attribute = XmlElementFactory.getInstance((Project)this.getProject()).createXmlAttribute(nameText, "");
        final ASTNode newName = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild((ASTNode)attribute);
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        model.runTransaction((PomTransaction)new PomTransactionBase((PsiElement)this.getParent(), (PomModelAspect)aspect){

            public PomModelEvent runInner() {
                PomModelEvent event = new PomModelEvent(model);
                XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(model, (XmlFile)XmlAttributeImpl.this.getContainingFile());
                xmlAspectChangeSet.add((XmlChange)new XmlAttributeSetImpl(XmlAttributeImpl.this.getParent(), oldName, null));
                xmlAspectChangeSet.add((XmlChange)new XmlAttributeSetImpl(XmlAttributeImpl.this.getParent(), nameText, XmlAttributeImpl.this.getValue()));
                event.registerChangeSet(model.getModelAspect(XmlAspect.class), (PomChangeSet)xmlAspectChangeSet);
                CodeEditUtil.replaceChild(XmlAttributeImpl.this, name, newName);
                return event;
            }
        });
        return this;
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] refs = this.getReferences();
        if (refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] refs;
        PsiReference[] psiReferenceArray;
        XmlTag parentElement = this.getParent();
        if (!(parentElement instanceof XmlTag)) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlAttributeImpl.getReferences must not return null");
            return psiReferenceArray;
        }
        PsiReference[] referencesFromProviders = ReferenceProvidersRegistry.getReferencesFromProviders(this, XmlAttribute.class);
        if (referencesFromProviders == null) {
            psiReferenceArray = new PsiReference[]{new MyPsiReference()};
            if (psiReferenceArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlAttributeImpl.getReferences must not return null");
            return psiReferenceArray;
        }
        if (this.isNamespaceDeclaration()) {
            refs = new PsiReference[referencesFromProviders.length + 1];
            String localName = this.getLocalName();
            String prefix = XmlUtil.findPrefixByQualifiedName(this.getName());
            TextRange range = prefix.length() == 0 ? TextRange.from((int)this.getName().length(), (int)0) : TextRange.from((int)(prefix.length() + 1), (int)localName.length());
            refs[0] = new SchemaPrefixReference(this, range, localName);
        } else {
            String prefix = this.getNamespacePrefix();
            if (prefix.length() > 0 && this.getLocalName().length() > 0) {
                refs = new PsiReference[referencesFromProviders.length + 2];
                refs[0] = new SchemaPrefixReference(this, TextRange.from((int)0, (int)prefix.length()), prefix);
                refs[1] = new MyPsiReference();
            } else {
                refs = new PsiReference[referencesFromProviders.length + 1];
                refs[0] = new MyPsiReference();
            }
        }
        System.arraycopy(referencesFromProviders, 0, refs, refs.length - referencesFromProviders.length, referencesFromProviders.length);
        psiReferenceArray = refs;
        if (refs != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlAttributeImpl.getReferences must not return null");
    }

    @Nullable
    public XmlAttributeDescriptor getDescriptor() {
        XmlTag parentElement = this.getParent();
        if (parentElement instanceof XmlDecl) {
            return null;
        }
        XmlTag tag = parentElement;
        XmlElementDescriptor descr = tag.getDescriptor();
        if (descr == null) {
            return null;
        }
        XmlAttributeDescriptor attributeDescr = descr.getAttributeDescriptor((XmlAttribute)this);
        return attributeDescr == null ? descr.getAttributeDescriptor(this.getName(), tag) : attributeDescr;
    }

    private String getRealLocalName() {
        String name = this.getLocalName();
        return name.endsWith("IntellijIdeaRulezzz") ? name.substring(0, name.length() - "IntellijIdeaRulezzz".length()) : name;
    }

    private class MyPsiReference
    implements PsiReference,
    QuickFixProvider {
        private final NullableLazyValue<XmlAttributeDescriptor> myDescriptor = new NullableLazyValue<XmlAttributeDescriptor>(){

            protected XmlAttributeDescriptor compute() {
                XmlTag parentElement = XmlAttributeImpl.this.getParent();
                XmlElementDescriptor descr = parentElement.getDescriptor();
                if (descr != null) {
                    return descr.getAttributeDescriptor((XmlAttribute)XmlAttributeImpl.this);
                }
                return null;
            }
        };

        private MyPsiReference() {
        }

        public PsiElement getElement() {
            return XmlAttributeImpl.this;
        }

        public TextRange getRangeInElement() {
            int nsLen;
            int parentOffset = XmlAttributeImpl.this.getNameElement().getStartOffsetInParent();
            return new TextRange(parentOffset + (nsLen += (nsLen = XmlAttributeImpl.this.getNamespacePrefix().length()) > 0 && XmlAttributeImpl.this.getRealLocalName().length() > 0 ? 1 : -nsLen), parentOffset + XmlAttributeImpl.this.getNameElement().getTextLength());
        }

        public PsiElement resolve() {
            XmlAttributeDescriptor descriptor = this.getDescriptor();
            return descriptor != null ? descriptor.getDeclaration() : null;
        }

        public String getCanonicalText() {
            return XmlAttributeImpl.this.getName();
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            XmlAttributeDescriptorEx xmlAttributeDescriptorEx;
            String s;
            String newName = newElementName;
            if (this.getDescriptor() instanceof XmlAttributeDescriptorEx && (s = (xmlAttributeDescriptorEx = (XmlAttributeDescriptorEx)this.getDescriptor()).handleTargetRename(newElementName)) != null) {
                String prefix = XmlAttributeImpl.this.getNamespacePrefix();
                newName = StringUtil.isEmpty((String)prefix) ? s : prefix + ":" + s;
            }
            return XmlAttributeImpl.this.setName(newName);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            PsiMetaOwner owner;
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlAttributeImpl$MyPsiReference.bindToElement must not be null");
            }
            if (element instanceof PsiMetaOwner && (owner = (PsiMetaOwner)element).getMetaData() instanceof XmlElementDescriptor) {
                XmlAttributeImpl.this.setName(owner.getMetaData().getName());
            }
            throw new IncorrectOperationException("Cant bind to not a xml element definition!");
        }

        public boolean isReferenceTo(PsiElement element) {
            return XmlAttributeImpl.this.getManager().areElementsEquivalent(element, this.resolve());
        }

        @NotNull
        public Object[] getVariants() {
            ArrayList<MutableLookupElement<String>> variants = new ArrayList<MutableLookupElement<String>>();
            XmlTag declarationTag = XmlAttributeImpl.this.getParent();
            LOG.assertTrue(declarationTag.isValid());
            XmlElementDescriptor parentDescriptor = declarationTag.getDescriptor();
            if (parentDescriptor != null) {
                XmlAttribute[] attributes = declarationTag.getAttributes();
                XmlAttributeDescriptor[] descriptors = parentDescriptor.getAttributesDescriptors(declarationTag);
                descriptors = HtmlUtil.appendHtmlSpecificAttributeCompletions(declarationTag, descriptors, XmlAttributeImpl.this);
                this.addVariants(variants, attributes, descriptors);
            }
            Object[] objectArray = variants.toArray();
            if (objectArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlAttributeImpl$MyPsiReference.getVariants must not return null");
            }
            return objectArray;
        }

        private void addVariants(Collection<MutableLookupElement<String>> variants, XmlAttribute[] attributes, XmlAttributeDescriptor[] descriptors) {
            XmlTag tag = XmlAttributeImpl.this.getParent();
            XmlExtension extension = XmlExtension.getExtension(tag.getContainingFile());
            String prefix = XmlAttributeImpl.this.getName().contains(":") && XmlAttributeImpl.this.getRealLocalName().length() > 0 ? XmlAttributeImpl.this.getNamespacePrefix() + ":" : null;
            for (XmlAttributeDescriptor descriptor : descriptors) {
                int separator;
                if (!this.isValidVariant(descriptor, attributes, extension)) continue;
                String name = descriptor.getName((PsiElement)tag);
                if (prefix != null && !name.startsWith(prefix)) continue;
                if (prefix != null && name.length() > prefix.length()) {
                    name = descriptor.getName((PsiElement)tag).substring(prefix.length());
                }
                MutableLookupElement element = LookupElementFactory.getInstance().createLookupElement(name);
                if (descriptor instanceof PsiPresentableMetaData) {
                    element.setIcon(((PsiPresentableMetaData)descriptor).getIcon());
                }
                if ((separator = name.indexOf(58)) > 0) {
                    element.addLookupStrings(new String[]{name.substring(separator + 1)});
                }
                element.setInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE);
                variants.add((MutableLookupElement<String>)element);
            }
        }

        private boolean isValidVariant(XmlAttributeDescriptor descriptor, XmlAttribute[] attributes, XmlExtension extension) {
            if (extension.isIndirectSyntax(descriptor)) {
                return false;
            }
            for (XmlAttribute attribute : attributes) {
                if (attribute == XmlAttributeImpl.this || !attribute.getName().equals(descriptor.getName())) continue;
                return false;
            }
            return true;
        }

        public boolean isSoft() {
            return this.getDescriptor() == null;
        }

        public void registerQuickfix(HighlightInfo info, PsiReference reference) {
            if (this.getDescriptor() instanceof QuickFixProvider) {
                ((QuickFixProvider)this.getDescriptor()).registerQuickfix(info, reference);
            }
        }

        @Nullable
        private XmlAttributeDescriptor getDescriptor() {
            return (XmlAttributeDescriptor)this.myDescriptor.getValue();
        }
    }
}

