/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.file.FileLookupInfoProvider;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileInfoManager
implements Disposable {
    private final Map<FileType, FileLookupInfoProvider> myFileType2InfoProvider = new HashMap();

    public FileInfoManager() {
        FileLookupInfoProvider[] providers;
        for (FileLookupInfoProvider provider : providers = (FileLookupInfoProvider[])FileLookupInfoProvider.EP_NAME.getExtensions()) {
            FileType[] types;
            for (FileType type : types = provider.getFileTypes()) {
                this.myFileType2InfoProvider.put(type, provider);
            }
        }
    }

    public static FileInfoManager getFileInfoManager() {
        return (FileInfoManager)ServiceManager.getService(FileInfoManager.class);
    }

    @Nullable
    public static Object getFileLookupItem(PsiElement psiElement) {
        if (!(psiElement instanceof PsiFile) || !psiElement.isPhysical()) {
            return psiElement;
        }
        PsiFile file = (PsiFile)psiElement;
        return FileInfoManager.getFileInfoManager()._getLookupItem(file, file.getName(), file.getIcon(0));
    }

    @Nullable
    public static String getFileAdditionalInfo(PsiElement psiElement) {
        return FileInfoManager.getFileInfoManager()._getInfo(psiElement);
    }

    @Nullable
    private String _getInfo(PsiElement psiElement) {
        VirtualFile virtualFile;
        if (!(psiElement instanceof PsiFile) || !psiElement.isPhysical()) {
            return null;
        }
        PsiFile psiFile = (PsiFile)psiElement;
        FileLookupInfoProvider provider = this.myFileType2InfoProvider.get(psiFile.getFileType());
        if (provider != null && (virtualFile = psiFile.getVirtualFile()) != null) {
            Pair info = provider.getLookupInfo(virtualFile, psiElement.getProject());
            return info == null ? null : (String)info.second;
        }
        return null;
    }

    @Nullable
    public static Object getFileLookupItem(PsiElement psiElement, String encoded, Icon icon) {
        if (!(psiElement instanceof PsiFile) || !psiElement.isPhysical()) {
            LookupItem<PsiElement> result = new LookupItem<PsiElement>(psiElement, encoded);
            result.setIcon(icon);
            return result;
        }
        return FileInfoManager.getFileInfoManager()._getLookupItem((PsiFile)psiElement, encoded, icon);
    }

    @Nullable
    public Object _getLookupItem(@NotNull PsiFile file, String name, Icon icon) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileInfoManager._getLookupItem must not be null");
        }
        LookupItem<PsiFile> result = new LookupItem<PsiFile>(file, name);
        result.setIcon(icon);
        String info = this._getInfo((PsiElement)file);
        if (info != null) {
            result.setTailText(String.format(" (%s)", info), true);
        }
        return result;
    }

    public void dispose() {
        this.myFileType2InfoProvider.clear();
    }
}

