/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.pom.references.PomReferenceProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.NamedObjectProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.SimpleProviderBinding;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ReflectionCache;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceProvidersRegistry
extends PsiReferenceRegistrar {
    private final ConcurrentMap<Class, SimpleProviderBinding> myBindingsMap = new ConcurrentWeakHashMap();
    private final ConcurrentMap<Class, NamedObjectProviderBinding> myNamedBindingsMap = new ConcurrentWeakHashMap();
    private MultiMap<Class, Class> myKnownSupers;
    private static final Comparator<Trinity<PsiReferenceProvider, ProcessingContext, Double>> PRIORITY_COMPARATOR = new Comparator<Trinity<PsiReferenceProvider, ProcessingContext, Double>>(){

        @Override
        public int compare(Trinity<PsiReferenceProvider, ProcessingContext, Double> o1, Trinity<PsiReferenceProvider, ProcessingContext, Double> o2) {
            return ((Double)o2.getThird()).compareTo((Double)o1.getThird());
        }
    };
    private final Project myProject;
    private static final NotNullLazyKey<ReferenceProvidersRegistry, Project> INSTANCE_CACHE = ServiceManager.createLazyKey(ReferenceProvidersRegistry.class);

    public static ReferenceProvidersRegistry getInstance(Project project) {
        return (ReferenceProvidersRegistry)((Object)INSTANCE_CACHE.getValue((UserDataHolder)project));
    }

    public ReferenceProvidersRegistry(Project project) {
        this.myProject = project;
        for (PsiReferenceContributor contributor : (PsiReferenceContributor[])Extensions.getExtensions((ExtensionPointName)PsiReferenceContributor.EP_NAME)) {
            contributor.registerReferenceProviders((PsiReferenceRegistrar)this);
        }
    }

    public void registerReferenceProvider(@Nullable ElementFilter elementFilter, @NotNull Class scope, @NotNull PsiReferenceProvider provider, double priority) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.registerReferenceProvider must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.registerReferenceProvider must not be null");
        }
        this.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement((Class)scope).and((ElementPattern)new FilterPattern(elementFilter)), provider, priority);
    }

    public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PomReferenceProvider<T> provider, double priority) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.registerReferenceProvider must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.registerReferenceProvider must not be null");
        }
    }

    public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PsiReferenceProvider provider, double priority) {
        SimpleProviderBinding<PsiReferenceProvider> binding;
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.registerReferenceProvider must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.registerReferenceProvider must not be null");
        }
        this.myKnownSupers = null;
        Class scope = pattern.getCondition().getInitialCondition().getAcceptedClass();
        final PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)ContainerUtil.findInstance((Iterable)pattern.getCondition().getConditions(), PsiNamePatternCondition.class);
        if (nameCondition != null) {
            ValuePatternCondition valueCondition = (ValuePatternCondition)ContainerUtil.findInstance((Iterable)nameCondition.getNamePattern().getCondition().getConditions(), ValuePatternCondition.class);
            if (valueCondition != null) {
                Collection strings = valueCondition.getValues();
                this.registerNamedReferenceProvider(ArrayUtil.toStringArray((Collection)strings), new NamedObjectProviderBinding(){

                    @Override
                    protected String getName(PsiElement position) {
                        return nameCondition.getPropertyValue((Object)position);
                    }
                }, scope, true, provider, priority, pattern);
                return;
            }
            CaseInsensitiveValuePatternCondition ciCondition = (CaseInsensitiveValuePatternCondition)ContainerUtil.findInstance((Iterable)nameCondition.getNamePattern().getCondition().getConditions(), CaseInsensitiveValuePatternCondition.class);
            if (ciCondition != null) {
                this.registerNamedReferenceProvider(ciCondition.getValues(), new NamedObjectProviderBinding(){

                    @Override
                    @Nullable
                    protected String getName(PsiElement position) {
                        return nameCondition.getPropertyValue((Object)position);
                    }
                }, scope, false, provider, priority, pattern);
                return;
            }
        }
        do {
            SimpleProviderBinding providerBinding;
            if ((providerBinding = (SimpleProviderBinding)this.myBindingsMap.get(scope)) != null) {
                providerBinding.registerProvider(provider, pattern, priority);
                return;
            }
            binding = new SimpleProviderBinding<PsiReferenceProvider>();
            binding.registerProvider(provider, pattern, priority);
        } while (this.myBindingsMap.putIfAbsent(scope, binding) != null);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void registerReferenceProvider(@Nullable ElementFilter elementFilter, @NotNull Class scope, @NotNull PsiReferenceProvider provider) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.registerReferenceProvider must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.registerReferenceProvider must not be null");
        }
        this.registerReferenceProvider(elementFilter, scope, provider, 0.0);
    }

    public void unregisterReferenceProvider(@NotNull Class scope, @NotNull PsiReferenceProvider provider) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.unregisterReferenceProvider must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.unregisterReferenceProvider must not be null");
        }
        ProviderBinding providerBinding = (ProviderBinding)this.myBindingsMap.get(scope);
        providerBinding.unregisterProvider(provider);
    }

    private void registerNamedReferenceProvider(String[] names, NamedObjectProviderBinding binding, Class scopeClass, boolean caseSensitive, PsiReferenceProvider provider, double priority, ElementPattern pattern) {
        NamedObjectProviderBinding providerBinding = (NamedObjectProviderBinding)this.myNamedBindingsMap.get(scopeClass);
        if (providerBinding == null) {
            providerBinding = (NamedObjectProviderBinding)ConcurrencyUtil.cacheOrGet(this.myNamedBindingsMap, (Object)scopeClass, (Object)binding);
        }
        providerBinding.registerProvider(names, pattern, caseSensitive, provider, priority);
    }

    public void registerReferenceProvider(@NotNull Class scope, @NotNull PsiReferenceProvider provider) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.registerReferenceProvider must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.registerReferenceProvider must not be null");
        }
        this.registerReferenceProvider(null, scope, provider);
    }

    @Deprecated
    public List<PsiReferenceProvider> getProvidersByElement(@NotNull PsiElement element, @NotNull Class clazz) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.getProvidersByElement must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.getProvidersByElement must not be null");
        }
        List<Trinity<PsiReferenceProvider, ProcessingContext, Double>> list = this.getPairsByElement(element, clazz);
        ArrayList<PsiReferenceProvider> providers = new ArrayList<PsiReferenceProvider>(list.size());
        for (Trinity<PsiReferenceProvider, ProcessingContext, Double> trinity : list) {
            providers.add((PsiReferenceProvider)trinity.getFirst());
        }
        return providers;
    }

    @NotNull
    public List<Trinity<PsiReferenceProvider, ProcessingContext, Double>> getPairsByElement(@NotNull PsiElement element, @NotNull Class clazz) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.getPairsByElement must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.getPairsByElement must not be null");
        }
        assert (ReflectionCache.isInstance((Object)element, (Class)clazz));
        MultiMap knownSupers = this.myKnownSupers;
        if (knownSupers == null) {
            knownSupers = new MultiMap();
            THashSet allClasses = new THashSet();
            allClasses.addAll(this.myBindingsMap.keySet());
            allClasses.addAll(this.myNamedBindingsMap.keySet());
            for (Class ancestor : allClasses) {
                for (Class descendant : allClasses) {
                    if (!ancestor.isAssignableFrom(descendant)) continue;
                    knownSupers.putValue((Object)descendant, (Object)ancestor);
                }
            }
            this.myKnownSupers = knownSupers;
        }
        SmartList ret = null;
        for (Class aClass : knownSupers.get((Object)clazz)) {
            SimpleProviderBinding simpleBinding = (SimpleProviderBinding)this.myBindingsMap.get(aClass);
            NamedObjectProviderBinding namedBinding = (NamedObjectProviderBinding)this.myNamedBindingsMap.get(aClass);
            if (simpleBinding == null && namedBinding == null) continue;
            if (ret == null) {
                ret = new SmartList();
            }
            if (simpleBinding != null) {
                simpleBinding.addAcceptableReferenceProviders(element, ret, (Integer)null);
            }
            if (namedBinding == null) continue;
            namedBinding.addAcceptableReferenceProviders(element, ret, (Integer)null);
        }
        List<Object> list = ret == null ? Collections.emptyList() : ret;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.getPairsByElement must not return null");
        }
        return list;
    }

    public static PsiReference[] getReferencesFromProviders(PsiElement context, @NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.getReferencesFromProviders must not be null");
        }
        ProgressManager.checkCanceled();
        assert (context.isValid()) : "Invalid context: " + context;
        List<Trinity<PsiReferenceProvider, ProcessingContext, Double>> providers = ReferenceProvidersRegistry.getInstance(context.getProject()).getPairsByElement(context, clazz);
        if (providers.isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (providers.size() == 1) {
            Trinity<PsiReferenceProvider, ProcessingContext, Double> firstProvider = providers.get(0);
            return ((PsiReferenceProvider)firstProvider.getFirst()).getReferencesByElement(context, (ProcessingContext)firstProvider.getSecond());
        }
        ((SmartList)providers).sort(PRIORITY_COMPARATOR);
        if (LegacyCompletionContributor.DEBUG) {
            System.out.println("ReferenceProvidersRegistry.getReferencesFromProviders");
            System.out.println("providers = " + providers);
        }
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        double maxPriority = (Double)providers.get(0).getThird();
        block0: for (Trinity<PsiReferenceProvider, ProcessingContext, Double> trinity : providers) {
            PsiReference[] refs = ((PsiReferenceProvider)trinity.getFirst()).getReferencesByElement(context, (ProcessingContext)trinity.getSecond());
            if ((Double)trinity.getThird() != maxPriority) {
                for (PsiReference ref : refs) {
                    for (PsiReference reference : result) {
                        if (ref == null || !reference.getRangeInElement().contains(ref.getRangeInElement())) continue;
                        continue block0;
                    }
                }
            }
            for (PsiReference ref : refs) {
                if (ref == null) continue;
                result.add(ref);
            }
        }
        return (PsiReference[])ContainerUtil.toArray(result, (Object[])new PsiReference[result.size()]);
    }
}

